/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.constant.DetailMatchNodeEnum;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.frame.MatchDetailInfo;
import kd.ebg.aqap.common.framework.services.ObjectPropertyOpService;
import kd.ebg.aqap.common.framework.utils.DetailUniqueUtils;
import kd.ebg.aqap.common.framework.utils.MatchDetailUtils;
import kd.ebg.aqap.common.model.DetailExtraField;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.DetailInfoArchive;
import kd.ebg.aqap.common.model.DetailSyncRecord;
import kd.ebg.aqap.common.model.repository.DetailExtraFieldRepository;
import kd.ebg.aqap.common.model.repository.DetailInfoArchiveRepository;
import kd.ebg.aqap.common.model.repository.DetailInfoRepository;
import kd.ebg.aqap.common.model.repository.DetailSyncRecordRepository;
import kd.ebg.aqap.common.utils.BankUniqueSeqUtil;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageRequest;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.model.data.Sort;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Service
public class DetailInfoService {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailInfoService.class);
    private static final String ORDER_TIME_STR = "000001";
    private static final String UPD_BY_SYS_UNIQUE_VERSION = "999";
    private DetailInfoRepository detailInfoRepository;
    private DetailSyncRecordRepository detailSyncRecordRepository;
    @Autowired
    private DetailInfoArchiveRepository detailInfoArchiveRepository;

    public DetailInfoService(DetailInfoRepository detailInfoRepository, DetailSyncRecordRepository detailSyncRecordRepository) {
        this.detailInfoRepository = detailInfoRepository;
        this.detailSyncRecordRepository = detailSyncRecordRepository;
    }

    public static DetailInfoService getInstance() {
        return SpringContextUtil.getBean(DetailInfoService.class);
    }

    public long countDetail() {
        return 0L;
    }

    public Page<DetailInfo> selectForPage(String customID, String bankVersionID, String accNo, String currency, LocalDate startDate, LocalDate endDate, int page, int pageSize, boolean isFromEbgPage, Integer isKeyRepeat) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)customID), (Object)ResManager.loadKDString((String)"customID \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailInfoService_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)bankVersionID), (Object)ResManager.loadKDString((String)"bankVersionID \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailInfoService_1", (String)"ebg-aqap-common", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)accNo), (Object)ResManager.loadKDString((String)"accNo \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailInfoService_2", (String)"ebg-aqap-common", (Object[])new Object[0]));
        Preconditions.checkArgument((!currency.isEmpty() ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"currency \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailInfoService_3", (String)"ebg-aqap-common", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)Objects.nonNull(startDate), (Object)ResManager.loadKDString((String)"startDate \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailInfoService_4", (String)"ebg-aqap-common", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)Objects.nonNull(endDate), (Object)ResManager.loadKDString((String)"endDate \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailInfoService_5", (String)"ebg-aqap-common", (Object[])new Object[0]));
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "sort_field"), new Sort.Order(Sort.Direction.ASC, "detail_id")});
        PageRequest pageRequest = PageRequest.of((int)(page - 1), (int)pageSize, (Sort)sort);
        Page<DetailInfo> detailInfoPage = this.detailInfoRepository.findByCustomIDAndBankVersionIDAndAccNoAndCurrencyAndTransDateBetween(customID, bankVersionID, accNo, currency, startDate, endDate, (Pageable)pageRequest, isFromEbgPage, isKeyRepeat);
        return detailInfoPage;
    }

    public Page<DetailInfo> selectForPageAllowNull(String customID, String bankVersionID, String accNo, String currency, LocalDate startDate, LocalDate endDate, Integer isKeyRepeat, List<QFilter> rowQFilters, int page, int pageSize, String sortInfo) {
        Sort sort = StringUtils.isNotEmpty((String)sortInfo) ? Sort.by((String[])new String[]{sortInfo.replace(",id desc", ",sort_field asc, detail_id asc")}) : Sort.by((String[])new String[]{"sort_field asc, detail_id asc"});
        PageRequest pageRequest = PageRequest.of((int)(page - 1), (int)pageSize, (Sort)sort);
        Page<DetailInfo> detailInfoPage = this.detailInfoRepository.findByCustomIDAndBankVersionIDAndAccNoAndCurrencyAndTransDateBetweenAllowNull(customID, bankVersionID, accNo, currency, startDate, endDate, isKeyRepeat, rowQFilters, (Pageable)pageRequest);
        return detailInfoPage;
    }

    public List<DetailInfo> select(String accNo, String bankVersionID, LocalDate startDate, LocalDate endDate) {
        return this.detailInfoRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionID, startDate, endDate);
    }

    public List<DetailInfo> selectAllStatus(String accNo, String bankVersionID, LocalDate startDate, LocalDate endDate) {
        return this.detailInfoRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionID, startDate, endDate, null);
    }

    public void setExtraFields(List<DetailInfo> detailInfos, BankAcnt acnt) {
        DetailExtraFieldRepository detailExtraFieldRepository = SpringContextUtil.getBean(DetailExtraFieldRepository.class);
        String bankVersionID = acnt.getBankVersionId();
        List<DetailExtraField> detailExtraFields = detailExtraFieldRepository.findByBankVersionID(bankVersionID);
        for (int i = 0; i < detailInfos.size(); ++i) {
            String jsonStr = detailInfos.get(i).getJsonMap();
            Map jsonMap = (Map)JsonUtil.fromJson((String)jsonStr, Map.class);
            JSONObject extraFields = new JSONObject();
            for (DetailExtraField d : detailExtraFields) {
                if (jsonMap.containsKey(d.getExtra_field())) {
                    extraFields.put(d.getExtra_field(), jsonMap.get(d.getExtra_field()));
                    continue;
                }
                extraFields.put(d.getExtra_field(), (Object)"");
            }
            detailInfos.get(i).setReversed4(extraFields.toJSONString());
        }
    }

    private static long getOrderStartTimeMillis(LocalDateTime transTime) {
        String transDateStr = LocalDateUtil.formatDate((LocalDateTime)transTime);
        String tempDateStr = transDateStr + ORDER_TIME_STR;
        try {
            Date tempDate = DateTimeUtils.parseDate((String)tempDateStr, (String)"yyyyMMddHHmmss");
            return tempDate.getTime();
        }
        catch (ParseException e) {
            logger.info("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public void insertOrUpdate(List<DetailInfo> detailInfos, BankAcnt acnt, String customID, LocalDate startDate, LocalDate endDate) {
        if (CollectionUtils.isEmpty(detailInfos)) {
            return;
        }
        this.setExtraFields(detailInfos, acnt);
        this.setCustomNote(detailInfos);
        boolean notExitsSortField = StringUtils.isEmpty((String)detailInfos.get(0).getSortField());
        LocalDateTime headDate = detailInfos.get(0).getTransTime();
        long timeMillis = DetailInfoService.getOrderStartTimeMillis(headDate);
        for (DetailInfo info : detailInfos) {
            BigDecimal crebitAmount = info.getCreditAmount();
            if (crebitAmount != null && crebitAmount.compareTo(new BigDecimal("0.00")) > 0) {
                info.setPayBankDetailSeqID("");
                info.setKdFlag("");
            }
            if (!notExitsSortField) continue;
            LocalDateTime tempDate = info.getTransTime();
            if (!tempDate.toLocalDate().equals(headDate.toLocalDate()) && tempDate.isAfter(headDate)) {
                headDate = tempDate;
                timeMillis = DetailInfoService.getOrderStartTimeMillis(headDate);
            }
            info.setSortField(String.valueOf(++timeMillis));
        }
        long startTime = System.currentTimeMillis();
        String detailUniqueVersion = BankBundleManager.getInstance().getBankVersionInfo(acnt.getBankVersionId()).getDetailUniqueVersion();
        LocalDateTime insertTime = LocalDateTime.now();
        insertTime = insertTime.minusNanos(insertTime.getNano());
        LocalDate temp = LocalDate.from(startDate);
        while (temp.isBefore(endDate) || temp.isEqual(endDate)) {
            LocalDate finalTemp = temp;
            this.insertOrUpdate(detailInfos.stream().filter(d -> finalTemp.equals(d.getTransDate())).collect(Collectors.toList()), acnt, customID, temp, insertTime, detailUniqueVersion);
            temp = temp.plusDays(1L);
        }
        long endTime = System.currentTimeMillis();
        logger.info("\u8d26\u53f7{}\u4ece\u65e5\u671f{}\u5230{}\u7684\u4ea4\u6613\u660e\u7ec6\u8bb0\u5f55\u66f4\u65b0\u5b8c\u6bd5\uff0c\u8017\u65f6{}\u6beb\u79d2", new Object[]{acnt.getAccNo(), startDate, endDate, endTime - startTime});
    }

    private void setCustomNote(List<DetailInfo> detailInfos) {
        QFilter queryKDRuleFilter;
        DynamicObject dynamicObject;
        QFilter filter;
        DynamicObject loadData;
        String customNoteField = "";
        String detail_impl = (String)EBContext.getContext().getRunningParams().get("detail_impl");
        String bankVersionID = EBContext.getContext().getBankVersionID();
        Long interfaceId = null;
        if (StringUtils.isNotEmpty((String)detail_impl) && (loadData = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_pay_interface", (String)"id", (QFilter[])(filter = QFilter.of((String)"group.number = ? and class_name = ?", (Object[])new Object[]{bankVersionID, detail_impl})).toArray())) != null) {
            interfaceId = loadData.getLong("id");
        }
        StringBuilder sb = new StringBuilder();
        if (interfaceId != null) {
            sb.append("(detail_interface = ? or bank_version = ?) and status = ? and enable = ?");
        } else {
            sb.append("bank_version = ? and status = ? and enable = ?");
        }
        QFilter filter2 = interfaceId != null ? QFilter.of((String)sb.toString(), (Object[])new Object[]{interfaceId, bankVersionID, "C", "1"}) : QFilter.of((String)sb.toString(), (Object[])new Object[]{bankVersionID, "C", "1"});
        DynamicObject detailNoteConfig = BusinessDataServiceHelper.loadSingle((String)"aqap_detail_note_config", (String)"field_name", (QFilter[])filter2.toArray());
        if (detailNoteConfig != null) {
            customNoteField = detailNoteConfig.getString("field_name");
        } else {
            ObjectPropertyOpService objectPropertyService = SpringContextUtil.getBean(ObjectPropertyOpService.class);
            customNoteField = objectPropertyService.getCustomNoteField(bankVersionID);
        }
        if (StringUtils.isEmpty((String)customNoteField)) {
            return;
        }
        String finalCustomNoteField = customNoteField;
        String kdFlag = "";
        if (interfaceId != null && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_reconciliation_rule", (String)"kd_flag", (QFilter[])(queryKDRuleFilter = QFilter.of((String)"group.number = ? and interface_code = ?", (Object[])new Object[]{bankVersionID, interfaceId})).toArray())) != null) {
            kdFlag = dynamicObject.getString("kd_flag");
        }
        String finalKdFlag = kdFlag;
        detailInfos.stream().forEach(detailInfo -> {
            int i;
            String jsonStr = detailInfo.getJsonMap();
            if (StringUtils.isEmpty((String)jsonStr)) {
                return;
            }
            Map jsonMap = (Map)JsonUtil.fromJson((String)jsonStr, Map.class);
            StringBuilder explaintion = new StringBuilder();
            List<Object> fields = new ArrayList(5);
            boolean and = true;
            if (finalCustomNoteField.contains(",")) {
                fields = Arrays.asList(finalCustomNoteField.split(","));
            } else if (finalCustomNoteField.contains("/")) {
                and = false;
                fields = Arrays.asList(finalCustomNoteField.split("/"));
            } else {
                fields.add(finalCustomNoteField);
            }
            if (and) {
                for (i = 0; i < fields.size(); ++i) {
                    String value = (String)jsonMap.get(fields.get(i));
                    if (!StringUtils.isNotEmpty((String)value)) continue;
                    if (StringUtils.isNotEmpty((String)finalKdFlag) && value.contains(finalKdFlag)) {
                        try {
                            value = value.substring(value.indexOf(finalKdFlag) + finalKdFlag.length());
                        }
                        catch (Exception e) {
                            logger.error("\u6458\u8981\u622a\u53d6\u5bf9\u8d26\u7801\u5f02\u5e38,\u8fd4\u56de\u539f\u59cb\u6458\u8981", (Throwable)e);
                        }
                    }
                    explaintion.append(value).append(",");
                }
            } else {
                for (i = 0; i < fields.size(); ++i) {
                    String value = (String)jsonMap.get(fields.get(i));
                    if (!StringUtils.isNotEmpty((String)value)) continue;
                    try {
                        value = value.substring(value.indexOf(finalKdFlag) + finalKdFlag.length());
                    }
                    catch (Exception e) {
                        logger.error("\u6458\u8981\u622a\u53d6\u5bf9\u8d26\u7801\u5f02\u5e38,\u8fd4\u56de\u539f\u59cb\u6458\u8981", (Throwable)e);
                    }
                    explaintion.append(value).append(",");
                    break;
                }
            }
            if (StringUtils.isNotEmpty((String)explaintion.toString())) {
                String explain = explaintion.substring(0, explaintion.length() - 1);
                detailInfo.setExplanation(explain);
            }
        });
    }

    public void insertOrUpdate(List<DetailInfo> fromBankList, BankAcnt acnt, String customID, LocalDate date, LocalDateTime insertTime, String detailUniqueVersion) {
        if (CollectionUtils.isEmpty(fromBankList)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        List<DetailInfo> fromDBList = this.selectAllStatus(acnt.getAccNo(), acnt.getBankVersionId(), date, date);
        long endTime = System.currentTimeMillis();
        fromDBList.stream().forEach(detailInfo -> detailInfo.setSys("firstMatch", ""));
        boolean exitsUnique = !StringUtils.isEmpty((String)detailUniqueVersion);
        ArrayList<DetailInfo> notMatch = new ArrayList(16);
        if (exitsUnique) {
            notMatch = this.uniqueMatch(fromBankList, fromDBList, insertTime, detailUniqueVersion);
        } else {
            fromBankList.forEach(b -> {
                b.setUniqueSeq("");
                b.setIsKeyRepeat(CosmicConstants.DETAIL_IS_KEY_REPEAT_N);
            });
            notMatch = this.fieldMatch(fromBankList, fromDBList, insertTime);
        }
        this.deepMatch(notMatch, fromDBList, insertTime);
        long allEndTime = System.currentTimeMillis();
    }

    private List<DetailInfo> uniqueMatch(List<DetailInfo> fromBankList, List<DetailInfo> fromDBList, LocalDateTime insertTime, String detailUniqueVersion) {
        ArrayList<DetailInfo> notMatchDetailList = new ArrayList<DetailInfo>(fromBankList.size());
        ArrayList<DetailInfo> firstAddList = new ArrayList<DetailInfo>(fromBankList.size());
        ArrayList<DetailInfo> fieldDetailList = new ArrayList<DetailInfo>(fromBankList.size());
        ArrayList<DetailInfo> updateList = new ArrayList<DetailInfo>(fromBankList.size());
        this.buildUniqueInfos(fromBankList);
        this.clearRepeatRecordKey(fromBankList);
        if (CollectionUtils.isEmpty(fromDBList) && !CollectionUtils.isEmpty(fromBankList)) {
            this.insertAll(fromBankList, insertTime, DetailMatchNodeEnum.KEY_NOT_MATCH.getId());
            logger.info("\u94f6\u884c\u4e3b\u952e\u5339\u914d\uff1a\u8d26\u53f7{}\u5728\u65e5\u671f{}\u4e8e\u6570\u636e\u5e93\u4e2d\u65e0\u6570\u636e\uff0c\u76f4\u63a5\u63d2\u5165\u94f6\u884c\u8fd4\u56de\u7684\u660e\u7ec6{}\u6761", new Object[]{fromBankList.get(0).getAccNo(), fromBankList.get(0).getTransDate(), fromBankList.size()});
            return notMatchDetailList;
        }
        int matchFlag = this.buildDetailMatchFlag(fromBankList, fromDBList, detailUniqueVersion);
        List filterList = fromDBList.stream().filter(d -> !StringUtils.equals((String)d.getSys("firstMatch"), (String)"true")).collect(Collectors.toList());
        Map fromDbMap = filterList.stream().collect(Collectors.toMap(DetailInfo::getUniqueSeq, detailInfo -> detailInfo, (oldValue, newValue) -> newValue, TreeMap::new));
        block6: for (int i = 0; i < fromBankList.size(); ++i) {
            DetailInfo bankDetail = fromBankList.get(i);
            switch (matchFlag) {
                case 1: {
                    DetailInfo detailInfo2 = this.method1(bankDetail, fromDbMap, firstAddList, insertTime);
                    if (detailInfo2 == null) continue block6;
                    updateList.add(detailInfo2);
                    continue block6;
                }
                case 2: {
                    this.method2(bankDetail, fieldDetailList);
                    continue block6;
                }
                case 3: {
                    if (!UPD_BY_SYS_UNIQUE_VERSION.equalsIgnoreCase(bankDetail.getUniqueVersion())) {
                        DetailInfo detailInfo1 = this.method3(bankDetail, fromDbMap, fieldDetailList, insertTime);
                        if (detailInfo1 == null) continue block6;
                        updateList.add(detailInfo1);
                        continue block6;
                    }
                    if ("true".equalsIgnoreCase(bankDetail.getSys("isRealKeyRepeat"))) {
                        this.method2(bankDetail, fieldDetailList);
                        continue block6;
                    }
                    DetailInfo detailInfo2 = this.method3(bankDetail, fromDbMap, fieldDetailList, insertTime);
                    if (detailInfo2 == null) continue block6;
                    updateList.add(detailInfo2);
                    continue block6;
                }
                case 4: {
                    this.method4(fromBankList.get(0).getAccNo(), fromBankList.get(0).getTransDate());
                    return notMatchDetailList;
                }
            }
        }
        long start = System.currentTimeMillis();
        if (updateList != null && updateList.size() > 0) {
            int pageSize = 1000;
            if (updateList.size() <= pageSize) {
                this.detailInfoRepository.updateAll(updateList);
            } else {
                for (int startIndex = 0; startIndex < updateList.size(); startIndex += pageSize) {
                    int endIndex = startIndex + pageSize;
                    if (endIndex > updateList.size()) {
                        endIndex = updateList.size();
                    }
                    List<DetailInfo> temp = updateList.subList(startIndex, endIndex);
                    this.detailInfoRepository.updateAll(temp);
                }
            }
            long end = System.currentTimeMillis();
            logger.info("\u94f6\u884c\u4e3b\u952e\u5339\u914d\u66f4\u65b0{}\u6761\u660e\u7ec6\u8017\u65f6:{}\u6beb\u79d2", new Object[]{updateList.size(), end - start});
        }
        long start1 = System.currentTimeMillis();
        if (firstAddList != null && firstAddList.size() > 0) {
            this.detailInfoRepository.saveAll(firstAddList);
            long end1 = System.currentTimeMillis();
            logger.info("\u94f6\u884c\u4e3b\u952e\u5339\u914d\u63d2\u5165{}\u6761\u660e\u7ec6\u8017\u65f6:{}\u6beb\u79d2", new Object[]{firstAddList.size(), end1 - start1});
        }
        logger.info("\u94f6\u884c\u4e3b\u952e\u5339\u914d\u66f4\u65b0\uff1a{} \u6761\u660e\u7ec6, \u63d2\u5165: {} \u6761\u660e\u7ec6", new Object[]{updateList.size(), firstAddList.size()});
        if (fieldDetailList.size() > 0) {
            logger.info("\u94f6\u884c\u4e3b\u952e\u5339\u914d\u65b9\u6cd5\uff0c\u8fdb\u5165\u5168\u91cf\u5c5e\u6027\u5339\u914d\uff1a{}\u6761\u660e\u7ec6", (Object)fieldDetailList.size());
            return this.fieldMatch(fieldDetailList, fromDBList, insertTime);
        }
        return notMatchDetailList;
    }

    private List<DetailInfo> fieldMatch(List<DetailInfo> fromBankList, List<DetailInfo> fromDBList, LocalDateTime insertTime) {
        if (CollectionUtils.isEmpty(fromDBList) && !CollectionUtils.isEmpty(fromBankList)) {
            this.insertAll(fromBankList, insertTime, DetailMatchNodeEnum.NOT_MATCH.getId());
            logger.info("\u5168\u91cf\u5c5e\u6027\u5339\u914d\uff1a\u8d26\u53f7{}\u5728\u65e5\u671f{}\u4e8e\u6570\u636e\u5e93\u4e2d\u65e0\u6570\u636e\uff0c\u76f4\u63a5\u63d2\u5165\u94f6\u884c\u8fd4\u56de\u7684\u660e\u7ec6{}\u6761", new Object[]{fromBankList.get(0).getAccNo(), fromBankList.get(0).getTransDate(), fromBankList.size()});
            return new ArrayList<DetailInfo>(16);
        }
        ArrayList notMatchDetail = Lists.newArrayList();
        ArrayList fieldMatchUpdateList = Lists.newArrayList();
        for (int i = 0; i < fromBankList.size(); ++i) {
            DetailInfo detail = fromBankList.get(i);
            int serialNo = 1;
            if (StrUtil.isBlank((CharSequence)detail.getOppAccNo())) {
                detail.setOppAccNo("");
            }
            for (int j = 0; j < i; ++j) {
                if (!this.equalsInBatch(detail, fromBankList.get(j))) continue;
                ++serialNo;
            }
            detail.setSerialNo(serialNo);
            DetailInfo oldDetail = null;
            if (!"".equals(detail.getOppAccNo())) {
                oldDetail = this.select(fromDBList, detail);
                if (Objects.nonNull(oldDetail)) {
                    this.doIsConfirmData(detail, oldDetail);
                    if ("true".equalsIgnoreCase(detail.getSys("isRealKeyRepeat")) && "true".equalsIgnoreCase(oldDetail.getSys("isRealKeyRepeat"))) {
                        if (!oldDetail.getUniqueSeq().equalsIgnoreCase(detail.getUniqueSeq())) {
                            logger.info("\u56e0\u4e3a\u94f6\u884c\u8bb0\u5f55\u53ca\u6570\u636e\u5e93\u8bb0\u5f55\u7684\u5747\u4e3a\u7591\u4f3c\u91cd\u590d\uff0c\u6240\u4ee5\u672c\u6b21\u66f4\u65b0\u7684\u94f6\u884c\u4e3b\u952e\u4ee5\u6570\u636e\u5e93({})\u7684\u4e3a\u51c6\uff0c\u4e0d\u7528\u94f6\u884c\u7684\u7684\u6700\u65b0\u4e3b\u952e({})\uff0c\u907f\u514d\u8fdd\u53cd\u552f\u4e00\u7ea6\u675f", new Object[]{oldDetail.getUniqueSeq(), detail.getUniqueSeq()});
                        }
                        detail.setUniqueSeq(oldDetail.getUniqueSeq());
                    }
                    FieldUtils.mergeField((Object)detail, (Object)oldDetail);
                    detail.setUpdateTime(insertTime);
                    detail.setSys("firstMatch", "true");
                    oldDetail.setSys("firstMatch", "true");
                    detail.setMatchNode(DetailMatchNodeEnum.FULL_MATCH.getId());
                    fieldMatchUpdateList.add(detail);
                    continue;
                }
                notMatchDetail.add(detail);
                continue;
            }
            notMatchDetail.add(detail);
        }
        if (fieldMatchUpdateList != null && fieldMatchUpdateList.size() > 0) {
            this.detailInfoRepository.updateAll(fieldMatchUpdateList);
            logger.info("\u5168\u91cf\u5c5e\u6027\u5339\u914d\u66f4\u65b0 : {} \u6761\u660e\u7ec6 ", (Object)fieldMatchUpdateList.size());
        }
        if (notMatchDetail.size() > 0) {
            logger.info("\u5168\u91cf\u5c5e\u6027\u672a\u5339\u914d\uff0c\u8fdb\u5165\u6df1\u5ea6\u5339\u914d : {} \u6761\u660e\u7ec6 ", (Object)notMatchDetail.size());
        }
        return notMatchDetail;
    }

    private void deepMatch(List<DetailInfo> fromBankList, List<DetailInfo> detailFromDB, LocalDateTime insertTime) {
        if (Objects.isNull(fromBankList) || fromBankList.isEmpty()) {
            return;
        }
        int updateCount = 0;
        int insertCount = 0;
        ListIterator<DetailInfo> infoIterator = detailFromDB.listIterator();
        while (infoIterator.hasNext()) {
            DetailInfo detailInfo2 = (DetailInfo)infoIterator.next();
            String firstMatch = detailInfo2.getSys("firstMatch");
            if (!StringUtils.equals((String)firstMatch, (String)"true")) continue;
            infoIterator.remove();
        }
        ArrayList<DetailInfo> updateDetails = new ArrayList<DetailInfo>(1);
        ArrayList<DetailInfo> insertDetails = new ArrayList<DetailInfo>(1);
        if (detailFromDB.size() == 0 && fromBankList.size() > 0) {
            logger.info("\u6570\u636e\u5e93\u4e2d\u65e0\u6570\u636e(\u6216\u8005\u65e0\u672a\u5339\u914d\u6570\u636e)\uff0c\u76f4\u63a5\u63d2\u5165\u94f6\u884c\u8fd4\u56de\u660e\u7ec6{}\u6761", (Object)fromBankList.size());
            this.insertAll(fromBankList, insertTime, DetailMatchNodeEnum.NOT_MATCH.getId());
            logger.info("\u6570\u636e\u5e93\u4e2d\u65e0\u6570\u636e(\u6216\u8005\u65e0\u672a\u5339\u914d\u6570\u636e)\uff0c\u6210\u529f\u63d2\u5165\u94f6\u884c\u8fd4\u56de\u660e\u7ec6{}\u6761", (Object)fromBankList.size());
            return;
        }
        ArrayList matchDetails = new ArrayList(1);
        ArrayList<MatchDetailInfo> tempMatchDetails = new ArrayList<MatchDetailInfo>(1);
        for (DetailInfo bankDetail : fromBankList) {
            for (DetailInfo detailInfo3 : detailFromDB) {
                MatchDetailInfo matchDetailInfo = MatchDetailUtils.createMatchDetail(detailInfo3, bankDetail);
                if (matchDetailInfo.getScore() <= 0) continue;
                tempMatchDetails.add(matchDetailInfo);
            }
            if (tempMatchDetails.size() > 0) {
                matchDetails.addAll(tempMatchDetails);
                tempMatchDetails.clear();
                continue;
            }
            bankDetail.setId(Sequence.gen18Sequence());
            bankDetail.setInsertTime(insertTime);
            bankDetail.setUpdateTime(insertTime);
            bankDetail.setMatchNode(DetailMatchNodeEnum.NOT_MATCH.getId());
            bankDetail.setSerialNo(1);
            if (StringUtils.isEmpty((String)bankDetail.getUniqueSeq())) {
                bankDetail.setUniqueSeq(bankDetail.getId());
            }
            insertDetails.add(bankDetail);
            bankDetail.setSys("deal", "true");
            ++insertCount;
        }
        Collections.sort(matchDetails);
        Iterator iterator = matchDetails.iterator();
        while (iterator.hasNext()) {
            MatchDetailInfo matchDetailInfo = (MatchDetailInfo)iterator.next();
            DetailInfo bankDetail = matchDetailInfo.getDetailInfoBank();
            DetailInfo dbDetail = matchDetailInfo.getDetailInfoDb();
            String bankDeal = bankDetail.getSys("deal");
            String dbDeal = dbDetail.getSys("deal");
            if (StringUtils.isEmpty((String)bankDeal) && StringUtils.isEmpty((String)dbDeal)) {
                this.doIsConfirmData(bankDetail, dbDetail);
                if ("true".equalsIgnoreCase(bankDetail.getSys("isRealKeyRepeat")) && "true".equalsIgnoreCase(dbDetail.getSys("isRealKeyRepeat"))) {
                    bankDetail.setUniqueSeq(dbDetail.getUniqueSeq());
                }
                FieldUtils.mergeField((Object)bankDetail, (Object)dbDetail);
                bankDetail.setUpdateTime(insertTime);
                bankDetail.setMatchNode(DetailMatchNodeEnum.DEEP_MATCH.getId());
                updateDetails.add(bankDetail);
                bankDetail.setSys("deal", "true");
                dbDetail.setSys("deal", "true");
                iterator.remove();
                ++updateCount;
                continue;
            }
            if (!StringUtils.isNotEmpty((String)bankDeal)) continue;
            iterator.remove();
        }
        for (MatchDetailInfo matchDetailInfo : matchDetails) {
            DetailInfo bankDetail = matchDetailInfo.getDetailInfoBank();
            DetailInfo dbDetail = matchDetailInfo.getDetailInfoDb();
            String bankDeal = bankDetail.getSys("deal");
            String dbDeal = dbDetail.getSys("deal");
            if (!StringUtils.isEmpty((String)bankDeal) || !StringUtils.isNotEmpty((String)dbDeal)) continue;
            bankDetail.setId(Sequence.gen18Sequence());
            bankDetail.setInsertTime(insertTime);
            bankDetail.setUpdateTime(insertTime);
            bankDetail.setSerialNo(1);
            bankDetail.setMatchNode(DetailMatchNodeEnum.NOT_MATCH.getId());
            if (StringUtils.isEmpty((String)bankDetail.getUniqueSeq())) {
                bankDetail.setUniqueSeq(bankDetail.getId());
            }
            insertDetails.add(bankDetail);
            bankDetail.setSys("deal", "true");
            ++insertCount;
        }
        updateDetails.stream().forEach(detailInfo -> detailInfo.setSys("deal", ""));
        insertDetails.stream().forEach(detailInfo -> detailInfo.setSys("deal", ""));
        this.detailInfoRepository.updateAll(updateDetails);
        this.detailInfoRepository.saveAll(insertDetails);
        logger.info("\u6570\u636e\u5e93\u67e5\u51fa\u672a\u66f4\u65b0\u7684\u6570\u636e(\u6216\u8005\u672a\u5339\u914d\u6570\u636e){}\u6761\uff0c\u7ecf\u8fc7\u6df1\u5ea6\u5339\u914d\u540e \u5b8c\u6210\u66f4\u65b0\uff1a{} \u6761, \u5b8c\u6210\u63d2\u5165: {} \u6761", new Object[]{detailFromDB.size(), updateCount, insertCount});
    }

    int buildDetailMatchFlag(List<DetailInfo> fromBankList, List<DetailInfo> fromDBList, String uniqueVersion) {
        boolean dbExits999;
        boolean dbExitsOld;
        boolean bl = dbExitsOld = fromDBList.stream().filter(d -> !UPD_BY_SYS_UNIQUE_VERSION.equals(d.getUniqueVersion()) && !uniqueVersion.equals(d.getUniqueVersion())).count() > 0L;
        if (dbExitsOld) {
            List<DetailSyncRecord> detailSyncRecords = this.detailSyncRecordRepository.findByCustomIDAndAccNoAndSyncDate(fromBankList.get(0).getCustomID(), fromBankList.get(0).getAccNo(), fromBankList.get(0).getTransDate());
            if (CollectionUtils.isEmpty(detailSyncRecords) || detailSyncRecords.get(0).getIsCompleted().equals(CosmicConstants.DETAIL_RECORD_NOT_COMPLETED)) {
                return 2;
            }
            return 4;
        }
        boolean bankExits999 = fromBankList.stream().filter(d -> UPD_BY_SYS_UNIQUE_VERSION.equals(d.getUniqueVersion())).count() > 0L;
        boolean dbExitsNew = fromDBList.stream().filter(d -> uniqueVersion.equals(d.getUniqueVersion())).count() > 0L;
        boolean bl2 = dbExits999 = fromDBList.stream().filter(d -> UPD_BY_SYS_UNIQUE_VERSION.equals(d.getUniqueVersion())).count() > 0L;
        if (!bankExits999 && dbExitsNew && !dbExits999) {
            return 1;
        }
        return 3;
    }

    DetailInfo method1(DetailInfo bankDetail, Map<String, DetailInfo> fromDBMap, List<DetailInfo> firstAddList, LocalDateTime insertTime) {
        DetailInfo detailInfo = this.select(fromDBMap, bankDetail.getUniqueSeq());
        if (detailInfo != null) {
            return this.update(detailInfo, bankDetail, insertTime);
        }
        bankDetail.setId(Sequence.gen18Sequence());
        bankDetail.setInsertTime(insertTime);
        bankDetail.setUpdateTime(insertTime);
        bankDetail.setSerialNo(1);
        bankDetail.setMatchNode(DetailMatchNodeEnum.KEY_NOT_MATCH.getId());
        firstAddList.add(bankDetail);
        return null;
    }

    void method2(DetailInfo bankDetail, List<DetailInfo> fieldDetailList) {
        fieldDetailList.add(bankDetail);
    }

    DetailInfo method3(DetailInfo bankDetail, Map<String, DetailInfo> fromDBMap, List<DetailInfo> fieldDetailList, LocalDateTime insertTime) {
        DetailInfo detailInfo = this.select(fromDBMap, bankDetail.getUniqueSeq());
        if (detailInfo != null) {
            return this.update(detailInfo, bankDetail, insertTime);
        }
        this.method2(bankDetail, fieldDetailList);
        return null;
    }

    void method4(String accno, LocalDate transDate) {
        logger.info("\u94f6\u884c\u4e3b\u952e\u5339\u914d\uff1a\u8d26\u53f7{}\u5728\u65e5\u671f{}\u5b58\u5728\u5386\u53f2\u94f6\u884c\u4e3b\u952e\uff0c\u4e0d\u4f5c\u6570\u636e\u5e93\u66f4\u65b0\uff0c\u76f4\u63a5\u8fd4\u56de\u4e4b\u524d\u7684\u6570\u636e\u5e93\u8bb0\u5f55", new Object[]{accno, transDate});
    }

    DetailInfo update(DetailInfo dbDetail, DetailInfo bankDetail, LocalDateTime insertTime) {
        LocalDateTime oldInsertTime = dbDetail.getInsertTime();
        String oldID = dbDetail.getId();
        int oldSerialNo = dbDetail.getSerialNo();
        bankDetail.setId(oldID);
        this.doIsConfirmData(bankDetail, dbDetail);
        FieldUtils.fieldsCopy((Object)bankDetail, (Object)dbDetail);
        dbDetail.setInsertTime(oldInsertTime);
        dbDetail.setSerialNo(oldSerialNo);
        dbDetail.setUpdateTime(insertTime);
        dbDetail.setSys("firstMatch", "true");
        dbDetail.setMatchNode(DetailMatchNodeEnum.KEY_MATCH.getId());
        FieldUtils.fieldsCopy((Object)dbDetail, (Object)bankDetail);
        return dbDetail;
    }

    void insertAll(List<DetailInfo> fromBankList, LocalDateTime insertTime, Integer matchNode) {
        if (CollectionUtils.isEmpty(fromBankList)) {
            return;
        }
        for (DetailInfo detailInfo2 : fromBankList) {
            detailInfo2.setId(Sequence.gen18Sequence());
            detailInfo2.setInsertTime(insertTime);
            detailInfo2.setUpdateTime(insertTime);
            if (detailInfo2.getSerialNo() == null) {
                detailInfo2.setSerialNo(1);
            }
            detailInfo2.setMatchNode(matchNode);
            if (!StringUtils.isEmpty((String)detailInfo2.getUniqueSeq())) continue;
            detailInfo2.setUniqueSeq(detailInfo2.getId());
        }
        fromBankList.stream().forEach(detailInfo -> detailInfo.setSys("deal", ""));
        this.detailInfoRepository.saveAll(fromBankList);
    }

    public void doIsConfirmData(DetailInfo fromBank, DetailInfo fromDB) {
        if ("1".equals(fromDB.getIsConfirm())) {
            fromBank.setIsKeyRepeat(fromDB.getIsKeyRepeat());
            fromBank.setIsConfirm(fromDB.getIsConfirm());
        }
    }

    private List<DetailInfo> selectByNotUpdateTimeAndCommon(LocalDateTime updateTime, String bankVersionID, String accNo, LocalDate startDate, LocalDate endDate) {
        return this.detailInfoRepository.findByAccNoAndBankVersionIDAndTransDateBetweenAndUpdateTimeNot(accNo, bankVersionID, startDate, endDate, updateTime);
    }

    private void buildUniqueInfo(List<DetailInfo> fromBank) {
        if (!CollectionUtils.isEmpty(fromBank)) {
            DetailUniqueUtils utils = DetailUniqueUtils.getInstance();
            for (DetailInfo detailInfo : fromBank) {
                utils.buildDetailUniqueSeq(detailInfo);
            }
        }
    }

    private void buildUniqueInfos(List<DetailInfo> fromBank) {
        if (!CollectionUtils.isEmpty(fromBank)) {
            DetailUniqueUtils utils = DetailUniqueUtils.getInstance();
            utils.buildDetailUniqueSeq(fromBank);
        }
    }

    private void clearRepeatRecordKey(List<DetailInfo> fromBank) {
        if (!CollectionUtils.isEmpty(fromBank)) {
            HashMap repeatGroupMap = new HashMap(1);
            HashMap<String, Integer> detailInfoMap = new HashMap<String, Integer>(1);
            for (int i = 0; i < fromBank.size(); ++i) {
                DetailInfo detailInfo = fromBank.get(i);
                detailInfo.setIsKeyRepeat(CosmicConstants.DETAIL_IS_KEY_REPEAT_N);
                detailInfo.setIsConfirm("0");
                if (!StringUtils.isNotEmpty((String)detailInfo.getUniqueSeq())) continue;
                String uniqueSeq = detailInfo.getUniqueSeq();
                if (detailInfoMap.get(uniqueSeq) != null) {
                    if (repeatGroupMap.get(uniqueSeq) == null) {
                        ArrayList<Object> indexList = new ArrayList<Object>(1);
                        indexList.add(detailInfoMap.get(uniqueSeq));
                        indexList.add(i);
                        repeatGroupMap.put(uniqueSeq, indexList);
                        logger.info("\u68c0\u67e5{}\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u660e\u7ec6\uff0c\u4e0b\u6807{}\u548c{}\uff0c\u53d1\u73b02\u4e2a\u91cd\u590d\u4e3b\u952e\uff1a{}", new Object[]{detailInfo.getBankVersionID(), detailInfoMap.get(uniqueSeq), i, uniqueSeq});
                        continue;
                    }
                    ((List)repeatGroupMap.get(uniqueSeq)).add(i);
                    logger.info("\u68c0\u67e5{}\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u660e\u7ec6\uff0c\u4e0b\u6807{}\uff0c\u53d1\u73b0{}\u4e2a\u91cd\u590d\u4e3b\u952e\uff1a{}", new Object[]{detailInfo.getBankVersionID(), i, ((List)repeatGroupMap.get(uniqueSeq)).size(), uniqueSeq});
                    continue;
                }
                detailInfoMap.put(uniqueSeq, i);
            }
            if (!CollectionUtils.isEmpty(repeatGroupMap)) {
                for (Map.Entry uniqueSeqEntry : repeatGroupMap.entrySet()) {
                    DetailInfo detail;
                    List indexList = (List)uniqueSeqEntry.getValue();
                    HashMap<String, Integer> noMap = new HashMap<String, Integer>(1);
                    HashMap<String, Integer> newSeqIndexMap = new HashMap<String, Integer>(1);
                    for (Integer index : indexList) {
                        detail = fromBank.get(index);
                        String newUniqueSeq = detail.getUniqueSeq() + '|' + detail.getOppAccNo() + '|' + BankUniqueSeqUtil.parseNumber(detail.getDebitAmount()) + '|' + BankUniqueSeqUtil.parseNumber(detail.getCreditAmount()) + '|' + detail.getCurrency();
                        if (noMap.get(newUniqueSeq) != null) {
                            int no = (Integer)noMap.get(newUniqueSeq) + 1;
                            if (no == 2) {
                                int firstIndex = (Integer)newSeqIndexMap.get(newUniqueSeq);
                                DetailInfo firstDetail = fromBank.get(firstIndex);
                                firstDetail.setUniqueSeq(newUniqueSeq + '|' + 1);
                                firstDetail.setUniqueVersion(UPD_BY_SYS_UNIQUE_VERSION);
                                firstDetail.setIsKeyRepeat(CosmicConstants.DETAIL_IS_KEY_REPEAT_N);
                                firstDetail.setSys("isRealKeyRepeat", "true");
                                firstDetail.setSerialNo(1);
                                logger.info("{}\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\uff0c\u4e0b\u6807{}\uff0c\u8ffd\u52a0\u5168\u91cf\u660e\u7ec6\u5c5e\u6027\u4ecd\u7136\u91cd\u590d\uff0c\u8ffd\u52a0\u6d41\u6c34\u53f7\uff0c\u5e76\u7f6e\u4e3a\u4e3b\u952e\u91cd\u590d\uff1a{}", new Object[]{firstDetail.getBankVersionID(), firstIndex, firstDetail.getUniqueSeq()});
                            }
                            noMap.put(newUniqueSeq, no);
                            detail.setUniqueSeq(newUniqueSeq + '|' + no);
                            detail.setUniqueVersion(UPD_BY_SYS_UNIQUE_VERSION);
                            detail.setSerialNo(no);
                            detail.setSys("isRealKeyRepeat", "true");
                            boolean isKeyRepeat = this.isKeyRepeatByBalance(fromBank, index, indexList);
                            if (isKeyRepeat) {
                                detail.setIsKeyRepeat(CosmicConstants.DETAIL_IS_KEY_REPEAT_Y);
                                logger.info("{}\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\uff0c\u4e0b\u6807{}\uff0c\u8ffd\u52a0\u5168\u91cf\u660e\u7ec6\u5c5e\u6027\u4ecd\u7136\u91cd\u590d\uff0c\u8ffd\u52a0\u6d41\u6c34\u53f7\uff0c\u5e76\u7f6e\u4e3a\u4e3b\u952e\u91cd\u590d\uff1a{}", new Object[]{detail.getBankVersionID(), index, detail.getUniqueSeq()});
                                continue;
                            }
                            detail.setIsKeyRepeat(CosmicConstants.DETAIL_IS_KEY_REPEAT_N);
                            detail.setReversed3("1");
                            logger.info("{}\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\uff0c\u4e0b\u6807{}\uff0c\u8ffd\u52a0\u5168\u91cf\u660e\u7ec6\u5c5e\u6027\u4ecd\u7136\u91cd\u590d\uff0c\u8ffd\u52a0\u6d41\u6c34\u53f7\uff0c\u6839\u636e\u4f59\u989d\u6bd4\u8f83\u4e0d\u76f8\u540c\uff0c\u7f6e\u4e3a\u975e\u7591\u4f3c\u91cd\u590d\uff1a{}", new Object[]{detail.getBankVersionID(), index, detail.getUniqueSeq()});
                            continue;
                        }
                        noMap.put(newUniqueSeq, 1);
                        newSeqIndexMap.put(newUniqueSeq, index);
                        detail.setUniqueSeq(newUniqueSeq);
                        detail.setUniqueVersion(UPD_BY_SYS_UNIQUE_VERSION);
                    }
                    for (Integer index : indexList) {
                        detail = fromBank.get(index);
                        if ("true".equalsIgnoreCase(detail.getSys("isRealKeyRepeat"))) continue;
                        logger.info("{}\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\uff0c\u4e0b\u6807{}\uff0c\u8ffd\u52a0\u5168\u91cf\u660e\u7ec6\u5c5e\u6027\u4e0d\u518d\u91cd\u590d\uff1a{}", new Object[]{detail.getBankVersionID(), index, detail.getUniqueSeq()});
                    }
                }
            }
        }
    }

    private boolean isKeyRepeatByBalance(List<DetailInfo> fromBank, Integer outIndex, List<Integer> indexList) {
        DetailInfo outDetail = fromBank.get(outIndex);
        if (Objects.isNull(outDetail.getBalance())) {
            return true;
        }
        boolean isKeyRepeat = true;
        for (Integer innerIndex : indexList) {
            if (innerIndex >= outIndex) break;
            DetailInfo innerDetail = fromBank.get(innerIndex);
            if (Objects.isNull(innerDetail.getBalance())) continue;
            if (outDetail.getBalance().compareTo(innerDetail.getBalance()) == 0) {
                isKeyRepeat = true;
                break;
            }
            isKeyRepeat = false;
        }
        return isKeyRepeat;
    }

    private DetailInfo select(List<DetailInfo> toSearch, DetailInfo toSelect) {
        ArrayList<DetailInfo> matchList = new ArrayList<DetailInfo>(16);
        for (DetailInfo detail : toSearch) {
            boolean match;
            String firstMatch = detail.getSys("firstMatch");
            if (StringUtils.equals((String)firstMatch, (String)"true") || !(match = StrUtil.equals((String)detail.getBankVersionID(), (String)toSelect.getBankVersionID()) && StrUtil.equals((String)detail.getAccNo(), (String)toSelect.getAccNo()) && StrUtil.equals((String)detail.getOppAccNo(), (String)toSelect.getOppAccNo()) && StrUtil.equals((String)detail.getOppAccName(), (String)toSelect.getOppAccName()) && detail.getBalance() != null && detail.getBalance().equals(toSelect.getBalance()) && StrUtil.equals((String)(detail.getExplanation() == null ? null : detail.getExplanation().trim()), toSelect.getExplanation() == null ? null : toSelect.getExplanation().trim()) && StrUtil.equals((String)detail.getDebitAmount().toString(), (String)toSelect.getDebitAmount().toString()) && StrUtil.equals((String)detail.getCreditAmount().toString(), (String)toSelect.getCreditAmount().toString()) && StrUtil.equals((String)detail.getCurrency(), (String)toSelect.getCurrency()) && StrUtil.equals((String)detail.getTransDate().toString(), (String)toSelect.getTransDate().toString()) && StrUtil.equals((String)detail.getBankDetailNo(), (String)toSelect.getBankDetailNo()) && detail.getSerialNo().equals(toSelect.getSerialNo()))) continue;
            if (StringUtils.isEmpty((String)toSelect.getUniqueSeq())) {
                return detail;
            }
            matchList.add(detail);
        }
        if (CollectionUtil.isEmpty(matchList)) {
            return null;
        }
        if (matchList.size() > 1) {
            for (DetailInfo matchDetail : matchList) {
                if (!toSelect.getIsKeyRepeat().equals(matchDetail.getIsKeyRepeat())) continue;
                return matchDetail;
            }
        }
        return (DetailInfo)matchList.get(0);
    }

    private DetailInfo select(Map<String, DetailInfo> toSearch, String uniqueSeq) {
        return toSearch.get(uniqueSeq);
    }

    public boolean equalsInBatch(DetailInfo detailInfo1, DetailInfo detailInfo2) {
        Preconditions.checkNotNull((Object)detailInfo1);
        Preconditions.checkNotNull((Object)detailInfo2);
        boolean isSame = StrUtil.equals((String)detailInfo1.getBankVersionID(), (String)detailInfo2.getBankVersionID()) && StrUtil.equals((String)detailInfo1.getAccNo(), (String)detailInfo2.getAccNo()) && StrUtil.equals((String)detailInfo1.getOppAccNo(), (String)detailInfo2.getOppAccNo()) && StrUtil.equals((String)detailInfo1.getOppAccName(), (String)detailInfo2.getOppAccName()) && detailInfo1.getBalance() != null && detailInfo1.getBalance().equals(detailInfo2.getBalance()) && StrUtil.equals((String)(detailInfo1.getExplanation() == null ? null : detailInfo1.getExplanation().trim()), detailInfo2.getExplanation() == null ? null : detailInfo2.getExplanation().trim()) && StrUtil.equals((String)detailInfo1.getDebitAmount().toString(), (String)detailInfo2.getDebitAmount().toString()) && StrUtil.equals((String)detailInfo1.getCreditAmount().toString(), (String)detailInfo2.getCreditAmount().toString()) && StrUtil.equals((String)detailInfo1.getCurrency(), (String)detailInfo2.getCurrency()) && StrUtil.equals((String)detailInfo1.getTransDate().toString(), (String)detailInfo2.getTransDate().toString()) && StrUtil.equals((String)detailInfo1.getBankDetailNo(), (String)detailInfo2.getBankDetailNo());
        return isSame;
    }

    public void dealSync(BankAcnt acnt, String customID, LocalDate startDate, LocalDate endDate) {
        LocalDate temp = LocalDate.from(startDate);
        while (temp.isBefore(endDate) || temp.isEqual(endDate)) {
            DetailSyncRecord record = new DetailSyncRecord();
            record.setId(Sequence.genSequence());
            record.setAccNo(acnt.getAccNo());
            record.setSyncDate(temp);
            record.setCustomID(customID);
            record.setDetailCount(0);
            this.detailSyncRecordRepository.save(record);
            temp = temp.plusDays(1L);
        }
    }

    public void archiveDetailInfo(LocalDateTime dateTime) {
        int page = 1;
        int totalPage = 1;
        int pageSize = 1000;
        do {
            PageRequest pageRequest = PageRequest.of((int)(page - 1), (int)pageSize);
            Page<DetailInfo> detailPage = this.detailInfoRepository.findByInsertTimeBefore(dateTime, (Pageable)pageRequest);
            totalPage = detailPage.getTotalPages();
            List detailInfos = detailPage.getContent();
            logger.info("\u51c6\u5907\u5f52\u6863\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\uff1a" + detailInfos.size());
            ArrayList<DetailInfoArchive> detailInfoArchives = new ArrayList<DetailInfoArchive>(16);
            for (DetailInfo detailInfo : detailInfos) {
                DetailInfoArchive detailInfoArchive = new DetailInfoArchive();
                FieldUtils.fieldsCopy((Object)detailInfo, (Object)detailInfoArchive);
                detailInfoArchive.setArchiveTime(LocalDateTime.now());
                detailInfoArchives.add(detailInfoArchive);
            }
            if (detailInfoArchives.size() <= 0) continue;
            this.detailInfoArchiveRepository.saveAll(detailInfoArchives);
            logger.info("\u5df2\u7ecf\u5f52\u6863\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\uff1a" + detailInfoArchives.size());
        } while (++page < totalPage);
        if (totalPage > 0) {
            this.detailInfoRepository.deleteByInsertTimeBefore(dateTime);
        }
    }

    public DetailInfo findDetailInfoByKDFlagId(String kdflagId) {
        return this.detailInfoRepository.findDetailInfoByKDFlagId(kdflagId);
    }

    public List<DetailInfo> findDetailInfoListByKDFlagIds(List<String> kdflagIds) {
        return this.detailInfoRepository.findDetailInfoListByKDFlagIds(kdflagIds);
    }
}

