/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.utils;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class ParserUtils {
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100.00");
    public static final BigDecimal ZERO = new BigDecimal("0.00");

    public static BigDecimal convertCentStr2Yuan(String s) {
        if (s == null) {
            return null;
        }
        if (s.equals("")) {
            return null;
        }
        return new BigDecimal(s.trim()).divide(ONE_HUNDRED, 2, 0);
    }

    public static void checkRspCode(BankResponse rsp, String successCode) {
        if (!successCode.equals(rsp.getResponseCode())) {
            EBContext context = EBContext.getContext();
            String bankName = context.getBankAcnt().getBankName();
            String bizName = context.getBizName();
            String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u8d26\u53f7%2$s\u3002", (String)"ParserUtils_8", (String)"ebg-aqap-common", (Object[])new Object[0]), bankName, context.getBankAcnt().getAccNo() + bizName) + String.format(ResManager.loadKDString((String)"\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%s", (String)"ParserUtils_9", (String)"ebg-aqap-common", (Object[])new Object[0]), rsp.getResponseCode() + " " + rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
    }

    public static void checkRspCode(BankAcnt acnt, String bizName, BankResponse rsp, String successCode) {
        if (!successCode.equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u8d26\u53f7%2$s\u3002", (String)"ParserUtils_8", (String)"ebg-aqap-common", (Object[])new Object[0]), ParserUtils.nullAsBlank(acnt.getBankName()), ParserUtils.nullAsBlank(acnt.getAccNo()) + ParserUtils.nullAsBlank(bizName)) + String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u64cd\u4f5c\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%s", (String)"ParserUtils_10", (String)"ebg-aqap-common", (Object[])new Object[0]), rsp.getResponseCode() + " " + rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
    }

    private static String nullAsBlank(String msg) {
        return StringUtils.isEmpty((String)msg) ? "" : msg;
    }

    public static String checkUnNullableElementUnTrim(Element parent, String childName) {
        String childValue = parent.getChildText(childName);
        if (StringUtils.isEmpty((String)childValue)) {
            EBContext context = EBContext.getContext();
            String bankName = context.getBankAcnt().getBankName();
            String bizName = context.getBizName();
            throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"%1$s\u8fd4\u56de\u62a5\u6587\u683c\u5f0f\u9519\u8bef,%2$s", (String)"ParserUtils_11", (String)"ebg-aqap-common", (Object[])new Object[0]), bankName + bizName, parent.getName()) + String.format(ResManager.loadKDString((String)"\u4e2d\u4e0d\u542b%s\u8282\u70b9\u3002", (String)"ParserUtils_12", (String)"ebg-aqap-common", (Object[])new Object[0]), childName)));
        }
        return childValue;
    }

    public static String checkUnNullableElement(Element parent, String childName) {
        String childValue = parent.getChildTextTrim(childName);
        if (StringUtils.isEmpty((String)childValue)) {
            EBContext context = EBContext.getContext();
            String bankName = context.getBankAcnt().getBankName();
            String bizName = context.getBizName();
            throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"%1$s\u8fd4\u56de\u62a5\u6587\u683c\u5f0f\u9519\u8bef%2$s", (String)"ParserUtils_13", (String)"ebg-aqap-common", (Object[])new Object[0]), bankName + bizName, parent.getName()) + "\uff0c" + String.format(ResManager.loadKDString((String)"\u4e2d\u4e0d\u542b%s\u8282\u70b9\u3002", (String)"ParserUtils_12", (String)"ebg-aqap-common", (Object[])new Object[0]), childName)));
        }
        return childValue;
    }

    public static String getUnNullElementTextValue(Element parent, String childName, String tips) {
        String childValue = parent.getChildTextTrim(childName);
        if (null == childValue) {
            EBContext context = EBContext.getContext();
            String bankName = context.getBankAcnt().getBankName();
            String bizName = context.getBizName();
            throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"%1$s\u8fd4\u56de\u62a5\u6587\u683c\u5f0f\u9519\u8bef,%2$s", (String)"ParserUtils_11", (String)"ebg-aqap-common", (Object[])new Object[0]), bankName + bizName, parent.getName()) + String.format(ResManager.loadKDString((String)"\u4e2d\u4e0d\u542b%1$s(%2$s)\u8282\u70b9\u3002", (String)"ParserUtils_14", (String)"ebg-aqap-common", (Object[])new Object[0]), childName, tips)));
        }
        return childValue;
    }

    public static Element getUnNullChildElement(Element parent, String childName) {
        Element child = parent.getChild(childName);
        if (null == child) {
            EBContext context = EBContext.getContext();
            String bankName = context.getBankAcnt().getBankName();
            String bizName = context.getBizName();
            throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"%1$s\u8fd4\u56de\u62a5\u6587\u683c\u5f0f\u9519\u8bef,%2$s", (String)"ParserUtils_11", (String)"ebg-aqap-common", (Object[])new Object[0]), bankName + bizName, parent.getName()) + String.format(ResManager.loadKDString((String)"\u4e2d\u4e0d\u542b%s\u5143\u7d20.", (String)"ParserUtils_15", (String)"ebg-aqap-common", (Object[])new Object[0]), childName)));
        }
        return child;
    }
}

