/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.ExtentableModel;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailInfo
extends ExtentableModel {
    private String id;
    private String customID;
    private String bankVersionID;
    private String bankLoginID;
    private String implClassName;
    private LocalDateTime insertTime;
    private LocalDateTime updateTime;
    private BigDecimal debitAmount;
    private BigDecimal creditAmount;
    private String currency;
    private LocalDate transDate;
    private Integer serialNo;
    private Boolean isHistory;
    private String explanation;
    private LocalDateTime transTime;
    private String transType;
    private String useCN;
    private BigDecimal balance;
    private String accNo;
    private String extraAccNo;
    private String accName;
    private String bankName;
    private String oppAccNo;
    private String oppAccName;
    private String oppBankName;
    private String accType;
    private String sortID;
    private String bizRefNo;
    private String kdFlag;
    private String agentAccNo;
    private String agentAccName;
    private String agentAccBankName;
    private String busType;
    private String receiptNo;
    private String vouhNo;
    private String isConfirm;
    private BigDecimal availableBalance;
    private String bankDetailNo;
    private String uniqueSeq;
    private String uniqueVersion;
    private String sortField;
    private Integer isKeyRepeat;
    private Integer matchNode;
    private String payBankDetailSeqID;
    private BigDecimal transferCharge;
    private String jsonMap;
    private String thirdBankName;
    private String frmcod;

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getThirdBankName() {
        return this.thirdBankName;
    }

    public void setThirdBankName(String thirdBankName) {
        this.thirdBankName = thirdBankName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void setIsConfirm(String isConfirm) {
        this.isConfirm = isConfirm;
    }

    public String getIsConfirm() {
        return this.isConfirm;
    }

    public String getBankDetailNo() {
        return this.bankDetailNo;
    }

    public void setBankDetailNo(String bankDetailNo) {
        this.bankDetailNo = bankDetailNo;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCustomID() {
        return this.customID;
    }

    public void setCustomID(String customID) {
        this.customID = customID;
    }

    public String getBankVersionID() {
        return this.bankVersionID;
    }

    public void setBankVersionID(String bankVersionID) {
        this.bankVersionID = bankVersionID;
    }

    public String getBankLoginID() {
        return this.bankLoginID;
    }

    public void setBankLoginID(String bankLoginID) {
        this.bankLoginID = bankLoginID;
    }

    public String getImplClassName() {
        return this.implClassName;
    }

    public void setImplClassName(String implClassName) {
        this.implClassName = implClassName;
    }

    public LocalDateTime getInsertTime() {
        return this.insertTime;
    }

    public void setInsertTime(LocalDateTime insertTime) {
        this.insertTime = insertTime;
    }

    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public BigDecimal getDebitAmount() {
        return this.debitAmount;
    }

    public void setDebitAmount(BigDecimal debitAmount) {
        this.debitAmount = debitAmount;
    }

    public BigDecimal getCreditAmount() {
        return this.creditAmount;
    }

    public void setCreditAmount(BigDecimal creditAmount) {
        this.creditAmount = creditAmount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = CurrencyUtils.isISOCurrency(currency) ? currency : CurrencyUtils.convert2Iso(currency);
    }

    public void setISOCurrency(String currency) {
        this.currency = currency;
    }

    public LocalDate getTransDate() {
        return this.transDate;
    }

    public void setTransDate(LocalDate transDate) {
        this.transDate = transDate;
    }

    public Integer getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(Integer serialNo) {
        this.serialNo = serialNo;
    }

    public Boolean getHistory() {
        return this.isHistory;
    }

    public void setHistory(Boolean history) {
        this.isHistory = history;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public LocalDateTime getTransTime() {
        return this.transTime;
    }

    public void setTransTime(LocalDateTime transTime) {
        this.transTime = transTime;
    }

    public String getTransType() {
        return this.transType;
    }

    public void setTransType(String transType) {
        this.transType = transType;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public String getAccNo() {
        return this.accNo;
    }

    public void setAccNo(String accNo) {
        this.accNo = accNo;
    }

    public String getExtraAccNo() {
        return this.extraAccNo;
    }

    public void setExtraAccNo(String extraAccNo) {
        this.extraAccNo = extraAccNo;
    }

    public String getAccName() {
        return this.accName;
    }

    public void setAccName(String accName) {
        this.accName = accName;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getOppAccNo() {
        return this.oppAccNo;
    }

    public void setOppAccNo(String oppAccNo) {
        this.oppAccNo = oppAccNo;
    }

    public String getOppAccName() {
        return this.oppAccName;
    }

    public void setOppAccName(String oppAccName) {
        this.oppAccName = oppAccName;
    }

    public String getOppBankName() {
        return this.oppBankName;
    }

    public void setOppBankName(String oppBankName) {
        this.oppBankName = oppBankName;
    }

    public String getAccType() {
        return this.accType;
    }

    public void setAccType(String accType) {
        this.accType = accType;
    }

    public String getSortID() {
        return this.sortID;
    }

    public void setSortID(String sortID) {
        this.sortID = sortID;
    }

    public String getBizRefNo() {
        return this.bizRefNo;
    }

    public void setBizRefNo(String bizRefNo) {
        this.bizRefNo = bizRefNo;
    }

    public String getKdFlag() {
        return this.kdFlag;
    }

    public void setKdFlag(String kdFlag) {
        this.kdFlag = kdFlag;
    }

    public String getAgentAccNo() {
        return this.agentAccNo;
    }

    public void setAgentAccNo(String agentAccNo) {
        this.agentAccNo = agentAccNo;
    }

    public String getAgentAccName() {
        return this.agentAccName;
    }

    public void setAgentAccName(String agentAccName) {
        this.agentAccName = agentAccName;
    }

    public String getAgentAccBankName() {
        return this.agentAccBankName;
    }

    public void setAgentAccBankName(String agentAccBankName) {
        this.agentAccBankName = agentAccBankName;
    }

    public String getBusType() {
        return this.busType;
    }

    public void setBusType(String busType) {
        this.busType = busType;
    }

    public String getReceiptNo() {
        return this.receiptNo;
    }

    public void setReceiptNo(String receiptNo) {
        this.receiptNo = receiptNo;
    }

    public String getVouhNo() {
        return this.vouhNo;
    }

    public void setVouhNo(String vouhNo) {
        this.vouhNo = vouhNo;
    }

    public BigDecimal getAvailableBalance() {
        return this.availableBalance;
    }

    public void setAvailableBalance(BigDecimal availableBalance) {
        this.availableBalance = availableBalance;
    }

    public String getUniqueSeq() {
        return this.uniqueSeq;
    }

    public void setUniqueSeq(String uniqueSeq) {
        this.uniqueSeq = uniqueSeq;
    }

    public Integer getIsKeyRepeat() {
        if (this.isKeyRepeat == null) {
            this.isKeyRepeat = 0;
        }
        return this.isKeyRepeat;
    }

    public void setIsKeyRepeat(Integer isKeyRepeat) {
        this.isKeyRepeat = isKeyRepeat;
    }

    public Integer getMatchNode() {
        return this.matchNode;
    }

    public void setMatchNode(Integer matchNode) {
        this.matchNode = matchNode;
    }

    public String getPayBankDetailSeqID() {
        return this.payBankDetailSeqID;
    }

    public void setPayBankDetailSeqID(String payBankDetailSeqID) {
        this.payBankDetailSeqID = payBankDetailSeqID;
    }

    public BigDecimal getTransferCharge() {
        return this.transferCharge;
    }

    public void setTransferCharge(BigDecimal transferCharge) {
        this.transferCharge = transferCharge;
    }

    @JsonIgnore
    public void setUseCN(String useCN) {
        this.useCN = useCN;
    }

    @JsonIgnore
    public String getUseCN() {
        return this.useCN;
    }

    @JsonIgnore
    public void setUseCn(String useCN) {
        this.useCN = useCN;
    }

    @JsonIgnore
    public String getUseCn() {
        return this.useCN;
    }

    public String getJsonMap() {
        return this.jsonMap;
    }

    public void setJsonMap(String jsonMap) {
        this.jsonMap = jsonMap;
    }

    public String getUniqueVersion() {
        return this.uniqueVersion;
    }

    public void setUniqueVersion(String uniqueVersion) {
        this.uniqueVersion = uniqueVersion;
    }

    public String getFrmcod() {
        this.frmcod = this.getBiz("frmcod");
        return this.frmcod;
    }

    public void setFrmcod(String frmcod) {
        this.frmcod = frmcod;
        if (StringUtils.isNotEmpty((String)frmcod)) {
            this.setBiz("frmcod", frmcod);
        }
    }

    public static DetailInfo getInstance() {
        DetailInfo instance = new DetailInfo();
        if (EBContext.getContext().isUnitTest()) {
            instance.setAccName("");
            instance.setAccNo("");
            instance.setAccType("");
            instance.setAgentAccBankName("");
            instance.setAgentAccName("");
            instance.setAgentAccNo("");
            instance.setAvailableBalance(new BigDecimal("0.00"));
            instance.setBalance(new BigDecimal("0.00"));
            instance.setBankLoginID("");
            instance.setBankName("");
            instance.setBankVersionID("");
            instance.setBizRefNo("");
            instance.setBusType("");
            instance.setCreditAmount(new BigDecimal("0.00"));
            instance.setCurrency("");
            instance.setCustomID("");
            instance.setDebitAmount(new BigDecimal("0.00"));
            instance.setExplanation("");
            instance.setHistory(true);
            instance.setId("");
            instance.setImplClassName("");
            instance.setInsertTime(LocalDateTime.now());
            instance.setJsonMap("");
            instance.setKdFlag("");
            instance.setOppAccName("");
            instance.setOppAccNo("");
            instance.setOppBankName("");
            instance.setPayBankDetailSeqID("");
            instance.setReceiptNo("");
            instance.setSerialNo(123);
            instance.setSortID("");
            instance.setTransDate(LocalDate.now());
            instance.setTransferCharge(new BigDecimal("0.00"));
            instance.setTransTime(LocalDateTime.now());
            instance.setTransType("");
            instance.setUniqueSeq("");
            instance.setUpdateTime(LocalDateTime.now());
            instance.setUseCN("");
            instance.setVouhNo("");
            instance.getAccName();
            instance.getAccNo();
            instance.getAccType();
            instance.getAgentAccBankName();
            instance.getAgentAccName();
            instance.getAgentAccNo();
            instance.getAvailableBalance();
            instance.getBalance();
            instance.getBankLoginID();
            instance.getBankName();
            instance.getBankVersionID();
            instance.getBizRefNo();
            instance.getBusType();
            instance.getCreditAmount();
            instance.getCurrency();
            instance.getCustomID();
            instance.getDebitAmount();
            instance.getExplanation();
            instance.getHistory();
            instance.getId();
            instance.getImplClassName();
            instance.getInsertTime();
            instance.getJsonMap();
            instance.getKdFlag();
            instance.getOppAccName();
            instance.getOppAccNo();
            instance.getOppBankName();
            instance.getPayBankDetailSeqID();
            instance.getReceiptNo();
            instance.getSerialNo();
            instance.getSortID();
            instance.getTransDate();
            instance.getTransferCharge();
            instance.getTransTime();
            instance.getTransType();
            instance.getUniqueSeq();
            instance.getUpdateTime();
            instance.getUseCN();
            instance.getVouhNo();
        }
        return instance;
    }

    public static class Builder {
        String id;
        String bankVersionID;
        String bankLoginID;
        String implClassName;
        LocalDateTime insertTime;
        LocalDateTime updateTime;
        BigDecimal debitAmount;
        BigDecimal creditAmount;
        String currency;
        LocalDate transDate;
        Integer serialNo;
        Boolean isHistory;
        String explanation;
        LocalDateTime transTime;
        String transType;
        String useCN;
        BigDecimal balance;
        String accNo;
        String extraAccNo;
        String accName;
        String bankName;
        String oppAccNo;
        String oppAccName;
        String oppBankName;
        String accType;
        String sortID;
        String bizRefNo;
        String kdFlag;
        String agentAccNo;
        String agentAccName;
        String agentAccBankName;
        String busType;
        String receiptNo;
        String vouhNo;
        String isConfirm;
        BigDecimal availableBalance;
        String bankDetailNo;
        String uniqueSeq;
        String uniqueVersion = "";
        Integer isKeyRepeat;
        private Integer matchNode;
        String payBankDetailSeqID;
        BigDecimal transferCharge;
        String jsonMap;
        String customID;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setBankVersionID(String bankVersionID) {
            this.bankVersionID = bankVersionID;
            return this;
        }

        public Builder setBankLoginID(String bankLoginID) {
            this.bankLoginID = bankLoginID;
            return this;
        }

        public Builder setImplClassName(String implClassName) {
            this.implClassName = implClassName;
            return this;
        }

        public Builder setInsertTime(LocalDateTime insertTime) {
            this.insertTime = insertTime;
            return this;
        }

        public Builder setUpdateTime(LocalDateTime updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public Builder setDebitAmount(BigDecimal debitAmount) {
            this.debitAmount = debitAmount;
            return this;
        }

        public Builder setCreditAmount(BigDecimal creditAmount) {
            this.creditAmount = creditAmount;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = !CurrencyUtils.isISOCurrency(currency) ? CurrencyUtils.convert2Iso(currency) : currency;
            return this;
        }

        public Builder setTransDate(LocalDate transDate) {
            this.transDate = transDate;
            return this;
        }

        public Builder setSerialNo(Integer serialNo) {
            this.serialNo = serialNo;
            return this;
        }

        public Builder setHistory(Boolean history) {
            this.isHistory = history;
            return this;
        }

        public Builder setExplanation(String explanation) {
            this.explanation = explanation;
            return this;
        }

        public Builder setTransTime(LocalDateTime transTime) {
            this.transTime = transTime;
            return this;
        }

        public Builder setTransType(String transType) {
            this.transType = transType;
            return this;
        }

        public Builder setUseCN(String useCN) {
            this.useCN = useCN;
            return this;
        }

        public Builder setBalance(BigDecimal balance) {
            this.balance = balance;
            return this;
        }

        public Builder setAccNo(String accNo) {
            this.accNo = accNo;
            return this;
        }

        public Builder setExtraAccNo(String accNo) {
            this.extraAccNo = accNo;
            return this;
        }

        public Builder setAccName(String accName) {
            this.accName = accName;
            return this;
        }

        public Builder setBankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        public Builder setOppAccNo(String oppAccNo) {
            this.oppAccNo = oppAccNo;
            return this;
        }

        public Builder setOppAccName(String oppAccName) {
            this.oppAccName = oppAccName;
            return this;
        }

        public Builder setOppBankName(String oppBankName) {
            this.oppBankName = oppBankName;
            return this;
        }

        public Builder setAccType(String accType) {
            this.accType = accType;
            return this;
        }

        public Builder setSortID(String sortID) {
            this.sortID = sortID;
            return this;
        }

        public Builder setBizRefNo(String bizRefNo) {
            this.bizRefNo = bizRefNo;
            return this;
        }

        public Builder setKdFlag(String kdFlag) {
            this.kdFlag = kdFlag;
            return this;
        }

        public Builder setAgentAccNo(String agentAccNo) {
            this.agentAccNo = agentAccNo;
            return this;
        }

        public Builder setAgentAccName(String agentAccName) {
            this.agentAccName = agentAccName;
            return this;
        }

        public String getAgentAccName() {
            return this.agentAccName;
        }

        public Builder setAgentAccBankName(String agentAccBankName) {
            this.agentAccBankName = agentAccBankName;
            return this;
        }

        public Builder setBusType(String busType) {
            this.busType = busType;
            return this;
        }

        public Builder setReceiptNo(String receiptNo) {
            this.receiptNo = receiptNo;
            return this;
        }

        public Builder setVouhNo(String vouhNo) {
            this.vouhNo = vouhNo;
            return this;
        }

        public Builder setAvailableBalance(BigDecimal availableBalance) {
            this.availableBalance = availableBalance;
            return this;
        }

        public Builder setUniqueSeq(String uniqueSeq) {
            this.uniqueSeq = uniqueSeq;
            return this;
        }

        public void setIsKeyRepeat(Integer isKeyRepeat) {
            this.isKeyRepeat = isKeyRepeat;
        }

        public void setMatchNode(Integer matchNode) {
            this.matchNode = matchNode;
        }

        public Builder setPayBankDetailSeqID(String payBankDetailSeqID) {
            this.payBankDetailSeqID = payBankDetailSeqID;
            return this;
        }

        public Builder setTransferCharge(BigDecimal transferCharge) {
            this.transferCharge = transferCharge;
            return this;
        }

        public Builder setJsonMap(String jsonMap) {
            this.jsonMap = jsonMap;
            return this;
        }

        public Builder setCustomID(String customID) {
            this.customID = customID;
            return this;
        }

        public void setIsConfirm(String isConfirm) {
            this.isConfirm = isConfirm;
        }

        public void setBankDetailNo(String bankDetailNo) {
            this.bankDetailNo = bankDetailNo;
        }

        public DetailInfo build() {
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setId(this.id);
            detailInfo.setBankVersionID(this.bankVersionID);
            detailInfo.setBankLoginID(this.bankLoginID);
            detailInfo.setImplClassName(this.implClassName);
            detailInfo.setInsertTime(this.insertTime);
            detailInfo.setUpdateTime(this.updateTime);
            detailInfo.setDebitAmount(this.debitAmount);
            detailInfo.setCreditAmount(this.creditAmount);
            detailInfo.setCurrency(this.currency);
            detailInfo.setTransDate(this.transDate);
            detailInfo.setSerialNo(this.serialNo);
            detailInfo.setHistory(this.isHistory);
            detailInfo.setExplanation(this.explanation);
            detailInfo.setTransTime(this.transTime);
            detailInfo.setTransType(this.transType);
            detailInfo.setUseCn(this.useCN);
            detailInfo.setBalance(this.balance);
            detailInfo.setAccNo(this.accNo);
            detailInfo.setExtraAccNo(this.extraAccNo);
            detailInfo.setAccName(this.accName);
            detailInfo.setBankName(this.bankName);
            detailInfo.setOppAccNo(this.oppAccNo);
            detailInfo.setOppAccName(this.oppAccName);
            detailInfo.setOppBankName(this.oppBankName);
            detailInfo.setAccType(this.accType);
            detailInfo.setSortID(this.sortID);
            detailInfo.setBizRefNo(this.bizRefNo);
            detailInfo.setKdFlag(this.kdFlag);
            detailInfo.setAgentAccNo(this.agentAccNo);
            detailInfo.setAgentAccBankName(this.agentAccBankName);
            detailInfo.setBusType(this.busType);
            detailInfo.setReceiptNo(this.receiptNo);
            detailInfo.setVouhNo(this.vouhNo);
            detailInfo.setAvailableBalance(this.availableBalance);
            detailInfo.setUniqueVersion(this.uniqueVersion);
            detailInfo.setUniqueSeq(this.uniqueSeq);
            detailInfo.setIsKeyRepeat(this.isKeyRepeat == null ? Integer.valueOf(0) : this.isKeyRepeat);
            detailInfo.setMatchNode(this.matchNode);
            detailInfo.setBankDetailNo(this.bankDetailNo);
            detailInfo.setPayBankDetailSeqID(this.payBankDetailSeqID);
            detailInfo.setTransferCharge(this.transferCharge);
            detailInfo.setJsonMap(this.jsonMap);
            detailInfo.setCustomID(this.customID);
            detailInfo.setIsConfirm(this.isConfirm);
            return detailInfo;
        }
    }
}

