/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageImpl;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.model.data.Sort;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class DetailInfoRepository {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailInfoRepository.class);
    private String DETAILINFO_ENTITY = "aqap_bd_detailinfo";
    private String SELECT_ALL_PROPERTIES = "id,acc_name,acc_no,acc_type,agent_acc_bank_name,agent_acc_name,agent_acc_no,available_balance,balance,bank_login_id,bank_name,bank_version_id,biz_ref_no,bus_type,credit_amount,currency,custom_id,debit_amount,explanation,impl_class_name,insert_time,kd_flag,opp_acc_name,opp_acc_no,opp_bank_name,pay_detail_seq_id,receipt_no,serial_no,sort_id,trans_date,trans_time,trans_type,bank_detail_no,unique_seq,unique_version,is_key_repeat,is_confirm,match_node,update_time,use_cn,vouh_no,reversed1,reversed2,reversed3,reversed4,reversed_biz_field,reversed_sys_field,transfer_charge,sort_field";

    public DynamicObject findById(Long detailId) {
        return BusinessDataServiceHelper.loadSingle((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{QFilter.of((String)"id=?", (Object[])new Object[]{detailId})});
    }

    public List<DetailInfo> findByCustomIDAndAccNoAndCurrencyAndTransDateBetweenAndIsKeyRepeat(String customID, String accNo, String currency, LocalDate startDate, LocalDate endDate, Integer isKeyRepeat) {
        DynamicObjectCollection dynamicObjects;
        QFilter filter;
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        QFilter[] filters = new QFilter[2];
        filters[0] = filter = QFilter.of((String)"custom_id=? and acc_no=? and currency=? and trans_date>=? and trans_date<=? and enable='1'", (Object[])new Object[]{customID, accNo, currency, startDate, endDate});
        if (isKeyRepeat != null) {
            filters[1] = QFilter.of((String)"is_key_repeat=?", (Object[])new Object[]{String.valueOf(isKeyRepeat)});
        }
        if ((dynamicObjects = QueryServiceHelper.query((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filters, (String)"sort_field asc, detail_id asc")) != null) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                detailInfos.add(this.transDetailInfo((DynamicObject)dynamicObjects.get(i)));
            }
        }
        return detailInfos;
    }

    public Page<DetailInfo> findByCustomIDAndBankVersionIDAndAccNoAndCurrencyAndTransDateBetween(String customID, String bankVersionID, String accNo, String currency, LocalDate startDate, LocalDate endDate, Pageable pageRequest, boolean isFromEbgPage, Integer isKeyRepeat) {
        PageImpl detailInfoPage = new PageImpl();
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        int page = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        StringBuilder sb = new StringBuilder();
        Sort sort = pageRequest.getSort();
        List orders = sort.toList();
        for (int i = 0; i < orders.size(); ++i) {
            if (i == orders.size() - 1) {
                if (((Sort.Order)orders.get(i)).getDirection().isAscending()) {
                    sb.append(((Sort.Order)orders.get(i)).getProperty());
                    sb.append(" asc");
                    continue;
                }
                sb.append(((Sort.Order)orders.get(i)).getProperty());
                sb.append(" desc");
                continue;
            }
            if (((Sort.Order)orders.get(i)).getDirection().isAscending()) {
                sb.append(((Sort.Order)orders.get(i)).getProperty());
                sb.append(" asc,");
                continue;
            }
            sb.append(((Sort.Order)orders.get(i)).getProperty());
            sb.append(" desc,");
        }
        String orderBy = sb.toString();
        StringBuilder str = new StringBuilder("custom_id=? and bank_version_id=? and acc_no=? and currency=? and trans_date>=? and trans_date<=? and enable='1'");
        if (!isFromEbgPage) {
            str.append(" and is_key_repeat!='1'");
        } else if (isKeyRepeat != null) {
            String key = "'" + isKeyRepeat + "'";
            str.append(" and is_key_repeat=");
            str.append(key);
        }
        QFilter filter = QFilter.of((String)str.toString(), (Object[])new Object[]{customID, bankVersionID, accNo, currency, startDate, endDate});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray(), (String)orderBy, (int)page, (int)pageSize);
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.DETAILINFO_ENTITY, (String)"id", (QFilter[])filter.toArray(), (String)"");
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.transDetailInfo(dynamicObjects[i]));
            }
            long total = ds.count("id", Boolean.FALSE.booleanValue());
            detailInfoPage = new PageImpl(detailInfos, pageRequest, total);
        }
        return detailInfoPage;
    }

    public Page<DetailInfo> findByCustomIDAndBankVersionIDAndAccNoAndCurrencyAndTransDateBetweenAllowNull(String customID, String bankVersionID, String accNo, String currency, LocalDate startDate, LocalDate endDate, Integer isKeyRepeat, List<QFilter> rowQFilters, Pageable pageRequest) {
        PageImpl detailInfoPage = new PageImpl();
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        int page = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        StringBuilder sb = new StringBuilder();
        Sort sort = pageRequest.getSort();
        List orders = sort.toList();
        for (int i = 0; i < orders.size(); ++i) {
            sb.append(((Sort.Order)orders.get(i)).getProperty()).append(" ");
        }
        String orderBy = sb.toString();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("custom_id", "=", (Object)customID));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        if (CollectionUtil.isNotEmpty(rowQFilters)) {
            qFilters.addAll(rowQFilters);
        }
        if (StringUtils.isNotEmpty((String)bankVersionID)) {
            qFilters.add(new QFilter("bank_version_id", "=", (Object)bankVersionID));
        }
        if (StringUtils.isNotEmpty((String)accNo)) {
            qFilters.add(new QFilter("acc_no", "=", (Object)accNo));
        }
        if (StringUtils.isNotEmpty((String)currency)) {
            qFilters.add(new QFilter("currency", "=", (Object)currency));
        }
        if (startDate != null) {
            qFilters.add(new QFilter("trans_date", ">=", (Object)startDate));
        }
        if (endDate != null) {
            qFilters.add(new QFilter("trans_date", "<=", (Object)endDate));
        }
        if (isKeyRepeat != null) {
            qFilters.add(new QFilter("is_key_repeat", "=", (Object)String.valueOf(isKeyRepeat)));
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])qFilters.toArray(new QFilter[16]), (String)orderBy, (int)page, (int)pageSize);
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.DETAILINFO_ENTITY, (String)"id", (QFilter[])qFilters.toArray(new QFilter[16]), (String)"");
        if (dynamicObjects != null) {
            Map<String, String> bankNameMap = this.getBankNameMap(dynamicObjects);
            for (int i = 0; i < dynamicObjects.length; ++i) {
                DetailInfo detailInfo = this.transDetailInfo(dynamicObjects[i]);
                detailInfo.setBankName(bankNameMap.get(detailInfo.getBankVersionID()));
                detailInfos.add(detailInfo);
            }
            long total = ds.count("id", Boolean.FALSE.booleanValue());
            detailInfoPage = new PageImpl(detailInfos, pageRequest, total);
        }
        return detailInfoPage;
    }

    Map<String, String> getBankNameMap(DynamicObject[] dynamicObjects) {
        HashSet<String> bankVersionIds = new HashSet<String>(16);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            bankVersionIds.add(dynamicObjects[i].getString("bank_version_id"));
        }
        DynamicObjectCollection dynamicObjects1 = QueryServiceHelper.query((String)"aqap_bank", (String)"number, bank_name", (QFilter[])new QFilter[]{new QFilter("number", "in", bankVersionIds)});
        HashMap<String, String> bankNameMap = new HashMap<String, String>(16);
        if (!dynamicObjects1.isEmpty()) {
            for (DynamicObject dynamicObject : dynamicObjects1) {
                bankNameMap.put(dynamicObject.getString("number"), dynamicObject.getString("bank_name"));
            }
        }
        return bankNameMap;
    }

    public Page<DetailInfo> findByInsertTimeBefore(LocalDateTime dateTime, Pageable pageRequest) {
        PageImpl detailInfoPage = new PageImpl();
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        int page = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        QFilter filter = QFilter.of((String)"trans_date<=?", (Object[])new Object[]{dateTime});
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.DETAILINFO_ENTITY, (String)"id", (QFilter[])filter.toArray(), (String)"");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray(), (String)"", (int)page, (int)pageSize);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.transDetailInfo(dynamicObjects[i]));
            }
            long total = ds.count("id", Boolean.FALSE.booleanValue());
            detailInfoPage = new PageImpl(detailInfos, pageRequest, total);
        }
        return detailInfoPage;
    }

    public List<DetailInfo> findByAccNoAndBankVersionIDAndTransDateBetween(String accNo, String bankVersionID, LocalDate startDate, LocalDate endDate) {
        return this.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionID, startDate, endDate, "1");
    }

    public List<DetailInfo> findByAccNoAndBankVersionIDAndTransDateBetween(String accNo, String bankVersionID, LocalDate startDate, LocalDate endDate, String enable) {
        DynamicObjectCollection dynamicObjects;
        QFilter filter;
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        QFilter[] filters = new QFilter[2];
        filters[0] = filter = QFilter.of((String)"acc_no=? and bank_version_id=? and trans_date>=? and trans_date<=?", (Object[])new Object[]{accNo, bankVersionID, startDate, endDate});
        if (StringUtils.isNotEmpty((String)enable)) {
            filters[1] = QFilter.of((String)"enable=?", (Object[])new Object[]{enable});
        }
        if ((dynamicObjects = QueryServiceHelper.query((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filters)) != null) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                detailInfos.add(this.transDetailInfo((DynamicObject)dynamicObjects.get(i)));
            }
        }
        return detailInfos;
    }

    public List<DetailInfo> findByAccNoAndBankVersionIDAndTransDateBetweenAndUpdateTimeNot(String accNo, String bankVersionID, LocalDate startDate, LocalDate endDate, LocalDateTime updateTime) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        QFilter filter = QFilter.of((String)"acc_no=? and bank_version_id=? and trans_date>=? and trans_date<=? and update_time<>?", (Object[])new Object[]{accNo, bankVersionID, startDate, endDate, updateTime});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                detailInfos.add(this.transDetailInfo((DynamicObject)dynamicObjects.get(i)));
            }
        }
        return detailInfos;
    }

    public List<DetailInfo> findByInsertTimeBefore(LocalDateTime insertTime) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        QFilter filter = QFilter.of((String)"trans_date<=?", (Object[])new Object[]{insertTime});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                detailInfos.add(this.transDetailInfo((DynamicObject)dynamicObjects.get(i)));
            }
        }
        return detailInfos;
    }

    public void deleteByInsertTimeBefore(LocalDateTime dateTime) {
        StringBuilder str = new StringBuilder("trans_date <= ?");
        QFilter filter = QFilter.of((String)str.toString(), (Object[])new Object[]{dateTime});
        DeleteServiceHelper.delete((String)this.DETAILINFO_ENTITY, (QFilter[])filter.toArray());
    }

    public void saveAll(List<DetailInfo> detailInfos) {
        if (detailInfos != null && detailInfos.size() > 0) {
            DynamicObject[] dynamicObjects = new DynamicObject[detailInfos.size()];
            HashMap detailNoMap = Maps.newHashMapWithExpectedSize((int)detailInfos.size());
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < detailInfos.size(); ++i) {
                DetailInfo detailInfo = detailInfos.get(i);
                String detailNo = detailInfo.getReceiptNo();
                if (StringUtils.isNotEmpty((String)detailNo) && StringUtils.isNotEmpty((String)detailInfo.getJsonMap())) {
                    if (detailNoMap.get(detailNo) != null) {
                        int recount = (Integer)detailNoMap.get(detailNo);
                        detailNo = detailNo + "_" + ++recount;
                        detailNoMap.put(detailNo, recount);
                    } else {
                        detailNoMap.put(detailNo, 1);
                    }
                    detailInfo.setReceiptNo(detailNo);
                }
                dynamicObjects[i] = this.packDetailInfo(null, detailInfo);
            }
            DynamicObject[] dynamicObjectArray = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public void save(DetailInfo detailInfo) {
        if (detailInfo != null && StringUtils.isEmpty((String)detailInfo.getId())) {
            DynamicObject dynamicObject = this.packDetailInfo(null, detailInfo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        } else if (detailInfo != null && StringUtils.isNotEmpty((String)detailInfo.getId())) {
            this.update(detailInfo);
        }
    }

    public void updateAll(List<DetailInfo> detailInfos) {
        if (detailInfos != null && detailInfos.size() > 0) {
            int len = detailInfos.size();
            Object[] pks = new Object[len];
            for (int i = 0; i < len; ++i) {
                pks[i] = Long.parseLong(detailInfos.get(i).getId());
            }
            DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)this.DETAILINFO_ENTITY).getDynamicObjectType();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)type);
            HashMap detailNoMap = Maps.newHashMapWithExpectedSize((int)detailInfos.size());
            for (int i = 0; i < len; ++i) {
                DetailInfo detailInfo = detailInfos.get(i);
                String detailNo = detailInfo.getReceiptNo();
                if (StringUtils.isNotEmpty((String)detailNo)) {
                    if (detailNoMap.containsKey(detailNo)) {
                        int recount = (Integer)detailNoMap.get(detailNo);
                        detailNo = detailNo + "_" + ++recount;
                        detailNoMap.put(detailNo, recount);
                    } else {
                        detailNoMap.put(detailNo, 1);
                    }
                    detailInfo.setReceiptNo(detailNo);
                }
                dynamicObjects[i] = this.packDetailInfo(dynamicObjects[i], detailInfo);
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public void update(DetailInfo detailInfo) {
        String detailId;
        DynamicObject dynamicObject;
        if (detailInfo != null && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(detailId = detailInfo.getId()), (String)this.DETAILINFO_ENTITY)) != null) {
            dynamicObject = this.packDetailInfo(dynamicObject, detailInfo);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private DynamicObject packDetailInfo(DynamicObject dynamicObject, DetailInfo info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.DETAILINFO_ENTITY);
        }
        dynamicObject.set("id", (Object)Long.parseLong(info.getId()));
        dynamicObject.set("acc_name", (Object)info.getAccName());
        dynamicObject.set("acc_no", (Object)info.getAccNo());
        dynamicObject.set("acc_type", (Object)info.getAccType());
        dynamicObject.set("agent_acc_bank_name", (Object)info.getAgentAccBankName());
        dynamicObject.set("agent_acc_name", (Object)info.getAgentAccName());
        dynamicObject.set("agent_acc_no", (Object)info.getAgentAccNo());
        dynamicObject.set("available_balance", (Object)info.getAvailableBalance());
        dynamicObject.set("balance", (Object)info.getBalance());
        dynamicObject.set("bank_login_id", (Object)info.getBankLoginID());
        dynamicObject.set("bank_name", (Object)info.getBankName());
        dynamicObject.set("bank_version_id", (Object)info.getBankVersionID());
        dynamicObject.set("biz_ref_no", (Object)info.getBizRefNo());
        dynamicObject.set("bus_type", (Object)info.getBusType());
        dynamicObject.set("credit_amount", (Object)info.getCreditAmount());
        dynamicObject.set("currency", (Object)info.getCurrency());
        dynamicObject.set("custom_id", (Object)info.getCustomID());
        dynamicObject.set("debit_amount", (Object)info.getDebitAmount());
        dynamicObject.set("explanation", (Object)info.getExplanation());
        dynamicObject.set("impl_class_name", (Object)info.getImplClassName());
        Date insertTime = Date.from(info.getInsertTime().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("insert_time", (Object)insertTime);
        dynamicObject.set("kd_flag", (Object)info.getKdFlag());
        dynamicObject.set("opp_acc_name", (Object)info.getOppAccName());
        dynamicObject.set("opp_acc_no", (Object)info.getOppAccNo());
        dynamicObject.set("opp_bank_name", (Object)info.getOppBankName());
        dynamicObject.set("pay_detail_seq_id", (Object)info.getPayBankDetailSeqID());
        dynamicObject.set("receipt_no", (Object)info.getReceiptNo());
        dynamicObject.set("serial_no", (Object)info.getSerialNo());
        dynamicObject.set("sort_id", (Object)info.getSortID());
        dynamicObject.set("detail_id", (Object)info.getId());
        Date transDate = Date.from(info.getTransDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("trans_date", (Object)transDate);
        Date transTime = Date.from(info.getTransTime().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("trans_time", (Object)transTime);
        dynamicObject.set("trans_type", (Object)info.getTransType());
        dynamicObject.set("unique_seq", (Object)(StringUtils.isEmpty((String)info.getUniqueSeq()) ? info.getId() : info.getUniqueSeq()));
        dynamicObject.set("unique_version", (Object)info.getUniqueVersion());
        dynamicObject.set("bank_detail_no", (Object)info.getBankDetailNo());
        dynamicObject.set("is_key_repeat", (Object)String.valueOf(info.getIsKeyRepeat()));
        dynamicObject.set("is_confirm", (Object)info.getIsConfirm());
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("match_node", (Object)info.getMatchNode());
        Date updateTime = Date.from(info.getUpdateTime().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("update_time", (Object)updateTime);
        dynamicObject.set("use_cn", (Object)info.getUseCN());
        dynamicObject.set("vouh_no", (Object)info.getVouhNo());
        dynamicObject.set("transfer_charge", (Object)info.getTransferCharge());
        dynamicObject.set("reversed1", (Object)info.getReversed1());
        dynamicObject.set("reversed2", (Object)info.getReversed2());
        dynamicObject.set("reversed3", (Object)info.getReversed3());
        dynamicObject.set("reversed4", (Object)info.getReversed4());
        dynamicObject.set("reversed_biz_field", (Object)info.getReversedBizField());
        dynamicObject.set("reversed_sys_field", (Object)info.getReversedSysField());
        dynamicObject.set("sort_field", (Object)(StringUtils.isEmpty((String)info.getSortField()) ? info.getId() : info.getSortField()));
        dynamicObject.set("status", (Object)"A");
        return dynamicObject;
    }

    private DetailInfo transDetailInfo(DynamicObject dynamicObject) {
        String transTime;
        String customID = dynamicObject.getString("custom_id");
        String bankVersionID = dynamicObject.getString("bank_version_id");
        String currency = dynamicObject.getString("currency");
        DetailInfo detailInfo = new DetailInfo();
        detailInfo.setId(dynamicObject.getString("id"));
        detailInfo.setAccNo(dynamicObject.getString("acc_no"));
        detailInfo.setAccName(dynamicObject.getString("acc_name"));
        detailInfo.setAccType(dynamicObject.getString("acc_type"));
        detailInfo.setAgentAccBankName(dynamicObject.getString("agent_acc_bank_name"));
        detailInfo.setAgentAccName(dynamicObject.getString("agent_acc_name"));
        detailInfo.setAgentAccNo(dynamicObject.getString("agent_acc_no"));
        detailInfo.setAvailableBalance(dynamicObject.getBigDecimal("available_balance").setScale(2));
        detailInfo.setBalance(dynamicObject.getBigDecimal("balance").setScale(2));
        detailInfo.setBankLoginID(dynamicObject.getString("bank_login_id"));
        detailInfo.setBankName(dynamicObject.getString("bank_name"));
        detailInfo.setBankVersionID(dynamicObject.getString("bank_version_id"));
        detailInfo.setBizRefNo(dynamicObject.getString("biz_ref_no"));
        detailInfo.setBusType(dynamicObject.getString("bus_type"));
        detailInfo.setCreditAmount(dynamicObject.getBigDecimal("credit_amount").setScale(2));
        detailInfo.setISOCurrency(CurrencyUtils.checkAndGetISOCurrency(currency, customID, bankVersionID));
        detailInfo.setDebitAmount(dynamicObject.getBigDecimal("debit_amount").setScale(2));
        detailInfo.setExplanation(dynamicObject.getString("explanation"));
        detailInfo.setImplClassName(dynamicObject.getString("impl_class_name"));
        String insertTime = dynamicObject.getString("insert_time");
        if (StringUtils.isNotEmpty((String)insertTime)) {
            detailInfo.setInsertTime(DTFactoryUtil.parseDateTime((String)insertTime));
        }
        detailInfo.setHistory(false);
        detailInfo.setKdFlag(dynamicObject.getString("kd_flag"));
        detailInfo.setOppAccName(dynamicObject.getString("opp_acc_name"));
        detailInfo.setOppAccNo(dynamicObject.getString("opp_acc_no"));
        detailInfo.setOppBankName(dynamicObject.getString("opp_bank_name"));
        detailInfo.setPayBankDetailSeqID(dynamicObject.getString("pay_detail_seq_id"));
        detailInfo.setReceiptNo(dynamicObject.getString("receipt_no"));
        detailInfo.setSerialNo(Integer.parseInt(dynamicObject.getString("serial_no")));
        String sortField = dynamicObject.getString("sort_field");
        detailInfo.setSortField(dynamicObject.getString("sort_field"));
        detailInfo.setSortID(dynamicObject.getString("sort_id"));
        String transDate = dynamicObject.getString("trans_date");
        if (StringUtils.isNotEmpty((String)transDate)) {
            detailInfo.setTransDate(DTFactoryUtil.parseDate((String)transDate));
        }
        if (StringUtils.isNotEmpty((String)(transTime = dynamicObject.getString("trans_time")))) {
            detailInfo.setTransTime(DTFactoryUtil.parseDateTime((String)transTime));
        }
        detailInfo.setTransType(dynamicObject.getString("trans_type"));
        detailInfo.setUniqueSeq(dynamicObject.getString("unique_seq"));
        detailInfo.setUniqueVersion(dynamicObject.getString("unique_version"));
        detailInfo.setBankDetailNo(dynamicObject.getString("bank_detail_no"));
        detailInfo.setIsKeyRepeat(dynamicObject.getInt("is_key_repeat"));
        detailInfo.setIsConfirm(dynamicObject.getString("is_confirm"));
        detailInfo.setMatchNode(dynamicObject.getInt("match_node"));
        String updateTime = dynamicObject.getString("update_time");
        if (StringUtils.isNotEmpty((String)updateTime)) {
            detailInfo.setUpdateTime(DTFactoryUtil.parseDateTime((String)updateTime));
        }
        detailInfo.setUseCN(dynamicObject.getString("use_cn"));
        detailInfo.setTransferCharge(dynamicObject.getBigDecimal("transfer_charge").setScale(2));
        detailInfo.setVouhNo(dynamicObject.getString("vouh_no"));
        detailInfo.setReversed1(dynamicObject.getString("reversed1"));
        detailInfo.setReversed2(dynamicObject.getString("reversed2"));
        detailInfo.setReversed3(dynamicObject.getString("reversed3"));
        detailInfo.setReversed4(dynamicObject.getString("reversed4"));
        detailInfo.setReversedBizField(dynamicObject.getString("reversed_biz_field"));
        detailInfo.setReversedSysField(dynamicObject.getString("reversed_sys_field"));
        return detailInfo;
    }

    public DynamicObject[] loadByCustomID(String customID) {
        QFilter filter = QFilter.of((String)"custom_id = ?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.DETAILINFO_ENTITY, (String)"id, custom_id", (QFilter[])filter.toArray());
        return dynamicObjects;
    }

    public DetailInfo findDetailInfoByKDFlagId(String kdflagId) {
        QFilter filter = QFilter.of((String)"pay_detail_seq_id = ?", (Object[])new Object[]{kdflagId});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            return this.transDetailInfo(dynamicObject);
        }
        return null;
    }

    public List<DetailInfo> findDetailInfoListByKDFlagIds(List<String> kdflagIds) {
        QFilter filter = new QFilter("pay_detail_seq_id", "in", kdflagIds);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.DETAILINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            detailInfos.add(this.transDetailInfo(dynamicObject));
        }
        return detailInfos;
    }
}

