/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingProductDetail;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageImpl;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class FinancingDetailRespository {
    private String ENTITY_KEY = "aqap_financ_detail";
    private String SELECT_PROPERTIES = "id,billno,bank_version_id,product_name,currency,publish_start_date,publish_end_date,buy_price,redeem_max,redeem_min,risk_lev,reserved1,reserved2,reserved3,reserved4,reserved5,modifytime";

    public Page<FinancingProductDetail> findByBankVersionID(String bankVersionID, String productCode, Pageable pageRequest) {
        PageImpl detailInfoPage = new PageImpl();
        ArrayList<FinancingProductDetail> detailInfos = new ArrayList<FinancingProductDetail>(16);
        int page = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        String orderBy = "id asc";
        QFilter[] filters = new QFilter[2];
        filters[0] = QFilter.of((String)"bank_version_id=?", (Object[])new Object[]{bankVersionID});
        if (StringUtils.isNotEmpty((String)productCode)) {
            filters[1] = QFilter.of((String)"billno=?", (Object[])new Object[]{productCode});
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY_KEY, (String)this.SELECT_PROPERTIES, (QFilter[])filters, (String)orderBy, (int)page, (int)pageSize);
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.ENTITY_KEY, (String)"id", (QFilter[])filters, (String)"");
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.transDetailInfo(dynamicObjects[i]));
            }
            long total = ds.count("id", Boolean.FALSE.booleanValue());
            detailInfoPage = new PageImpl(detailInfos, pageRequest, total);
        }
        return detailInfoPage;
    }

    public void updateWhenSourceNotEmpty(FinancingProductDetail info) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.ENTITY_KEY, (String)this.SELECT_PROPERTIES, (QFilter[])QFilter.of((String)"billno=? and bank_version_id=?", (Object[])new Object[]{info.getProductCode(), info.getBankVersionID()}).toArray());
        if (dynamicObject == null) {
            dynamicObject = this.packDetailInfo(null, info);
        } else {
            Date publicEndDate;
            dynamicObject.set("product_name", (Object)this.getFirstNotEmpty(dynamicObject.getString("product_name"), info.getProductName()));
            dynamicObject.set("currency", (Object)this.getFirstNotEmpty(dynamicObject.getString("currency"), info.getCurrency()));
            Date publicStartDate = info.getPublishStartDate() == null ? null : Date.from(info.getPublishStartDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            Date date = publicEndDate = info.getPublishEndDate() == null ? null : Date.from(info.getPublishEndDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            if (dynamicObject.getDate("publish_start_date") == null) {
                dynamicObject.set("publish_start_date", (Object)publicStartDate);
            }
            if (dynamicObject.getDate("publish_end_date") == null) {
                dynamicObject.set("publish_end_date", (Object)publicEndDate);
            }
            dynamicObject.set("buy_price", (Object)this.getFirstNotEmpty(dynamicObject.getString("buy_price"), info.getBuyPrice()));
            dynamicObject.set("redeem_max", (Object)this.getFirstNotEmpty(dynamicObject.getString("redeem_max"), info.getRedeemMax()));
            dynamicObject.set("redeem_min", (Object)this.getFirstNotEmpty(dynamicObject.getString("redeem_min"), info.getRedeemMin()));
            dynamicObject.set("risk_lev", (Object)this.getFirstNotEmpty(dynamicObject.getString("risk_lev"), info.getRiskLev()));
            dynamicObject.set("reserved1", (Object)this.getFirstNotEmpty(dynamicObject.getString("reserved1"), info.getReserved1()));
            dynamicObject.set("reserved2", (Object)this.getFirstNotEmpty(dynamicObject.getString("reserved2"), info.getReserved2()));
            dynamicObject.set("reserved3", (Object)this.getFirstNotEmpty(dynamicObject.getString("reserved3"), info.getReserved3()));
            dynamicObject.set("reserved4", (Object)this.getFirstNotEmpty(dynamicObject.getString("reserved4"), info.getReserved4()));
            dynamicObject.set("reserved5", (Object)this.getFirstNotEmpty(dynamicObject.getString("reserved5"), info.getReserved5()));
            dynamicObject.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    String getFirstNotEmpty(String str1, String str2) {
        if (StringUtils.isNotEmpty((String)str1)) {
            return StringUtils.trim((String)str1);
        }
        return StringUtils.trim((String)str2);
    }

    public void deleteByBankVersionID(String bankVersionID) {
        DeleteServiceHelper.delete((String)this.ENTITY_KEY, (QFilter[])QFilter.of((String)"bank_version_id=?", (Object[])new Object[]{bankVersionID}).toArray());
    }

    public boolean exitsByBankVersionID(String bankVersionID) {
        return QueryServiceHelper.exists((String)this.ENTITY_KEY, (QFilter[])QFilter.of((String)"bank_version_id = ?", (Object[])new Object[]{bankVersionID}).toArray());
    }

    public void insertAll(List<FinancingProductDetail> detailInfos) {
        if (detailInfos != null && detailInfos.size() > 0) {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(16);
            for (int i = 0; i < detailInfos.size(); ++i) {
                dynamicObjectList.add(this.packDetailInfo(null, detailInfos.get(i)));
                if (dynamicObjectList.size() < 10000) continue;
                SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
                dynamicObjectList.clear();
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
        }
    }

    private FinancingProductDetail transDetailInfo(DynamicObject dynamicObject) {
        String publishEndDate;
        FinancingProductDetail detailInfo = new FinancingProductDetail();
        detailInfo.setProductCode(dynamicObject.getString("billno"));
        detailInfo.setProductName(dynamicObject.getString("product_name"));
        detailInfo.setBankVersionID(dynamicObject.getString("bank_version_id"));
        detailInfo.setCurrency(dynamicObject.getString("currency"));
        String publishStartDate = dynamicObject.getString("publish_start_date");
        if (kd.bos.util.StringUtils.isNotEmpty((String)publishStartDate)) {
            detailInfo.setPublishStartDate(DTFactoryUtil.parseDate((String)publishStartDate));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(publishEndDate = dynamicObject.getString("publish_end_date")))) {
            detailInfo.setPublishEndDate(DTFactoryUtil.parseDate((String)publishEndDate));
        }
        detailInfo.setBuyPrice(dynamicObject.getString("buy_price"));
        detailInfo.setRedeemMax(dynamicObject.getString("redeem_max"));
        detailInfo.setRedeemMin(dynamicObject.getString("redeem_min"));
        detailInfo.setRiskLev(dynamicObject.getString("risk_lev"));
        String modifytime = dynamicObject.getString("modifytime");
        if (kd.bos.util.StringUtils.isNotEmpty((String)modifytime)) {
            detailInfo.setModifyTime(DTFactoryUtil.parseDateTime((String)modifytime));
        }
        detailInfo.setReserved1(dynamicObject.getString("reserved1"));
        detailInfo.setReserved2(dynamicObject.getString("reserved2"));
        detailInfo.setReserved3(dynamicObject.getString("reserved3"));
        detailInfo.setReserved4(dynamicObject.getString("reserved4"));
        detailInfo.setReserved5(dynamicObject.getString("reserved5"));
        return detailInfo;
    }

    private DynamicObject packDetailInfo(DynamicObject dynamicObject, FinancingProductDetail info) {
        Date date = new Date();
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_KEY);
            dynamicObject.set("createtime", (Object)date);
        }
        dynamicObject.set("billno", (Object)StringUtils.trim((String)info.getProductCode()));
        dynamicObject.set("bank_version_id", (Object)StringUtils.trim((String)info.getBankVersionID()));
        dynamicObject.set("product_name", (Object)StringUtils.trim((String)info.getProductName()));
        dynamicObject.set("currency", (Object)StringUtils.trim((String)info.getCurrency()));
        Date publicStartDate = info.getPublishStartDate() == null ? null : Date.from(info.getPublishStartDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        Date publicEndDate = info.getPublishEndDate() == null ? null : Date.from(info.getPublishEndDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("publish_start_date", (Object)publicStartDate);
        dynamicObject.set("publish_end_date", (Object)publicEndDate);
        dynamicObject.set("buy_price", (Object)StringUtils.trim((String)info.getBuyPrice()));
        dynamicObject.set("redeem_max", (Object)StringUtils.trim((String)info.getRedeemMax()));
        dynamicObject.set("redeem_min", (Object)StringUtils.trim((String)info.getRedeemMin()));
        dynamicObject.set("risk_lev", (Object)StringUtils.trim((String)info.getRiskLev()));
        dynamicObject.set("reserved1", (Object)StringUtils.trim((String)info.getReserved1()));
        dynamicObject.set("reserved2", (Object)StringUtils.trim((String)info.getReserved2()));
        dynamicObject.set("reserved3", (Object)StringUtils.trim((String)info.getReserved3()));
        dynamicObject.set("reserved4", (Object)StringUtils.trim((String)info.getReserved4()));
        dynamicObject.set("reserved5", (Object)StringUtils.trim((String)info.getReserved5()));
        dynamicObject.set("modifytime", (Object)date);
        return dynamicObject;
    }
}

