/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;

@Component
public class FinancingSyncRecordRespository {
    private String ENTITY = "aqap_financ_sync_record";
    private String SELECT_PROPERTIES = "id,bank_version_id,custom_id,sync_date,modifytime";

    public void save(String bankVersionID, String customId, LocalDate syncDate) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])QFilter.of((String)"bank_version_id=? and custom_id = ? and sync_date = ?", (Object[])new Object[]{bankVersionID, customId, syncDate}).toArray());
        if (dynamicObject != null) {
            dynamicObject.set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        } else {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY);
            dynamicObject.set("custom_id", (Object)customId);
            dynamicObject.set("bank_version_id", (Object)bankVersionID);
            Date date1 = syncDate == null ? null : Date.from(syncDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("sync_date", (Object)date1);
            Date date = new Date();
            dynamicObject.set("modifytime", (Object)date);
            dynamicObject.set("createtime", (Object)date);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public boolean exitsByBankVersionIDAndSyncDate(String bankVersionID, LocalDate syncDate) {
        return QueryServiceHelper.exists((String)this.ENTITY, (QFilter[])QFilter.of((String)"bank_version_id = ? and sync_date = ?", (Object[])new Object[]{bankVersionID, syncDate}).toArray());
    }
}

