/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.PaymentInfoUpdateRecord;
import kd.ebg.egf.common.annotation.Component;

@Component
public class PaymentInfoUpdateRecordRepository {
    private String entity = "aqap_bd_payment_track";

    public void save(List<PaymentInfoUpdateRecord> records) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
        for (PaymentInfoUpdateRecord record : records) {
            Date dateTime;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entity);
            dynamicObject.set("number", (Object)Long.parseLong(record.getId()));
            dynamicObject.set("update_batch_seq", (Object)record.getUpdateBatchSeq());
            dynamicObject.set("status_id", (Object)record.getStatus());
            dynamicObject.set("status_name", (Object)record.getStatusName());
            dynamicObject.set("status_msg", (Object)record.getStatusMsg());
            dynamicObject.set("bank_status", (Object)record.getBankStatus());
            dynamicObject.set("bank_msg", (Object)record.getBankMsg());
            dynamicObject.set("error_msg", (Object)record.getErrorMsg());
            dynamicObject.set("error_stack", (Object)record.getErrorStack());
            LocalDateTime time = record.getPackageTime();
            if (time != null) {
                dateTime = Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
                dynamicObject.set("package_time", (Object)dateTime);
            }
            dynamicObject.set("bank_batch_seq_id", (Object)record.getBankBatchSeqID());
            dynamicObject.set("bank_detail_seq_id", (Object)record.getBankDetailSeqID());
            dynamicObject.set("bank_serial_no", (Object)record.getBankSerialNo());
            dynamicObject.set("batch_seq_id", (Object)record.getBatchSeqID());
            dynamicObject.set("detail_seq_id", (Object)record.getDetailSeqID());
            dynamicObject.set("total_count", (Object)record.getTotalCount());
            dynamicObject.set("total_amount", (Object)record.getTotalAmount());
            time = record.getUpdateTime();
            if (time != null) {
                dateTime = Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
                dynamicObject.set("update_time", (Object)dateTime);
            }
            dynamicObject.set("operation", (Object)record.getOperation());
            dynamicObject.set("status", (Object)"A");
            dynamicObjectList.add(dynamicObject);
        }
        DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[0]);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }
}

