/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;
import kd.ebg.egf.common.utils.string.StrUtil;

@Component
public class UserCertRepository {
    private String ENTITY_NAME = "aqap_bd_cert";
    private String selectProperties = "id, bank_config_id, bank_config_value_tag, bank_config_name, bank_login_id, bank_version_id, acnt_no, type, cert_type, custom_id, file_name, expire_time, modifytime, is_alert, alert_day, cert_password, cert_source";

    public CertInfo findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(String bankConfigId, String bankLoginID, String customID) {
        List dynamicObjects = QueryCacheUtil.getDynamicObjectList((String)this.ENTITY_NAME, (String)this.selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_config_id", "=", (Object)bankConfigId), new QFilter("bank_login_id", "=", (Object)bankLoginID), new QFilter("custom_id", "=", (Object)customID), new QFilter("type", "=", (Object)CertType.BANKLOGIN_CER.getType())});
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            Long id = dynamicObject.getLong("id");
            CertInfo certInfo = new CertInfo();
            certInfo.setCertID(String.valueOf(id));
            certInfo.setFileContent(dynamicObject.getString("bank_config_value_tag"));
            certInfo.setCustomID(customID);
            certInfo.setCertPassword(dynamicObject.getString("cert_password"));
            certInfo.setFileName(dynamicObject.getString("file_name"));
            return certInfo;
        }
        return null;
    }

    public CertInfo findAccCertByBankLoginIDAndBankConfigIDAndCustomID(String bankConfigId, String bankLoginID, String customID, String accNo) {
        List dynamicObjects = QueryCacheUtil.getDynamicObjectList((String)this.ENTITY_NAME, (String)this.selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_config_id", "=", (Object)bankConfigId), new QFilter("bank_login_id", "=", (Object)bankLoginID), new QFilter("custom_id", "=", (Object)customID), new QFilter("acnt_no", "=", (Object)accNo)});
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            Long id = dynamicObject.getLong("id");
            CertInfo certInfo = new CertInfo();
            certInfo.setCertID(String.valueOf(id));
            certInfo.setFileContent(dynamicObject.getString("bank_config_value_tag"));
            certInfo.setCustomID(customID);
            certInfo.setCertPassword(dynamicObject.getString("cert_password"));
            return certInfo;
        }
        return null;
    }

    public DynamicObject[] getBankLoginCerDatas(String bankLoginID, String customID) {
        return BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)this.selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_login_id", "=", (Object)bankLoginID), new QFilter("custom_id", "=", (Object)customID), new QFilter("type", "=", (Object)CertType.BANKLOGIN_CER.getType())});
    }

    public OperationResult addBankLoginCert(String bankConfigId, String bankConfigName, String bankVersion, String bankLogin, String customID, String value, String fileName, String certSource, String certType) {
        return this.addBankLoginCert(bankConfigId, bankConfigName, bankVersion, bankLogin, customID, value, fileName, false, null, null, "", certSource, certType);
    }

    public OperationResult addBankLoginCert(String bankConfigId, String bankConfigName, String bankVersion, String bankLogin, String customID, String value, String fileName, boolean isAlert, String alertDay, LocalDateTime expireTime, String certPassword, String certSource, String certType) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_NAME);
        dataEntity.set("bank_config_id", (Object)bankConfigId);
        dataEntity.set("bank_config_value_tag", (Object)value);
        dataEntity.set("bank_config_name", (Object)bankConfigName);
        dataEntity.set("bank_login_id", (Object)bankLogin);
        dataEntity.set("bank_version_id", (Object)bankVersion);
        dataEntity.set("custom_id", (Object)customID);
        dataEntity.set("type", (Object)CertType.BANKLOGIN_CER.getType());
        dataEntity.set("file_name", (Object)fileName);
        if (expireTime != null) {
            dataEntity.set("expire_time", (Object)Date.from(expireTime.atZone(ZoneId.systemDefault()).toInstant()));
        }
        dataEntity.set("is_alert", (Object)isAlert);
        dataEntity.set("cert_source", (Object)certSource);
        dataEntity.set("cert_type", (Object)certType);
        dataEntity.set("alert_day", (Object)alertDay);
        dataEntity.set("cert_password", (Object)certPassword);
        OperationResult result = SaveServiceHelper.saveOperate((String)this.ENTITY_NAME, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
        return result;
    }

    public void updateBankLoginCert(DynamicObject cerData, String bankConfigId, String bankConfigName, String bankVersion, String bankLogin, String customID, String value, String fileName, String certSource, String certType) {
        this.updateBankLoginCert(cerData, bankConfigId, bankConfigName, bankVersion, bankLogin, customID, value, fileName, false, null, null, "", certSource, certType);
    }

    public void updateBankLoginCert(DynamicObject cerData, String bankConfigId, String bankConfigName, String bankVersion, String bankLogin, String customID, String value, String fileName, boolean isAlert, String alertDay, LocalDateTime expireTime, String certPassword, String certSource, String certType) {
        cerData.set("bank_config_id", (Object)bankConfigId);
        if (StrUtil.isNotBlank((CharSequence)value)) {
            cerData.set("bank_config_value_tag", (Object)value);
        }
        cerData.set("bank_config_name", (Object)bankConfigName);
        cerData.set("bank_login_id", (Object)bankLogin);
        cerData.set("bank_version_id", (Object)bankVersion);
        cerData.set("custom_id", (Object)customID);
        cerData.set("type", (Object)CertType.BANKLOGIN_CER.getType());
        cerData.set("file_name", (Object)fileName);
        if (expireTime != null) {
            cerData.set("expire_time", (Object)Date.from(expireTime.atZone(ZoneId.systemDefault()).toInstant()));
        }
        cerData.set("is_alert", (Object)isAlert);
        cerData.set("cert_source", (Object)certSource);
        cerData.set("cert_type", (Object)certType);
        cerData.set("alert_day", (Object)alertDay);
        cerData.set("cert_password", (Object)certPassword);
        cerData.set("modifytime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        SaveServiceHelper.save((IDataEntityType)cerData.getDataEntityType(), (Object[])new DynamicObject[]{cerData});
    }
}

