/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository.userwordkey;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.entity.userwordkey.UseKeyWordMappingEntity;
import kd.ebg.aqap.common.model.repository.userwordkey.BankInterfaceRepository;
import kd.ebg.aqap.common.model.repository.userwordkey.UseWordKeyRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class UseKeyWordMappingRepository {
    public static final String ENTITY = "aqap_use_key_word_mapping";
    private String SELECT_ALL_PROPERTIES = "id,use_key_word.use_keyword,modifytime,createtime,creator,modifier,type,enable,status,custom_id,usename,interface.interface,interface.id,group.number,bank_key_word";

    public void save(UseKeyWordMappingEntity entity) {
        DynamicObject dynamicObject = this.packInfo(null, entity);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public List<UseKeyWordMappingEntity> getKeyWordListByBankVersionAndInterfaceAndCustomId(String bankVersion, String interfaceName, String customId) {
        DynamicObject[] dynamicObjects;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        ArrayList<UseKeyWordMappingEntity> result = new ArrayList<UseKeyWordMappingEntity>(16);
        if (StringUtils.isNotEmpty((String)bankVersion)) {
            expression.append("and group.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)interfaceName)) {
            expression.append("and interface.interface=?").append(' ');
            paramsList.add(interfaceName);
        }
        expression.append("and enable=?").append(' ');
        paramsList.add("1");
        String expressionStr = expression.toString();
        if (StringUtils.isNotEmpty((String)expressionStr)) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            UseKeyWordMappingEntity entity = this.toEntityInfo(dynamicObject);
            result.add(entity);
        }
        return result;
    }

    public List<UseKeyWordMappingEntity> getListByBankVersionAndInterfaceAndCustomIdAndType(String bankVersion, String interfaceName, String customId, int type) {
        DynamicObject[] dynamicObjects;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        ArrayList<UseKeyWordMappingEntity> result = new ArrayList<UseKeyWordMappingEntity>(16);
        if (StringUtils.isNotEmpty((String)bankVersion)) {
            expression.append("and group.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)interfaceName)) {
            expression.append("and interface.interface=?").append(' ');
            paramsList.add(interfaceName);
        }
        expression.append("and type=?").append(' ');
        paramsList.add(String.valueOf(type));
        String expressionStr = expression.toString();
        if (StringUtils.isNotEmpty((String)expressionStr)) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            UseKeyWordMappingEntity entity = this.toEntityInfo(dynamicObject);
            result.add(entity);
        }
        return result;
    }

    public void update(UseKeyWordMappingEntity entity) {
        DynamicObject dynamicObject = this.findOneById(entity.getId());
        dynamicObject = this.packInfo(dynamicObject, entity);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)ENTITY, (QFilter[])filter.toArray());
        }
    }

    public void deleteAllByIds(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITY);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])ids.toArray());
    }

    public DynamicObject selectById(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
    }

    public boolean isUnique(String wordKey, String customId, String bankVersion, String bankKeyWord, String interfaceName) {
        return this.isUniqueByWordAndInterfaceAndBankKeyWord(wordKey, customId, bankVersion, bankKeyWord, interfaceName) && this.isUniqueByWordAndInterface(wordKey, customId, bankVersion, interfaceName);
    }

    public boolean isUnique(String wordKey, String customId, String bankVersion, String bankKeyWord, String interfaceName, long id) {
        return this.isUniqueByWordAndInterfaceAndBankKeyWord(wordKey, customId, bankVersion, bankKeyWord, interfaceName, id) && this.isUniqueByWordAndInterface(wordKey, customId, bankVersion, interfaceName, id);
    }

    public boolean isUniqueByWordAndInterfaceAndBankKeyWord(String wordKey, String customId, String bankVersion, String bankKeyWord, String interfaceName) {
        QFilter filter;
        DynamicObject[] dynamicObjects;
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        if (StringUtils.isNotEmpty((String)wordKey)) {
            expression.append("and use_key_word.use_keyword=?").append(' ');
            paramsList.add(wordKey);
        }
        if (StringUtils.isNotEmpty((String)bankVersion)) {
            expression.append("and group.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)interfaceName)) {
            expression.append("and interface.interface=?").append(' ');
            paramsList.add(interfaceName);
        }
        if (StringUtils.isNotEmpty((String)bankKeyWord)) {
            expression.append("and bank_key_word=?").append(' ');
            paramsList.add(bankKeyWord);
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        return (dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])(filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray())).toArray())).length == 0;
    }

    public boolean isUniqueByWordAndInterfaceAndBankKeyWord(String wordKey, String customId, String bankVersion, String bankKeyWord, String interfaceName, long id) {
        QFilter filter;
        DynamicObject[] dynamicObjects;
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        if (StringUtils.isNotEmpty((String)wordKey)) {
            expression.append("and use_key_word.use_keyword=?").append(' ');
            paramsList.add(wordKey);
        }
        if (StringUtils.isNotEmpty((String)bankVersion)) {
            expression.append("and group.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)interfaceName)) {
            expression.append("and interface.interface=?").append(' ');
            paramsList.add(interfaceName);
        }
        if (StringUtils.isNotEmpty((String)bankKeyWord)) {
            expression.append("and bank_key_word=?").append(' ');
            paramsList.add(bankKeyWord);
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        if ((dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])(filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray())).toArray())).length == 0) {
            return true;
        }
        if (dynamicObjects.length == 1) {
            DynamicObject dynamicObject = dynamicObjects[0];
            long pid = dynamicObject.getLong("id");
            return pid == id;
        }
        return false;
    }

    public boolean isUniqueByWordAndInterface(String wordKey, String customId, String bankVersion, String interfaceName) {
        QFilter filter;
        DynamicObject[] dynamicObjects;
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        if (StringUtils.isNotEmpty((String)wordKey)) {
            expression.append("and use_key_word.use_keyword=?").append(' ');
            paramsList.add(wordKey);
        }
        if (StringUtils.isNotEmpty((String)bankVersion)) {
            expression.append("and group.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)interfaceName)) {
            expression.append("and interface.interface=?").append(' ');
            paramsList.add(interfaceName);
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        return (dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])(filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray())).toArray())).length == 0;
    }

    public boolean isUniqueByWordAndInterface(String wordKey, String customId, String bankVersion, String interfaceName, long id) {
        QFilter filter;
        DynamicObject[] dynamicObjects;
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        if (StringUtils.isNotEmpty((String)wordKey)) {
            expression.append("and use_key_word.use_keyword=?").append(' ');
            paramsList.add(wordKey);
        }
        if (StringUtils.isNotEmpty((String)bankVersion)) {
            expression.append("and group.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)interfaceName)) {
            expression.append("and interface.interface=?").append(' ');
            paramsList.add(interfaceName);
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        if ((dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])(filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray())).toArray())).length == 0) {
            return true;
        }
        if (dynamicObjects.length == 1) {
            DynamicObject dynamicObject = dynamicObjects[0];
            long pid = dynamicObject.getLong("id");
            return pid == id;
        }
        return false;
    }

    public UseKeyWordMappingEntity findById(long id) {
        DynamicObject dynamicObject = this.findOneById(id);
        if (dynamicObject != null) {
            UseKeyWordMappingEntity entity = this.toEntityInfo(dynamicObject);
            return entity;
        }
        return null;
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    private UseKeyWordMappingEntity toEntityInfo(DynamicObject dynamicObject) {
        String enable;
        if (dynamicObject == null) {
            return null;
        }
        UseKeyWordMappingEntity entity = new UseKeyWordMappingEntity();
        entity.setId(dynamicObject.getLong("id"));
        entity.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        entity.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        entity.setBankKeyWord(dynamicObject.getString("bank_key_word"));
        entity.setInterfaceName(dynamicObject.getString("interface.interface"));
        entity.setInterfaceId(dynamicObject.getLong("interface.id"));
        entity.setBankVersionId(dynamicObject.getString("group.number"));
        entity.setCustomId(dynamicObject.getString("custom_id"));
        entity.setUseKeyword(dynamicObject.getString("use_key_word.use_keyword"));
        String type = dynamicObject.getString("type");
        if (!StringUtils.isEmpty((String)type)) {
            entity.setType(Integer.parseInt(type));
        }
        if (!StringUtils.isEmpty((String)(enable = dynamicObject.getString("enable")))) {
            entity.setEnable(Integer.parseInt(enable));
        }
        String creatorid = dynamicObject.getString("creator");
        entity.setCreatorid(creatorid);
        String modifierid = dynamicObject.getString("modifier");
        entity.setCreatorid(modifierid);
        String status = dynamicObject.getString("status");
        entity.setStatus(status);
        entity.setUseName(dynamicObject.getString("usename"));
        return entity;
    }

    private DynamicObject packInfo(DynamicObject dynamicObject, UseKeyWordMappingEntity entity) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("creator", (Object)entity.getCreatorid());
        } else {
            dynamicObject.set("id", (Object)entity.getId());
            dynamicObject.set("modifytime", (Object)new Date());
        }
        dynamicObject.set("modifier", (Object)entity.getModifierid());
        UseWordKeyRepository useWordKeyRepository = SpringContextUtil.getBean(UseWordKeyRepository.class);
        DynamicObject useWordKeyEntity = useWordKeyRepository.getByUseWordKey(entity.getUseKeyword());
        dynamicObject.set("use_key_word", (Object)useWordKeyEntity);
        BankInterfaceRepository bankInterfaceRepository = SpringContextUtil.getBean(BankInterfaceRepository.class);
        DynamicObject bankDynamic = bankInterfaceRepository.findOneById(entity.getInterfaceId());
        dynamicObject.set("interface", (Object)bankDynamic);
        dynamicObject.set("type", (Object)entity.getType());
        dynamicObject.set("enable", (Object)entity.getEnable());
        dynamicObject.set("status", (Object)entity.getStatus());
        dynamicObject.set("bank_key_word", (Object)entity.getBankKeyWord());
        dynamicObject.set("custom_id", (Object)entity.getCustomId());
        return dynamicObject;
    }
}

