/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.transform;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.SaveDataSet;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.entity.biz.status.UpdateOpState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.transform.BatchUpdateCollector;
import kd.ebg.aqap.common.utils.crypto.PayPrivacyUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PaymentTransFormer {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentTransFormer.class);
    private static PaymentTransFormer instance;
    private final String PAYMENTINFO_ENTITY = "aqap_bd_paymentinfo";
    public static final String SELECT_ALL_PROPERTIES = "id,custom_id,version,bank_login_id,ebg_id,bank_version_id,biz_type,sub_biz_type,impl_class_name,query_impl_class_name,package_key,total_count,total_amount,batch_seq_id,detail_seq_id,detail_biz_no,insert_batch_seq,insert_time,request_seq,request_time,update_time,update_batch_seq,update_operation,verify_field,amount,currency,use_code,use_cn,explanation,same_bank,same_city,urgent,individual,force,merge,fee_type,booking_time,emails,mobiles,acc_no,acc_name,bank_name,bank_address,area_code,acc_dept,acc_country,acc_province,acc_city,third_acc_no,third_acc_name,third_bank_name,third_bank_address,third_area_code,third_acc_dept,income_acc_no,income_acc_name,income_bank_name,income_bank_address,income_area_code,income_acc_dept,income_swift_code,income_cnaps,income_country,income_province,income_city,status_id,status_name,status_msg,bank_status,bank_msg,error_msg,error_stack,back_status,back_status_msg,back_bank_status,back_bank_msg,back_error_msg,back_error_stack,package_time,bank_batch_seq_id,bank_detail_seq_id,bank_serial_no,last_submit_time,last_submit_request_req,submit_count,submit_success_time,last_sync_time,last_sync_request_req,sync_count,pay_finish_date,to_give_up,payer_fee_type,payer_fee_acc_no,payer_fee_currency,exchange_rate,actual_amount,payee_bank_code,transaction_remarks,proxy_acc_no,proxy_acc_name,proxy_bank_country,proxy_bank_area,proxy_bank_swift_code,proxy_bank_name,proxy_bank_address,proxy_fee_type,proxy_fee_currency,pay_currency,ex_contract,bochk_message_bank,bbc_code_words,bank_ref_id,to_ground,iso_currency_code,iso_currency_name,clearing_code,clearing_branch_code,clearing_branch_sub_code,delivery_method,cheque_type,payment_method,service_level,trans_up,linkpay_type,relative_id,linkpay_detail_seq_id,reason,operator,reversed1,reversed2,reversed3,reversed4,reversed_biz_field,reversed_sys_field,income_branch_no,income_branch_name,abstract";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PaymentTransFormer getInstance() {
        Class<PaymentTransFormer> clazz = PaymentTransFormer.class;
        synchronized (PaymentTransFormer.class) {
            if (instance == null) {
                instance = new PaymentTransFormer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public DynamicObject transPaymentInfo(DynamicObject dynamicObject, PaymentInfo info) {
        Date payFinishDate;
        Date lastSyncTime;
        Date lastSubmitTime;
        Date packageTime;
        Date bookingTime;
        Date updateTime;
        Date requestTime;
        Date insertTime;
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"aqap_bd_paymentinfo");
        } else {
            this.setDynamicParamater(dynamicObject, "id", Long.parseLong(info.getId()));
        }
        this.setDynamicParamater(dynamicObject, "custom_id", info.getCustomID());
        if (info.getVersion() == null) {
            info.setVersion(1);
        }
        this.setDynamicParamater(dynamicObject, "version", info.getVersion());
        this.setDynamicParamater(dynamicObject, "bank_login_id", info.getBankLoginID());
        this.setDynamicParamater(dynamicObject, "ebg_id", info.getEbgID());
        this.setDynamicParamater(dynamicObject, "bank_version_id", info.getBankVersionID());
        this.setDynamicParamater(dynamicObject, "biz_type", info.getBizType());
        this.setDynamicParamater(dynamicObject, "sub_biz_type", info.getSubBizType());
        this.setDynamicParamater(dynamicObject, "impl_class_name", info.getImplClassName());
        this.setDynamicParamater(dynamicObject, "query_impl_class_name", info.getQueryImplClassName());
        this.setDynamicParamater(dynamicObject, "package_key", info.getPackageKey());
        this.setDynamicParamater(dynamicObject, "total_count", info.getTotalCount());
        this.setDynamicParamater(dynamicObject, "total_amount", info.getTotalAmount());
        this.setDynamicParamater(dynamicObject, "batch_seq_id", info.getBatchSeqID());
        this.setDynamicParamater(dynamicObject, "detail_seq_id", info.getDetailSeqID());
        this.setDynamicParamater(dynamicObject, "insert_batch_seq", info.getInsertBatchSeq());
        if (info.getInsertTime() != null) {
            insertTime = Date.from(info.getInsertTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("insert_time", (Object)insertTime);
        } else {
            insertTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("insert_time", (Object)insertTime);
        }
        this.setDynamicParamater(dynamicObject, "request_seq", info.getRequestSeq());
        if (info.getRequestTime() != null) {
            requestTime = Date.from(info.getRequestTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("request_time", (Object)requestTime);
        } else {
            requestTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("request_time", (Object)requestTime);
        }
        if (info.getUpdateTime() != null) {
            updateTime = Date.from(info.getUpdateTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("update_time", (Object)updateTime);
        } else {
            updateTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("update_time", (Object)updateTime);
        }
        this.setDynamicParamater(dynamicObject, "update_batch_seq", info.getUpdateBatchSeq());
        this.setDynamicParamater(dynamicObject, "update_operation", info.getUpdateOperation());
        this.setDynamicParamater(dynamicObject, "verify_field", info.getVerifyField());
        this.setDynamicParamater(dynamicObject, "amount", info.getAmount());
        this.setDynamicParamater(dynamicObject, "currency", info.getCurrency());
        this.setDynamicParamater(dynamicObject, "use_cn", info.getUseCN());
        this.setDynamicParamater(dynamicObject, "use_code", info.getUseCode());
        this.setDynamicParamater(dynamicObject, "explanation", info.getExplanation());
        this.setDynamicParamater(dynamicObject, "same_bank", info.getSameBank());
        this.setDynamicParamater(dynamicObject, "same_city", info.getSameCity());
        this.setDynamicParamater(dynamicObject, "urgent", info.getUrgent());
        this.setDynamicParamater(dynamicObject, "individual", info.getIndividual());
        this.setDynamicParamater(dynamicObject, "force", info.getForce());
        this.setDynamicParamater(dynamicObject, "merge", info.getMerge());
        this.setDynamicParamater(dynamicObject, "fee_type", info.getFeeType());
        if (info.getBookingTime() != null) {
            bookingTime = Date.from(info.getBookingTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("booking_time", (Object)bookingTime);
        } else {
            bookingTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("booking_time", (Object)bookingTime);
        }
        this.setDynamicParamater(dynamicObject, "emails", info.getEmails());
        this.setDynamicParamater(dynamicObject, "mobiles", info.getMobiles());
        this.setDynamicParamater(dynamicObject, "acc_no", info.getAccNo());
        this.setDynamicParamater(dynamicObject, "acc_name", info.getAccName());
        this.setDynamicParamater(dynamicObject, "bank_name", info.getBankName());
        this.setDynamicParamater(dynamicObject, "bank_address", info.getBankAddress());
        this.setDynamicParamater(dynamicObject, "area_code", info.getAreaCode());
        this.setDynamicParamater(dynamicObject, "acc_dept", info.getAccDept());
        this.setDynamicParamater(dynamicObject, "acc_country", info.getAccCountry());
        this.setDynamicParamater(dynamicObject, "acc_province", info.getAccProvince());
        this.setDynamicParamater(dynamicObject, "acc_city", info.getAccCity());
        this.setDynamicParamater(dynamicObject, "third_acc_no", info.getThirdAccNo());
        this.setDynamicParamater(dynamicObject, "third_acc_name", info.getThirdAccName());
        this.setDynamicParamater(dynamicObject, "third_bank_name", info.getThirdBankName());
        this.setDynamicParamater(dynamicObject, "third_bank_address", info.getThirdBankAddress());
        this.setDynamicParamater(dynamicObject, "third_area_code", info.getThirdAreaCode());
        this.setDynamicParamater(dynamicObject, "third_acc_dept", info.getThirdAccDept());
        this.setDynamicParamater(dynamicObject, "income_acc_no", info.getIncomeAccNo());
        this.setDynamicParamater(dynamicObject, "income_acc_name", info.getIncomeAccName());
        this.setDynamicParamater(dynamicObject, "income_bank_name", info.getIncomeBankName());
        this.setDynamicParamater(dynamicObject, "income_bank_address", info.getIncomeBankAddress());
        this.setDynamicParamater(dynamicObject, "income_area_code", info.getIncomeAreaCode());
        this.setDynamicParamater(dynamicObject, "income_acc_dept", info.getIncomeAccDept());
        this.setDynamicParamater(dynamicObject, "income_swift_code", info.getIncomeSwiftCode());
        this.setDynamicParamater(dynamicObject, "income_cnaps", info.getIncomeCnaps());
        this.setDynamicParamater(dynamicObject, "income_country", info.getIncomeCountry());
        this.setDynamicParamater(dynamicObject, "income_province", info.getIncomeProvince());
        this.setDynamicParamater(dynamicObject, "income_city", info.getIncomeCity());
        this.setDynamicParamater(dynamicObject, "status_id", info.getStatus());
        this.setDynamicParamater(dynamicObject, "status_name", info.getStatusName());
        this.setDynamicParamater(dynamicObject, "status_msg", info.getStatusMsg());
        this.setDynamicParamater(dynamicObject, "bank_status", info.getBankStatus());
        this.setDynamicParamater(dynamicObject, "bank_msg", info.getBankMsg());
        this.setDynamicParamater(dynamicObject, "error_msg", info.getErrorMsg());
        this.setDynamicParamater(dynamicObject, "error_stack", info.getErrorStack());
        this.setDynamicParamater(dynamicObject, "back_status", info.getBackStatus());
        this.setDynamicParamater(dynamicObject, "back_status_msg", info.getBackStatusMsg());
        this.setDynamicParamater(dynamicObject, "back_bank_msg", info.getBackBankMsg());
        this.setDynamicParamater(dynamicObject, "back_error_msg", info.getBackErrorMsg());
        this.setDynamicParamater(dynamicObject, "back_error_stack", info.getBackErrorStack());
        if (info.getPackageTime() != null) {
            packageTime = Date.from(info.getPackageTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("package_time", (Object)packageTime);
        } else {
            packageTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("package_time", (Object)packageTime);
        }
        this.setDynamicParamater(dynamicObject, "bank_batch_seq_id", info.getBankBatchSeqID());
        this.setDynamicParamater(dynamicObject, "bank_detail_seq_id", info.getBankDetailSeqID());
        this.setDynamicParamater(dynamicObject, "bank_serial_no", info.getBankSerialNo());
        if (info.getLastSubmitTime() != null) {
            lastSubmitTime = Date.from(info.getLastSubmitTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("last_submit_time", (Object)lastSubmitTime);
        } else {
            lastSubmitTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("last_submit_time", (Object)lastSubmitTime);
        }
        this.setDynamicParamater(dynamicObject, "last_submit_request_req", info.getLastSubmitRequestReq());
        if (info.getSubmitCount() == null || info.getSubmitCount() == 0) {
            dynamicObject.set("submit_count", (Object)1);
        } else {
            this.setDynamicParamater(dynamicObject, "submit_count", info.getSubmitCount());
        }
        if (info.getSubmitSuccessTime() != null) {
            Date submitSuccessTime = Date.from(info.getSubmitSuccessTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("submit_success_time", (Object)submitSuccessTime);
        }
        if (info.getLastSyncTime() != null) {
            lastSyncTime = Date.from(info.getLastSyncTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("last_sync_time", (Object)lastSyncTime);
        } else {
            lastSyncTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("last_sync_time", (Object)lastSyncTime);
        }
        this.setDynamicParamater(dynamicObject, "last_sync_request_req", info.getLastSyncRequestReq());
        if (info.getSyncCount() == null || info.getSyncCount() == 0) {
            dynamicObject.set("sync_count", (Object)0);
        } else {
            this.setDynamicParamater(dynamicObject, "sync_count", info.getSyncCount());
        }
        if (info.getPayFinishDate() != null) {
            payFinishDate = Date.from(info.getPayFinishDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("pay_finish_date", (Object)payFinishDate);
        } else {
            payFinishDate = Date.from(LocalDate.now().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("pay_finish_date", (Object)payFinishDate);
        }
        this.setDynamicParamater(dynamicObject, "to_give_up", info.getToGiveUp());
        this.setDynamicParamater(dynamicObject, "payer_fee_type", info.getPayerFeeType());
        this.setDynamicParamater(dynamicObject, "payer_fee_acc_no", info.getPayerFeeAccNo());
        this.setDynamicParamater(dynamicObject, "payer_fee_currency", info.getPayerFeeCurrency());
        this.setDynamicParamater(dynamicObject, "exchange_rate", info.getExchangeRate());
        this.setDynamicParamater(dynamicObject, "actual_amount", info.getActualAmount());
        this.setDynamicParamater(dynamicObject, "payee_bank_code", info.getPayeeBankCode());
        this.setDynamicParamater(dynamicObject, "transaction_remarks", info.getTransactionRemarks());
        this.setDynamicParamater(dynamicObject, "proxy_acc_no", info.getProxyAccNo());
        this.setDynamicParamater(dynamicObject, "proxy_acc_name", info.getProxyAccName());
        this.setDynamicParamater(dynamicObject, "proxy_bank_country", info.getProxyBankCountry());
        this.setDynamicParamater(dynamicObject, "proxy_bank_area", info.getProxyBankArea());
        this.setDynamicParamater(dynamicObject, "proxy_bank_swift_code", info.getProxyBankSwiftCode());
        this.setDynamicParamater(dynamicObject, "proxy_bank_name", info.getProxyBankName());
        this.setDynamicParamater(dynamicObject, "proxy_bank_address", info.getProxyBankAddress());
        this.setDynamicParamater(dynamicObject, "proxy_fee_type", info.getProxyFeeType());
        this.setDynamicParamater(dynamicObject, "proxy_fee_currency", info.getProxyFeeCurrency());
        this.setDynamicParamater(dynamicObject, "pay_currency", info.getPayCurrency());
        this.setDynamicParamater(dynamicObject, "ex_contract", info.getExContract());
        this.setDynamicParamater(dynamicObject, "bochk_message_bank", info.getBochkMessageBank());
        this.setDynamicParamater(dynamicObject, "bbc_code_words", info.getBbcCodeWords());
        this.setDynamicParamater(dynamicObject, "bank_ref_id", info.getBankRefID());
        this.setDynamicParamater(dynamicObject, "to_ground", info.getToGround());
        this.setDynamicParamater(dynamicObject, "iso_currency_code", info.getIsoCurrencyCode());
        this.setDynamicParamater(dynamicObject, "iso_currency_name", info.getIsoCurrencyName());
        this.setDynamicParamater(dynamicObject, "clearing_code", info.getClearingCode());
        this.setDynamicParamater(dynamicObject, "clearing_branch_code", info.getClearingBranchCode());
        this.setDynamicParamater(dynamicObject, "clearing_branch_sub_code", info.getClearingBranchSubCode());
        this.setDynamicParamater(dynamicObject, "delivery_method", info.getDeliveryMethod());
        this.setDynamicParamater(dynamicObject, "cheque_type", info.getChequeType());
        this.setDynamicParamater(dynamicObject, "payment_method", info.getPaymentMethod());
        this.setDynamicParamater(dynamicObject, "service_level", info.getServiceLevel());
        this.setDynamicParamater(dynamicObject, "trans_up", info.getTransUp());
        this.setDynamicParamater(dynamicObject, "linkpay_type", info.getLinkpayType());
        this.setDynamicParamater(dynamicObject, "relative_id", info.getRelativeId());
        this.setDynamicParamater(dynamicObject, "linkpay_detail_seq_id", info.getLinkpayDetailSeqId());
        this.setDynamicParamater(dynamicObject, "operator", info.getOperator());
        this.setDynamicParamater(dynamicObject, "reason", info.getReason());
        this.setDynamicParamater(dynamicObject, "status", "A");
        this.setDynamicParamater(dynamicObject, "reversed1", info.getReversed1());
        this.setDynamicParamater(dynamicObject, "reversed2", info.getReversed2());
        this.setDynamicParamater(dynamicObject, "reversed3", info.getReversed3());
        this.setDynamicParamater(dynamicObject, "reversed4", info.getReversed4());
        this.setDynamicParamater(dynamicObject, "reversed_biz_field", info.getReversedBizField());
        this.setDynamicParamater(dynamicObject, "reversed_sys_field", info.getReversedSysField());
        if (info.isIdempotency()) {
            if (StringUtils.isEmpty((String)info.getDetailBizNo())) {
                info.setDetailBizNo(info.getDetailSeqID());
            }
            if (info.getStatus().intValue() == PaymentState.FAIL.getId()) {
                info.setBackBankStatus(info.getDetailSeqID());
            } else {
                info.setBackBankStatus("1");
            }
        } else {
            info.setBackBankStatus(info.getDetailSeqID());
        }
        this.setDynamicParamater(dynamicObject, "detail_biz_no", info.getDetailBizNo());
        this.setDynamicParamater(dynamicObject, "back_bank_status", info.getBackBankStatus());
        this.setDynamicParamater(dynamicObject, "income_branch_no", info.getIncomeBranchNo());
        this.setDynamicParamater(dynamicObject, "income_branch_name", info.getIncomeBranchName());
        this.setDynamicParamater(dynamicObject, "abstract", info.getAbstractMsg());
        return dynamicObject;
    }

    public void setDynamicParamater(DynamicObject dynamicObject, String key, Object value) {
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)((String)value))) {
                value = " ";
            }
        } else if (value instanceof Integer && value == null) {
            value = 0;
        }
        dynamicObject.set(key, value);
    }

    public DynamicObject transPaymentInfo(PaymentInfo info) {
        return this.transPaymentInfo(null, info);
    }

    public PaymentInfo packPaymentInfo(DynamicObject dynamicObject) {
        PaymentInfo paymentInfo = new PaymentInfo();
        String time = "";
        paymentInfo.setId(dynamicObject.getString("id"));
        paymentInfo.setCustomID(dynamicObject.getString("custom_id"));
        paymentInfo.setVersion(dynamicObject.getInt("version"));
        paymentInfo.setBankLoginID(dynamicObject.getString("bank_login_id"));
        paymentInfo.setEbgID(dynamicObject.getString("ebg_id"));
        paymentInfo.setBankVersionID(dynamicObject.getString("bank_version_id"));
        paymentInfo.setBizType(dynamicObject.getString("biz_type"));
        paymentInfo.setSubBizType(dynamicObject.getString("sub_biz_type"));
        paymentInfo.setImplClassName(dynamicObject.getString("impl_class_name"));
        paymentInfo.setQueryImplClassName(dynamicObject.getString("query_impl_class_name"));
        paymentInfo.setPackageKey(dynamicObject.getString("package_key"));
        paymentInfo.setTotalCount(dynamicObject.getInt("total_count"));
        paymentInfo.setTotalAmount(dynamicObject.getBigDecimal("total_amount").setScale(2));
        paymentInfo.setBatchSeqID(dynamicObject.getString("batch_seq_id"));
        paymentInfo.setDetailSeqID(dynamicObject.getString("detail_seq_id"));
        paymentInfo.setDetailBizNo(dynamicObject.getString("detail_biz_no"));
        paymentInfo.setInsertBatchSeq(dynamicObject.getString("insert_batch_seq"));
        time = dynamicObject.getString("insert_time");
        if (!this.isEmpty(time)) {
            paymentInfo.setInsertTime(DTFactoryUtil.parseDateTime((String)time));
        }
        paymentInfo.setRequestSeq(dynamicObject.getString("request_seq"));
        time = dynamicObject.getString("request_time");
        if (!this.isEmpty(time)) {
            paymentInfo.setRequestTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("update_time"))) {
            paymentInfo.setUpdateTime(DTFactoryUtil.parseDateTime((String)time));
        }
        paymentInfo.setUpdateBatchSeq(dynamicObject.getString("update_batch_seq"));
        paymentInfo.setUpdateOperation(dynamicObject.getString("update_operation"));
        paymentInfo.setVerifyField(dynamicObject.getString("verify_field"));
        paymentInfo.setAmount(dynamicObject.getBigDecimal("amount").setScale(2));
        paymentInfo.setCurrency(dynamicObject.getString("currency"));
        paymentInfo.setUseCode(dynamicObject.getString("use_code"));
        paymentInfo.setUseCN(dynamicObject.getString("use_cn"));
        paymentInfo.setExplanation(dynamicObject.getString("explanation"));
        paymentInfo.setSameBank(dynamicObject.getBoolean("same_bank"));
        paymentInfo.setSameCity(dynamicObject.getBoolean("same_city"));
        paymentInfo.setUrgent(dynamicObject.getBoolean("urgent"));
        paymentInfo.setIndividual(dynamicObject.getBoolean("individual"));
        paymentInfo.setForce(dynamicObject.getBoolean("force"));
        paymentInfo.setMerge(dynamicObject.getBoolean("merge"));
        paymentInfo.setFeeType(dynamicObject.getString("fee_type"));
        time = dynamicObject.getString("booking_time");
        if (!this.isEmpty(time)) {
            paymentInfo.setBookingTime(DTFactoryUtil.parseDateTime((String)time));
        }
        paymentInfo.setEmails(dynamicObject.getString("emails"));
        paymentInfo.setMobiles(dynamicObject.getString("mobiles"));
        paymentInfo.setAccNo(dynamicObject.getString("acc_no"));
        paymentInfo.setAccName(dynamicObject.getString("acc_name"));
        paymentInfo.setBankName(dynamicObject.getString("bank_name"));
        paymentInfo.setBankAddress(dynamicObject.getString("bank_address"));
        paymentInfo.setAreaCode(dynamicObject.getString("area_code"));
        paymentInfo.setAccDept(dynamicObject.getString("acc_dept"));
        paymentInfo.setAccCountry(dynamicObject.getString("acc_country"));
        paymentInfo.setAccProvince(dynamicObject.getString("acc_province"));
        paymentInfo.setAccCity(dynamicObject.getString("acc_city"));
        paymentInfo.setThirdAccNo(dynamicObject.getString("third_acc_no"));
        paymentInfo.setThirdAccName(dynamicObject.getString("third_acc_name"));
        paymentInfo.setThirdBankName(dynamicObject.getString("third_bank_name"));
        paymentInfo.setThirdBankAddress(dynamicObject.getString("third_bank_address"));
        paymentInfo.setThirdAreaCode(dynamicObject.getString("third_area_code"));
        paymentInfo.setThirdAccDept(dynamicObject.getString("third_acc_dept"));
        paymentInfo.setIncomeAccNo(dynamicObject.getString("income_acc_no"));
        paymentInfo.setIncomeAccName(dynamicObject.getString("income_acc_name"));
        paymentInfo.setIncomeBankName(dynamicObject.getString("income_bank_name"));
        paymentInfo.setIncomeBankAddress(dynamicObject.getString("income_bank_address"));
        paymentInfo.setIncomeAreaCode(dynamicObject.getString("income_area_code"));
        paymentInfo.setIncomeAccDept(dynamicObject.getString("income_acc_dept"));
        paymentInfo.setIncomeSwiftCode(dynamicObject.getString("income_swift_code"));
        paymentInfo.setIncomeCnaps(dynamicObject.getString("income_cnaps"));
        paymentInfo.setIncomeCountry(dynamicObject.getString("income_country"));
        paymentInfo.setIncomeProvince(dynamicObject.getString("income_province"));
        paymentInfo.setIncomeCity(dynamicObject.getString("income_city"));
        paymentInfo.setStatus(dynamicObject.getInt("status_id"));
        paymentInfo.setStatusName(dynamicObject.getString("status_name"));
        paymentInfo.setStatusMsg(dynamicObject.getString("status_msg"));
        paymentInfo.setBankStatus(dynamicObject.getString("bank_status"));
        paymentInfo.setBankMsg(dynamicObject.getString("bank_msg"));
        paymentInfo.setErrorMsg(dynamicObject.getString("error_msg"));
        paymentInfo.setErrorStack(dynamicObject.getString("error_stack"));
        paymentInfo.setBackStatus(dynamicObject.getInt("back_status"));
        paymentInfo.setBackStatusMsg(dynamicObject.getString("back_status_msg"));
        paymentInfo.setBackBankStatus(dynamicObject.getString("back_bank_status"));
        paymentInfo.setBackBankMsg(dynamicObject.getString("back_bank_msg"));
        paymentInfo.setBackErrorMsg(dynamicObject.getString("back_error_msg"));
        paymentInfo.setBackErrorStack(dynamicObject.getString("back_error_stack"));
        time = dynamicObject.getString("package_time");
        if (!this.isEmpty(time)) {
            paymentInfo.setPackageTime(DTFactoryUtil.parseDateTime((String)time));
        }
        paymentInfo.setBankBatchSeqID(dynamicObject.getString("bank_batch_seq_id"));
        paymentInfo.setBankDetailSeqID(dynamicObject.getString("bank_detail_seq_id"));
        paymentInfo.setBankSerialNo(dynamicObject.getString("bank_serial_no"));
        time = dynamicObject.getString("last_submit_time");
        if (!this.isEmpty(time)) {
            paymentInfo.setLastSubmitTime(DTFactoryUtil.parseDateTime((String)time));
        }
        paymentInfo.setLastSubmitRequestReq(dynamicObject.getString("last_submit_request_req"));
        paymentInfo.setSubmitCount(dynamicObject.getInt("submit_count"));
        time = dynamicObject.getString("submit_success_time");
        if (!this.isEmpty(time)) {
            paymentInfo.setSubmitSuccessTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("last_sync_time"))) {
            paymentInfo.setLastSyncTime(DTFactoryUtil.parseDateTime((String)time));
        }
        paymentInfo.setLastSyncRequestReq(dynamicObject.getString("last_sync_request_req"));
        paymentInfo.setSyncCount(dynamicObject.getInt("sync_count"));
        time = dynamicObject.getString("pay_finish_date");
        if (!this.isEmpty(time)) {
            paymentInfo.setPayFinishDate(DTFactoryUtil.parseDate((String)time));
        }
        paymentInfo.setToGiveUp(dynamicObject.getBoolean("to_give_up"));
        paymentInfo.setPayerFeeType(dynamicObject.getString("payer_fee_type"));
        paymentInfo.setPayerFeeAccNo(dynamicObject.getString("payer_fee_acc_no"));
        paymentInfo.setPayerFeeCurrency(dynamicObject.getString("payer_fee_currency"));
        paymentInfo.setExchangeRate(dynamicObject.getString("exchange_rate"));
        paymentInfo.setActualAmount(dynamicObject.getBigDecimal("actual_amount").setScale(2));
        paymentInfo.setPayeeBankCode(dynamicObject.getString("payee_bank_code"));
        paymentInfo.setTransactionRemarks(dynamicObject.getString("transaction_remarks"));
        paymentInfo.setProxyAccNo(dynamicObject.getString("proxy_acc_no"));
        paymentInfo.setProxyAccName(dynamicObject.getString("proxy_acc_name"));
        paymentInfo.setProxyBankCountry(dynamicObject.getString("proxy_bank_country"));
        paymentInfo.setProxyBankArea(dynamicObject.getString("proxy_bank_area"));
        paymentInfo.setProxyBankSwiftCode(dynamicObject.getString("proxy_bank_swift_code"));
        paymentInfo.setProxyBankName(dynamicObject.getString("proxy_bank_name"));
        paymentInfo.setProxyBankAddress(dynamicObject.getString("proxy_bank_address"));
        paymentInfo.setProxyFeeType(dynamicObject.getString("proxy_fee_type"));
        paymentInfo.setProxyFeeCurrency(dynamicObject.getString("proxy_fee_currency"));
        paymentInfo.setPayCurrency(dynamicObject.getString("pay_currency"));
        paymentInfo.setExContract(dynamicObject.getString("ex_contract"));
        paymentInfo.setBochkMessageBank(dynamicObject.getString("bochk_message_bank"));
        paymentInfo.setBbcCodeWords(dynamicObject.getString("bbc_code_words"));
        paymentInfo.setBankRefID(dynamicObject.getString("bank_ref_id"));
        paymentInfo.setToGround(dynamicObject.getBoolean("to_ground"));
        paymentInfo.setIsoCurrencyCode(dynamicObject.getString("iso_currency_code"));
        paymentInfo.setIsoCurrencyName(dynamicObject.getString("iso_currency_name"));
        paymentInfo.setClearingCode(dynamicObject.getString("clearing_code"));
        paymentInfo.setClearingBranchCode(dynamicObject.getString("clearing_branch_code"));
        paymentInfo.setClearingBranchSubCode(dynamicObject.getString("clearing_branch_sub_code"));
        paymentInfo.setDeliveryMethod(dynamicObject.getString("delivery_method"));
        paymentInfo.setChequeType(dynamicObject.getString("cheque_type"));
        paymentInfo.setPaymentMethod(dynamicObject.getString("payment_method"));
        paymentInfo.setServiceLevel(dynamicObject.getString("service_level"));
        paymentInfo.setTransUp(dynamicObject.getString("trans_up"));
        paymentInfo.setLinkpayType(dynamicObject.getString("linkpay_type"));
        paymentInfo.setRelativeId(dynamicObject.getString("relative_id"));
        paymentInfo.setLinkpayDetailSeqId(dynamicObject.getString("linkpay_detail_seq_id"));
        paymentInfo.setOperator(dynamicObject.getString("operator"));
        paymentInfo.setReason(dynamicObject.getString("reason"));
        paymentInfo.setReversed1(dynamicObject.getString("reversed1"));
        paymentInfo.setReversed2(dynamicObject.getString("reversed2"));
        paymentInfo.setReversed3(dynamicObject.getString("reversed3"));
        paymentInfo.setReversed4(dynamicObject.getString("reversed4"));
        paymentInfo.setReversedBizField(dynamicObject.getString("reversed_biz_field"));
        paymentInfo.setReversedSysField(dynamicObject.getString("reversed_sys_field"));
        String agentAccNo = paymentInfo.getSys("agentAccNo");
        if (StringUtils.isNotEmpty((String)agentAccNo)) {
            paymentInfo.setAgentAccNo(agentAccNo);
        }
        paymentInfo.setIncomeBranchName(dynamicObject.getString("income_branch_name"));
        paymentInfo.setIncomeBranchNo(dynamicObject.getString("income_branch_no"));
        paymentInfo.setAbstractMsg(dynamicObject.getString("abstract"));
        return paymentInfo;
    }

    public BatchUpdateCollector getBatchUpdateCollector(SaveDataSet saveDataSet) {
        BatchUpdateCollector batchUpdateCollector = new BatchUpdateCollector();
        ArrayList<Object[]> parasList = new ArrayList<Object[]>(1);
        Iterator dataTableIterator = saveDataSet.getTables().iterator();
        ISaveDataTable dataTable = (ISaveDataTable)dataTableIterator.next();
        ISaveMetaRow[] saveMetaRows = dataTable.getSaveRows();
        Iterator iSaveMetaRowIterable = Arrays.stream(saveMetaRows).iterator();
        while (iSaveMetaRowIterable.hasNext()) {
            List privateDirtyValues = ((ISaveMetaRow)iSaveMetaRowIterable.next()).getDirtyValues();
            ArrayList<Object> paras = new ArrayList<Object>(1);
            StringBuilder sql = new StringBuilder();
            int version = 0;
            long id = 0L;
            Map<String, Object> map = PayPrivacyUtil.getPYDefaultValue(dataTable);
            sql.append("UPDATE ").append(dataTable.getSchema().getName()).append(" SET ");
            for (IColumnValuePair field : privateDirtyValues) {
                String columName = field.getColumn().getName();
                if (columName.equalsIgnoreCase("fid")) {
                    id = (Long)field.getValue();
                    continue;
                }
                if (columName.equalsIgnoreCase("fversion")) {
                    version = (Integer)field.getValue();
                    continue;
                }
                if (map.containsKey(columName)) {
                    sql.append(columName).append("=?,");
                    paras.add(map.get(columName));
                    continue;
                }
                if (field.getValue() == null) continue;
                sql.append(columName).append("=?,");
                paras.add(field.getValue());
            }
            sql.append("fversion=fversion+1 ");
            sql.append("WHERE fversion=? and Fid=?");
            paras.add(version);
            paras.add(id);
            parasList.add(paras.toArray());
            if (!this.isEmpty(batchUpdateCollector.getSql())) continue;
            batchUpdateCollector.setSql(sql.toString());
        }
        batchUpdateCollector.setListParas(parasList);
        return batchUpdateCollector;
    }

    public List<PaymentInfo> updateWithVersion(List<PaymentInfo> paymentInfos) {
        if (paymentInfos.size() > 0) {
            try {
                ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
                for (PaymentInfo paymentInfo : paymentInfos) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"aqap_bd_paymentinfo");
                    dynamicObjectList.add(PaymentTransFormer.getInstance().transPaymentInfo(dynamicObject, paymentInfo));
                }
                DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[paymentInfos.size()]);
                logger.info("\u5f85\u66f4\u65b0\u4ed8\u6b3e\u8bb0\u5f55(\u6253\u5305\u5904\u7406->\u51c6\u5907\u63d0\u4ea4\u94f6\u884c)\uff1a{}\u6761", (Object)paymentInfos.size());
                this.updateWithVersion(dynamicObjects, paymentInfos);
                logger.info("\u4ed8\u6b3e\u8bb0\u5f55(\u6253\u5305\u5904\u7406->\u51c6\u5907\u63d0\u4ea4\u94f6\u884c)\u66f4\u65b0\u5b8c\u6210");
            }
            catch (Exception e) {
                logger.error("\u4ed8\u6b3e\u8bb0\u5f55(\u6253\u5305\u5904\u7406->\u51c6\u5907\u63d0\u4ea4\u94f6\u884c)\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                return null;
            }
        }
        return paymentInfos;
    }

    public void updateWithVersion(DynamicObject[] dynamicObjects, List<PaymentInfo> paymentInfos) {
        IDataEntityType type = dynamicObjects[0].getDataEntityType();
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        SaveDataSet saveDataSet = (SaveDataSet)dataManager.getSaveDataSet((Object[])dynamicObjects, true);
        BatchUpdateCollector batchUpdateCollector = this.getBatchUpdateCollector(saveDataSet);
        TXHandle h = TX.required();
        try {
            int[] result = DB.executeBatch((DBRoute)DBRoute.of((String)dataManager.getDataEntityType().getDBRouteKey()), (String)batchUpdateCollector.getSql(), batchUpdateCollector.getListParas());
            for (int i = 0; i < result.length; ++i) {
                if (result[i] != 0) continue;
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25\uff0c\u4e50\u89c2\u9501\u68c0\u67e5\u4e0d\u901a\u8fc7\u3002", (String)"PaymentTransFormer_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
            }
            for (PaymentInfo info : paymentInfos) {
                info.setVersion(info.getVersion() + 1);
            }
        }
        catch (Throwable ex) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (h != null) {
                try {
                    h.close();
                }
                catch (Throwable result) {}
            }
        }
    }

    public BatchUpdateCollector getBatchUpdateStatusCollector(SaveDataSet saveDataSet, boolean isManual) {
        BatchUpdateCollector batchUpdateCollector = new BatchUpdateCollector();
        ArrayList<Object[]> parasList = new ArrayList<Object[]>(1);
        Iterator dataTableIterator = saveDataSet.getTables().iterator();
        ISaveDataTable dataTable = (ISaveDataTable)dataTableIterator.next();
        ISaveMetaRow[] saveMetaRows = dataTable.getSaveRows();
        Iterator iSaveMetaRowIterable = Arrays.stream(saveMetaRows).iterator();
        while (iSaveMetaRowIterable.hasNext()) {
            List privateDirtyValues = ((ISaveMetaRow)iSaveMetaRowIterable.next()).getDirtyValues();
            ArrayList<Object> paras = new ArrayList<Object>(1);
            StringBuilder sql = new StringBuilder();
            int statusID = 0;
            long id = 0L;
            Map<String, Object> map = PayPrivacyUtil.getPYDefaultValue(dataTable);
            sql.append("UPDATE ").append(dataTable.getSchema().getName()).append(" SET ");
            for (IColumnValuePair field : privateDirtyValues) {
                String columName = field.getColumn().getName();
                if (columName.equalsIgnoreCase("fid")) {
                    id = (Long)field.getValue();
                    continue;
                }
                if (columName.equalsIgnoreCase("fversion")) continue;
                if (map.containsKey(columName)) {
                    sql.append(columName).append("=?,");
                    paras.add(map.get(columName));
                    continue;
                }
                if (field.getValue() == null) continue;
                if (columName.equalsIgnoreCase("fstatus_id")) {
                    statusID = (Integer)field.getValue();
                }
                sql.append(columName).append("=?,");
                paras.add(field.getValue());
            }
            sql.append("fversion=fversion+1 ");
            if (isManual) {
                sql.append("WHERE fstatus_id<>? and Fid=?");
                paras.add(statusID);
                paras.add(id);
            } else {
                sql.append("WHERE fstatus_id<>? and Fid=? and fupdate_operation<>? and fupdate_operation<>?");
                paras.add(statusID);
                paras.add(id);
                paras.add(UpdateOpState.MANUAL.getId());
                paras.add(UpdateOpState.DETAIL_SYNC_PAY_SUCCESS.getId());
            }
            parasList.add(paras.toArray());
            if (!this.isEmpty(batchUpdateCollector.getSql())) continue;
            batchUpdateCollector.setSql(sql.toString());
        }
        batchUpdateCollector.setListParas(parasList);
        return batchUpdateCollector;
    }

    public boolean updateWithStatus(DynamicObject[] dynamicObjects, PaymentInfo paymentInfo, boolean isManual) {
        IDataEntityType type = dynamicObjects[0].getDataEntityType();
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        SaveDataSet saveDataSet = (SaveDataSet)dataManager.getSaveDataSet((Object[])dynamicObjects, true);
        BatchUpdateCollector batchUpdateCollector = this.getBatchUpdateStatusCollector(saveDataSet, isManual);
        TXHandle h = TX.required();
        try {
            boolean isUpdate = DB.execute((DBRoute)DBRoute.of((String)dataManager.getDataEntityType().getDBRouteKey()), (String)batchUpdateCollector.getSql(), (Object[])batchUpdateCollector.getListParas().get(0));
            paymentInfo.setVersion(paymentInfo.getVersion() + 1);
            boolean bl = isUpdate;
            return bl;
        }
        catch (Throwable ex) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (h != null) {
                try {
                    h.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

