/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.security.utils;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.security.proxy.ProxyException;
import kd.ebg.aqap.common.security.proxy.ProxySignature;
import kd.ebg.aqap.common.security.utils.CertReader;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;

public class PaySignature {
    private static final PaySignature instance = new PaySignature();
    private boolean isInit;
    private ProxySignature signature;
    private ProxySignature verifySignature;

    public static PaySignature getInstance() {
        return instance;
    }

    public void setSignature(ProxySignature signature) {
        this.signature = signature;
    }

    public ProxySignature getSignature() {
        return this.signature;
    }

    public void setVerifySignature(ProxySignature verifySignature) {
        this.verifySignature = verifySignature;
    }

    public ProxySignature getVerifySignature() {
        return this.verifySignature;
    }

    private static Map<String, String> getPaySignKey(boolean isPrivateKey) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        QFilter filter = null;
        filter = isPrivateKey ? QFilter.of((String)"file_name=? and bank_config_id=?", (Object[])new Object[]{"pay_sign.jks", "private_key"}) : QFilter.of((String)"file_name=? and bank_config_id=?", (Object[])new Object[]{"pay_unsign.jks", "public_key"});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_bd_cert", (String)"bank_config_value, bank_config_value_tag", (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            AESCipherSecurity aesCipherSecurity = SpringContextUtil.getBean(AESCipherSecurity.class);
            String cipher = aesCipherSecurity.decrypt(dynamicObject.getString("bank_config_value"));
            String key = aesCipherSecurity.decrypt(dynamicObject.getString("bank_config_value_tag"));
            result.put("key", key);
            result.put("cipher", cipher);
        }
        return result;
    }

    public static void signInit() {
        Map<String, String> result;
        ProxySignature verifySignature;
        ByteArrayInputStream fileStream;
        byte[] fileBytes;
        Map<String, String> result2;
        ProxySignature signature = PaySignature.getInstance().getSignature();
        if (signature == null && (result2 = PaySignature.getPaySignKey(true)).size() > 0) {
            fileBytes = Base64.getDecoder().decode(result2.get("key"));
            fileStream = new ByteArrayInputStream(fileBytes);
            CertReader.setKeyStoreType("JKS");
            CertReader creader = new CertReader(fileStream, result2.get("cipher"), "server");
            try {
                creader.initKeyStore();
                signature = new ProxySignature(creader.getPublicKey(), creader.getPrivateKey());
                signature.init();
                PaySignature.getInstance().setSignature(signature);
            }
            catch (Exception ex) {
                throw new ProxyException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u7b7e\u540d\u5bc6\u94a5\u51fa\u9519\uff1a\u3002", (String)"PaySignature_2", (String)"ebg-aqap-common", (Object[])new Object[0]) + "\n", ex);
            }
        }
        if ((verifySignature = PaySignature.getInstance().getVerifySignature()) == null && (result = PaySignature.getPaySignKey(false)).size() > 0) {
            fileBytes = Base64.getDecoder().decode(result.get("key"));
            fileStream = new ByteArrayInputStream(fileBytes);
            CertReader.setKeyStoreType("JKS");
            CertReader cer_reader = new CertReader(fileStream, result.get("cipher"), "");
            try {
                cer_reader.initKeyStore();
                verifySignature = new ProxySignature(cer_reader.getPublicKey());
                verifySignature.init();
                PaySignature.getInstance().setVerifySignature(verifySignature);
            }
            catch (Exception ex) {
                throw new ProxyException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u9a8c\u7b7e\u5bc6\u94a5\u51fa\u9519\uff1a\u3002", (String)"PaySignature_3", (String)"ebg-aqap-common", (Object[])new Object[0]) + "\n", ex);
            }
        }
        PaySignature.getInstance().isInit = true;
    }

    public String sign(String source) {
        ProxySignature signature;
        if (!this.isInit) {
            PaySignature.signInit();
        }
        if ((signature = PaySignature.getInstance().getSignature()) != null) {
            return signature.sign(source.getBytes(Charset.forName("UTF-8")));
        }
        return null;
    }

    public boolean verify(String sign, String source) {
        ProxySignature verifySignature;
        if (!this.isInit) {
            PaySignature.signInit();
        }
        if ((verifySignature = PaySignature.getInstance().getVerifySignature()) != null) {
            byte[] content = source.getBytes(Charset.forName("UTF-8"));
            return verifySignature.verify(sign, content);
        }
        return false;
    }
}

