/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.ClassPathResource;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.NumberToTextConverter;

public class ISOCountryUtils {
    private static final String FILENAME = "countryCode.xls";
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ISOCountryUtils.class);
    private Map<String, CountryISOCode> countryISOCodeMap;
    private Map<String, CountryISOCode> countryISOCodeMap2;
    private Map<String, CountryISOCode> countryISOCodeMap3;
    private static ISOCountryUtils countryUtils = new ISOCountryUtils();

    private ISOCountryUtils() {
        this.init();
    }

    public static ISOCountryUtils getInstance() {
        return countryUtils;
    }

    public CountryISOCode getCountryInfo(String countryCode) {
        if (StringUtils.isEmpty((String)countryCode)) {
            return null;
        }
        if (countryCode.trim().length() == 3) {
            return this.countryISOCodeMap.get(countryCode);
        }
        return this.countryISOCodeMap2.get(countryCode);
    }

    public CountryISOCode getCountryInfoByName(String countryName) {
        if (StringUtils.isEmpty((String)countryName)) {
            return null;
        }
        return this.countryISOCodeMap3.get(countryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.countryISOCodeMap = new HashMap<String, CountryISOCode>(16);
        this.countryISOCodeMap2 = new HashMap<String, CountryISOCode>(16);
        this.countryISOCodeMap3 = new HashMap<String, CountryISOCode>(16);
        InputStream is = null;
        HSSFWorkbook workbook = null;
        try {
            is = new ClassPathResource(FILENAME).getInputStream();
            workbook = new HSSFWorkbook(is);
            this.read2Map(workbook, this.countryISOCodeMap, this.countryISOCodeMap2, this.countryISOCodeMap3);
        }
        catch (Exception e1) {
            logger.error("\u8bfb\u53d6\u56fd\u5bb6\u4ee3\u7801\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e1);
        }
        finally {
            if (null != is) {
                try {
                    if (null != workbook) {
                        workbook.close();
                    }
                    is.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private void read2Map(HSSFWorkbook book, Map<String, CountryISOCode> map, Map<String, CountryISOCode> map2, Map<String, CountryISOCode> map3) {
        HSSFSheet sheet = book.getSheetAt(0);
        int lastRowNum = sheet.getLastRowNum();
        for (int startRow = 3; startRow < lastRowNum; ++startRow) {
            HSSFRow row = sheet.getRow(startRow);
            HSSFCell cell0 = row.getCell(0);
            if (StringUtils.isEmpty((String)cell0.getStringCellValue())) continue;
            HSSFCell cell1 = row.getCell(1);
            HSSFCell cell2 = row.getCell(2);
            HSSFCell cell3 = row.getCell(3);
            String simple = cell0.getStringCellValue();
            int enSimpleStartPoint = simple.indexOf(" ");
            if (enSimpleStartPoint == -1) {
                logger.error(String.format("countryCode.xls\u7b2c%s\u884c\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5", startRow));
                continue;
            }
            String cnSimple = simple.substring(0, enSimpleStartPoint);
            String enSimple = simple.substring(enSimpleStartPoint + 1);
            HSSFCell cell4 = row.getCell(4);
            String desc = cell4.getStringCellValue();
            int enDescStartPoint = desc.indexOf(" ");
            String cnDesc = desc.substring(0, enDescStartPoint);
            String enDesc = desc.substring(enDescStartPoint + 1, desc.length());
            CountryISOCode code = new CountryISOCode();
            code.setDescCn(cnDesc);
            code.setDescEn(enDesc);
            code.setSimpleCn(cnSimple);
            code.setSimpleEn(enSimple);
            String echar2 = cell1.getStringCellValue();
            code.setEChart2(echar2);
            String echar3 = cell2.getStringCellValue();
            code.setEChart3(echar3);
            code.setNumberCode(NumberToTextConverter.toText((double)cell3.getNumericCellValue()));
            map.put(echar3, code);
            map2.put(echar2, code);
            map3.put(cnSimple, code);
        }
    }
}

