/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbcasia.dc.services.balance;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseAccountQaccbalRequestV1;
import com.icbc.api.response.MybankEnterpriseAccountQaccbalResponseV1;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbcasia.dc.utils.RequestUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public EBBankBalanceResponse balance(BankBalanceRequest req) {
        EBContext ebContext = EBContext.getContext();
        logger.info("-------------\u5de5\u94f6\u4e9a\u6d32\u67e5\u8be2\u4f59\u989d\u6d41\u7a0b\u5f00\u59cb-------------");
        String accNo = req.getAcnt().getAccNo();
        DefaultIcbcClient client = RequestUtil.createClient(accNo);
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        try {
            MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestBizV1 bizContent = new MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestBizV1();
            MybankEnterpriseAccountQaccbalRequestV1 request = new MybankEnterpriseAccountQaccbalRequestV1();
            bizContent.setTransCode("QACCBAL");
            bizContent.setCis(RequestContextUtils.getBankParameterValue((String)"cis"));
            bizContent.setBankCode(RequestContextUtils.getBankParameterValue((String)"bankCode"));
            LocalDateTime transDate = LocalDateTime.now();
            bizContent.setTranDate(transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            bizContent.setTranTime(transDate.format(DateTimeFormatter.ofPattern("HHmmssSSS")));
            bizContent.setfSeqno(RequestContextUtils.getRequestContext().getBankRequestSeq());
            bizContent.setLoginId(RequestContextUtils.getBankParameterValue((String)"certificateId"));
            ArrayList<MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestRdV1> rds = new ArrayList<MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestRdV1>();
            MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestRdV1 rd = new MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestRdV1();
            rd.setiSeqno("1");
            rd.setAccountNo(accNo);
            rd.setBankType("102");
            rd.setCurrency(req.getAcnt().getCurrency());
            rds.add(rd);
            bizContent.setRd(rds);
            bizContent.setTotalNum(Integer.valueOf(rds.size()));
            String baseUrl = RequestContextUtils.getBankParameterValue((String)"ip");
            request.setServiceUrl(baseUrl + "api/mybank/enterprise/account/qaccbal/V1");
            request.setBizContent((BizContent)bizContent);
            JSONObject reqStr2 = (JSONObject)JSONObject.toJSON((Object)request);
            logger.info("\u4f59\u989d\u67e5\u8be2\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:{}" + reqStr2);
            MybankEnterpriseAccountQaccbalResponseV1 response = new MybankEnterpriseAccountQaccbalResponseV1();
            if (ebContext.isUnitTest()) {
                MybankEnterpriseAccountQaccbalResponseV1.MybankEnterpriseAccountQaccbalResponseV1Rd responseV1Rd = new MybankEnterpriseAccountQaccbalResponseV1.MybankEnterpriseAccountQaccbalResponseV1Rd();
                ArrayList listRd = new ArrayList(1);
                responseV1Rd.setUsableBalance(new BigDecimal(1000));
                responseV1Rd.setBalance(new BigDecimal(1000));
                response.setReturnCode(0);
                response.setRd(listRd);
                response.getRd().add(responseV1Rd);
            } else {
                logger.info("\u4e0d\u662f\u5355\u5143\u6d4b\u8bd5");
                response = (MybankEnterpriseAccountQaccbalResponseV1)client.execute((IcbcRequest)request);
            }
            JSONObject reqStr3 = (JSONObject)JSONObject.toJSON((Object)response);
            logger.info("\u4f59\u989d\u67e5\u8be2\u94f6\u884c\u54cd\u5e94\u6570\u636e:" + reqStr3);
            if (response.isSuccess()) {
                List responseRds = response.getRd();
                MybankEnterpriseAccountQaccbalResponseV1.MybankEnterpriseAccountQaccbalResponseV1Rd responseRd = (MybankEnterpriseAccountQaccbalResponseV1.MybankEnterpriseAccountQaccbalResponseV1Rd)responseRds.get(0);
                BalanceInfo info = new BalanceInfo();
                BigDecimal balance = responseRd.getUsableBalance();
                if (Objects.isNull(balance) || StringUtils.isEmpty((String)(balance + ""))) {
                    BalanceUtils.CurrentBalanceVerification verification = BalanceUtils.currentBalanceVerification;
                    info.setError(verification.message());
                } else {
                    info.setAvailableBalance(BigDecimalHelper.div((BigDecimal)balance, (BigDecimal)new BigDecimal("100.00")));
                    info.setCurrentBalance(BigDecimalHelper.div((BigDecimal)responseRd.getBalance(), (BigDecimal)new BigDecimal("100.00")));
                }
                this.setBalanceDateTime(info, LocalDateTime.now());
                this.setBankAcnt(info, req.getAcnt());
                this.setBankCurrency(info, req.getAcnt().getCurrency());
                logger.info("-------------\u89e3\u6790\u5b8c\u6210\uff0c\u5de5\u94f6\u4e9a\u6d32\u67e5\u8be2\u4f59\u989d\u6d41\u7a0b\u7ed3\u675f-------------");
                ebBankBalanceResponse.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{info}));
                return ebBankBalanceResponse;
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), response.getReturnMsg(), response.getReturnCode(), response.getReturnMsg()));
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s\u3002", (String)"BalanceImpl_7", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]);
    }
}

