/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbcasia.dc.services.payment.oversea;

import com.alibaba.fastjson.JSONObject;
import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1;
import com.icbc.api.response.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitResponseV1;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbcasia.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.icbcasia.dc.services.payment.oversea.QueryPayImpl;
import kd.ebg.aqap.banks.icbcasia.dc.utils.PayStatus;
import kd.ebg.aqap.banks.icbcasia.dc.utils.RequestUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PaymentImpl
extends AbstractPayImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100.00");

    public String getDeveloper() {
        return "simon";
    }

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public String getBizCode() {
        return "GLOBALPAY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5168\u7403\u96c6\u4e2d\u4ed8\u6b3e", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "overseaPay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public EBBankPayResponse doBiz(BankPayRequest payRequest) {
        MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitResponseV1 response;
        List paymentInfos = payRequest.getPaymentInfos();
        DefaultIcbcClient client = RequestUtil.createClient(payRequest.getAcnt().getAccNo());
        MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestBizV1 bizContent = new MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestBizV1();
        MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1 request = new MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1();
        bizContent.setTransCode("GLOBALPAY");
        LocalDateTime transDate = LocalDateTime.now();
        bizContent.setTranDate(transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        bizContent.setTranTime(transDate.format(DateTimeFormatter.ofPattern("HHmmssSSS")));
        bizContent.setLanguage("zh_CN");
        bizContent.setfSeqNo(((PaymentInfo)paymentInfos.get(0)).getBatchSeqID());
        bizContent.setZipFlag("0");
        bizContent.setTotalNum(Integer.valueOf(paymentInfos.size()));
        BigDecimal totalAmt = new BigDecimal("0.00");
        ArrayList<MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestRdV1> rds = new ArrayList<MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestRdV1>(1);
        for (PaymentInfo info : paymentInfos) {
            MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestRdV1 rd = new MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestRdV1();
            rds.add(rd);
            rd.setUniBusiId(info.getBankDetailSeqID());
            rd.setiSeqNo(info.getBankSerialNo());
            if (info.is2Merge()) {
                rd.setSettleMode("2");
                rd.setAgentNo(info.getBankBatchSeqId());
            } else {
                rd.setSettleMode("0");
            }
            rd.setPayerAccountNo(payRequest.getAcnt().getAccNo());
            rd.setPayerAccountName(info.getAccName());
            String bicCode = BankBusinessConfig.getBicCode(info.getAccNo());
            if (StringUtils.isEmpty((String)bicCode)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u4ed8\u6b3e\u94f6\u884cBIC swift code,\u8bf7\u5230\u94f6\u4f01\u8d26\u6237\u5185\u914d\u7f6e", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]));
            }
            rd.setPayerBankBic(bicCode);
            rd.setCurrency(info.getCurrency());
            logger.info("\u5f53\u524d\u652f\u4ed8\u7684\u5e01\u79cd\u4e3a" + info.getIsoCurrencyCode());
            if ("CNY".equalsIgnoreCase(info.getIsoCurrencyCode())) {
                HashMap<String, String> tmpMap = new HashMap<String, String>(8);
                tmpMap.put(ResManager.loadKDString((String)"GOD\u8d27\u7269\u8d38\u6613 Cross-border Goods Trade\u3002", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), "1");
                tmpMap.put(ResManager.loadKDString((String)"STR \u670d\u52a1\u8d38\u6613 Cross-border Service Trade", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), "2");
                tmpMap.put(ResManager.loadKDString((String)"CTF \u8d44\u672c\u9879\u4e0b\u8de8\u5883\u652f\u4ed8 Cross-border Capital Transfer\u3002", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), "3");
                tmpMap.put(ResManager.loadKDString((String)"OCA\u5176\u4ed6\u7ecf\u5e38\u9879\u76ee Other Current Account Transactions", (String)"PaymentImpl_5", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), "4");
                tmpMap.put(ResManager.loadKDString((String)"CDN\u6148\u5584\u9879\u76ee Charity", (String)"PaymentImpl_6", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), "6");
                tmpMap.keySet().stream().filter(key -> key.contains(info.getTransactionRemarks())).findFirst().ifPresent(key -> rd.setBusType((String)tmpMap.get(key)));
            }
            rd.setAmount(Long.valueOf(PaymentImpl.convertYuan2CentStr(info.getAmount()).longValue()));
            if (info.is2SameBank()) {
                rd.setSysIoFlag("1");
            } else {
                rd.setSysIoFlag("2");
            }
            rd.setPayeeAccountNo(info.getIncomeAccNo());
            rd.setPayeeAccountName(info.getIncomeAccName());
            rd.setPayeeBankBic(info.getIncomeSwiftCode());
            CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(info.getIncomeCountry());
            if (code == null) {
                code = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
            }
            rd.setPayeeCountry(code.geteChart2());
            totalAmt = totalAmt.add(info.getAmount());
        }
        bizContent.setTotalAmt(Long.valueOf(PaymentImpl.convertYuan2CentStr(totalAmt).longValue()));
        String baseUrl = RequestContextUtils.getBankParameterValue((String)"ip");
        bizContent.setRd(rds);
        request.setServiceUrl(baseUrl + "api/mybank/ospay/enterprise/globalcashmanagement/moegglobalpaysubmit/V1");
        request.setBizContent((BizContent)bizContent);
        JSONObject reqStr2 = (JSONObject)JSONObject.toJSON((Object)request);
        logger.info("\u4ed8\u6b3e\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:{}" + reqStr2);
        try {
            response = (MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitResponseV1)client.execute((IcbcRequest)request);
        }
        catch (Exception e) {
            EBContext.getContext().setThrowableAfterSend((Throwable)e);
            return null;
        }
        JSONObject reqStr3 = (JSONObject)JSONObject.toJSON((Object)response);
        logger.info("\u4ed8\u6b3e\u94f6\u884c\u54cd\u5e94\u6570\u636e:{}" + reqStr3);
        int code = response.getReturnCode();
        String msg = response.getReturnMsg();
        if (response.isSuccess()) {
            String result = response.getResult();
            String returnMsg = response.getReturnMsg();
            String msgid = response.getMsgId();
            PaymentInfoSysFiled.set((List)paymentInfos, (String)"msgid", (String)msgid);
            if ("6".equals(result)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentImpl_7", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), (String)result, (String)returnMsg);
            } else if ("0".equals(result) || "5".equals(result) || "9".equals(result)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5de5\u884c\u63a5\u6536\u4e86\u4ee3\u53d1\u8bf7\u6c42\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u72b6\u6001\u3002", (String)"PaymentImpl_8", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), (String)(code + ""), (String)msg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u72b6\u6001\u672a\u77e5", (String)"PaymentImpl_9", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), (String)(code + ""), (String)msg);
            }
        } else if (PayStatus.INSTANCE.isFail(code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PaymentImpl_10", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), (String)(code + ""), (String)msg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PaymentImpl_10", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), (String)(code + ""), (String)msg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static BigDecimal convertYuan2CentStr(BigDecimal yuan) {
        yuan = yuan.multiply(ONE_HUNDRED);
        yuan = yuan.setScale(0);
        return yuan;
    }
}

