/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbcasia.dc.utils;

import com.icbc.api.DefaultIcbcClient;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class RequestUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(RequestUtil.class);

    public static DefaultIcbcClient createClient2(String accNo) throws Exception {
        IParameter parameter = RequestContextUtils.getParameter();
        String appId = parameter.getBankParameter("appId");
        String privateKey = parameter.getBankParameter("private_key");
        String publicKey = parameter.getBankParameter("public_key");
        if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)privateKey) || StringUtils.isEmpty((String)publicKey)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u666e\u901a\u516c\u94a5\u65b9\u5f0f\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5f02\u5e38", (String)"RequestUtil_4", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]));
        }
        return new DefaultIcbcClient(appId, privateKey, publicKey);
    }

    public static DefaultIcbcClient createClient(String accNo) {
        IParameter parameter = RequestContextUtils.getParameter();
        String appId = parameter.getBankParameter("appId");
        String publicKey = RequestUtil.getKey(RequestUtil.getCA("public_key"));
        String signType = parameter.getBankParameter("signType");
        DefaultIcbcClient client = null;
        if (signType.equals("CA")) {
            String caPublicStr;
            String caPrivateStr;
            logger.info("\u7b7e\u540d\u7c7b\u578b\u4e3aca:" + signType);
            String msg = "signType-0, appId-1, publicKey-2, caPrivateStr-3, caPublicStr-4,caPassword-5";
            String caPassword = parameter.getBankParameter("capassword");
            try {
                caPrivateStr = RequestUtil.getKey(com.icbc.api.internal.util.codec.Base64.encodeBase64((byte[])RequestUtil.getCA("caprivatestr")));
                caPublicStr = RequestUtil.getKey(com.icbc.api.internal.util.codec.Base64.encodeBase64((byte[])RequestUtil.getCA("capublicstr")));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            RequestUtil.checkData(signType, msg, appId, publicKey, caPrivateStr, caPublicStr, caPassword);
            client = new DefaultIcbcClient(appId, caPrivateStr, publicKey, caPublicStr, caPassword);
        } else {
            String msg = "signType-0, appId-1, PrivateKey-2";
            RequestUtil.checkData(signType, msg, appId, publicKey, parameter.getBankParameter("private_key"));
            logger.info("\u7b7e\u540d\u7c7b\u578b\u4e3a:" + signType);
            client = new DefaultIcbcClient(appId, signType, RequestUtil.getKey(RequestUtil.getCA("private_key")), publicKey);
        }
        return client;
    }

    public static byte[] getCA(String id) {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(id, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bc1\u4e66\u3001\u79d8\u94a5\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u8bc1\u4e66\u4e0e\u79d8\u94a5\u3002", (String)"RequestUtil_1", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = RequestUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return fileContent;
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(java.util.Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }

    private static void checkData(String signType, String msg, String ... data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            if (!StringUtils.isEmpty((String)data[i])) continue;
            sb.append(i).append(",");
        }
        if (!StringUtils.isEmpty((String)sb.toString())) {
            throw EBExceiptionUtil.serviceException((String)sb.insert(0, ResManager.loadKDString((String)"\u4e2d\u4e0d\u80fd\u4e3a\u7a7a\u7684\u662f:", (String)"RequestUtil_2", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0])).insert(0, msg).insert(0, ResManager.loadKDString((String)"\u5b9e\u4f8b\u5316\u5ba2\u6237\u7aef\u5f02\u5e38", (String)"RequestUtil_3", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0])).toString());
        }
    }
}

