/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.mufgb.chn.detail;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.mufgb.chn.utils.Packer;
import kd.ebg.aqap.banks.mufgb.chn.utils.Paser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"uri"));
        factory.setHttpHeader("Content-Type", "text/xml");
        factory.setHttpHeader("User-Agent", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)");
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = Packer.createRootWithHead("h2h.001.002");
        Element body = JDomUtils.createRoot((String)"req");
        JDomUtils.addChild((Element)body, (String)"accNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)body, (String)"pageFlag", (String)("0".equalsIgnoreCase(this.getCurrentPage()) ? "" : this.getCurrentPage()));
        JDomUtils.addChild((Element)root, (Element)body);
        String requestMessage = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        this.logger.info("\u660e\u7ec6\u67e5\u8be2\u8bf7\u6c42\u62a5\u6587\u539f\u6587\uff1a" + requestMessage);
        return Packer.transferRequestToWsdl(requestMessage);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        this.setLastPage(true);
        Element root = Paser.parseH2H(rspStr);
        Element head = root.getChild("respInfo");
        String respCode = head.getChildTextTrim("respCode");
        String respMsg = head.getChildTextTrim("respMsg");
        String acceptFlag = head.getChildTextTrim("acceptFlag");
        if (!"1".equalsIgnoreCase(acceptFlag)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s\uff0c\u9519\u8bef\u4fe1\u606f:%2$s", (String)"DetailImpl_0", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), respCode, respMsg));
        }
        Element body = root.getChild("resp");
        String statusFlag = body.getChild("statusFlag").getTextTrim();
        if ("-1".equals(statusFlag)) {
            return new EBBankDetailResponse((List)Lists.newArrayList());
        }
        String accNo = body.getChildText("accNo");
        String pageFlag = body.getChildText("pageFlag");
        if (StringUtils.isNotEmpty((String)pageFlag)) {
            this.setLastPage(false);
            this.setCurrentPage(pageFlag);
        }
        List detList = body.getChildren("row");
        String acctNo = body.getChild("accNo").getTextTrim();
        ArrayList<DetailInfo> lists = new ArrayList<DetailInfo>(detList.size());
        for (Element row : detList) {
            DetailInfo info = new DetailInfo();
            info.setAccNo(acctNo);
            String bookDate = row.getChildTextTrim("bookDate");
            info.setTransDate(LocalDate.parse(bookDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            info.setTransTime(LocalDateTime.parse(bookDate + " 00:00:00", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            info.setCurrency(row.getChildTextTrim("currCode"));
            String dcFlag = row.getChildTextTrim("dcFlag");
            String amount = row.getChildTextTrim("amount");
            if ("C".equalsIgnoreCase(dcFlag)) {
                info.setCreditAmount(new BigDecimal(amount));
                info.setDebitAmount(BigDecimal.ZERO);
            } else if ("D".equalsIgnoreCase(dcFlag)) {
                info.setDebitAmount(new BigDecimal(amount));
                info.setCreditAmount(BigDecimal.ZERO);
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u501f\u8d37\u6807\u8bc6%1$s", (String)"DetailImpl_1", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), dcFlag));
            }
            info.setOppAccNo(row.getChildTextTrim("opAccNo"));
            info.setOppBankName(row.getChildTextTrim("opBankName"));
            String balance = row.getChildTextTrim("balance");
            if (StringUtils.isNotEmpty((String)balance)) {
                info.setBalance(new BigDecimal(balance));
            }
            info.setOppAccName(row.getChildTextTrim("info2"));
            String info1 = row.getChildText("info1");
            info.setExplanation(info1);
            String bankRef = row.getChildTextTrim("bankRef");
            info.setBankDetailNo(bankRef);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            info.setJsonMap(jsonStr);
            lists.add(info);
        }
        return new EBBankDetailResponse(lists);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "h2h.001.002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d3b\u671f\u5e10\u6237\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_2", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

