/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.mufgb.chn.payment;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.mufgb.chn.payment.PayState;
import kd.ebg.aqap.banks.mufgb.chn.payment.QueryPayImpl;
import kd.ebg.aqap.banks.mufgb.chn.utils.Packer;
import kd.ebg.aqap.banks.mufgb.chn.utils.Paser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"uri"));
        factory.setHttpHeader("Content-Type", "text/xml");
        factory.setHttpHeader("User-Agent", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)");
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        Element root = Packer.createRootWithHead("h2h.002.001");
        Element body = JDomUtils.createRoot((String)"req");
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element row = JDomUtils.addChild((Element)body, (String)"row");
        JDomUtils.addChild((Element)row, (String)"corpSerial", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)row, (String)"manualType", (String)"1");
        if (paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)row, (String)"channelType", (String)"1");
        } else {
            JDomUtils.addChild((Element)row, (String)"channelType", (String)"0");
        }
        JDomUtils.addChild((Element)row, (String)"valueDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)row, (String)"currCode", (String)"CNY");
        JDomUtils.addChild((Element)row, (String)"amount", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)row, (String)"proposer");
        JDomUtils.addChild((Element)row, (String)"accNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)row, (String)"bankName", (String)paymentInfo.getBankName());
        JDomUtils.addChild((Element)row, (String)"accName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)row, (String)"opAccName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)row, (String)"opBankName", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)row, (String)"opBankCode", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)row, (String)"opAccNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)row, (String)"opAccProv", (String)paymentInfo.getIncomeProvince());
        JDomUtils.addChild((Element)row, (String)"opAccCity", (String)paymentInfo.getIncomeCity());
        JDomUtils.addChild((Element)row, (String)"usage", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)row, (String)"payType", (String)"00");
        JDomUtils.addChild((Element)row, (String)"svsFlag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)row, (String)"tranFlag", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)row, (String)"customerNo", (String)"");
        JDomUtils.addChild((Element)row, (String)"opType", (String)(paymentInfo.is2Individual() ? "1" : "0"));
        JDomUtils.addChild((Element)row, (String)"type1", (String)"1");
        JDomUtils.addChild((Element)row, (String)"type2", (String)"");
        JDomUtils.addChild((Element)row, (String)"type3", (String)"");
        JDomUtils.addChild((Element)row, (String)"type4", (String)"");
        JDomUtils.addChild((Element)row, (String)"tranCode1", (String)"");
        JDomUtils.addChild((Element)row, (String)"currAmount1", (String)"");
        JDomUtils.addChild((Element)row, (String)"postscript1", (String)"");
        JDomUtils.addChild((Element)row, (String)"tranCode2", (String)"");
        JDomUtils.addChild((Element)row, (String)"currAmount2", (String)"");
        JDomUtils.addChild((Element)row, (String)"postscript2", (String)"");
        JDomUtils.addChild((Element)row, (String)"type5", (String)"");
        JDomUtils.addChild((Element)row, (String)"contractNo", (String)"");
        JDomUtils.addChild((Element)row, (String)"invoiceNo", (String)"");
        JDomUtils.addChild((Element)row, (String)"businessNo", (String)"");
        JDomUtils.addChild((Element)row, (String)"applicant", (String)"");
        JDomUtils.addChild((Element)row, (String)"tel", (String)paymentInfo.getMobiles());
        JDomUtils.addChild((Element)root, (Element)body);
        String reqMsg = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        this.logger.info("\u4ed8\u6b3e\u8bf7\u6c42\u62a5\u6587\u539f\u6587\uff1a" + reqMsg);
        return Packer.transferRequestToWsdl(reqMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = Paser.parseH2H(rspStr);
        Element head = root.getChild("respInfo");
        String respCode = head.getChildTextTrim("respCode");
        String respMsg = head.getChildTextTrim("respMsg");
        String acceptFlag = head.getChildTextTrim("acceptFlag");
        if (!"1".equalsIgnoreCase(acceptFlag)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)respMsg, (String)respCode, (String)respMsg);
        } else {
            Element resp = root.getChild("resp");
            List rows = resp.getChildren("row");
            Element element = (Element)rows.get(0);
            String tranStatus = element.getChildText("tranStatus");
            Map<String, String> paymetStateMap = PayState.getPaymetStateMap();
            String statusMsg = paymetStateMap.get(tranStatus);
            if ("01".equalsIgnoreCase(tranStatus) || "02".equalsIgnoreCase(tranStatus) || "03".equalsIgnoreCase(tranStatus) || "06".equalsIgnoreCase(tranStatus) || "07".equalsIgnoreCase(tranStatus) || "11".equalsIgnoreCase(tranStatus)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), (String)tranStatus, (String)statusMsg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), (String)tranStatus, (String)(StringUtils.isNotEmpty((String)statusMsg) ? statusMsg : respMsg));
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "h2h.002.001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)" PI\u652f\u4ed8\u6307\u4ee4\u7533\u8bf7", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

