/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wechat.dc.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class RequestUtil {
    public static final String charset = "GBK";
    private static UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
    private static final String cert_param_key = "wechat_cert";

    public static String sign(Map<String, String> map, String key) {
        String sign;
        String str = RequestUtil.createLinkString(RequestUtil.paraFilter(map));
        String stringSignTemp = str + "&key=" + key;
        try {
            sign = DigestUtils.md5Hex((byte[])stringSignTemp.getBytes(charset)).toUpperCase(Locale.ENGLISH);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32\u8f6c\u6362\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"RequestUtil_0", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return sign;
    }

    public static String signBySHA256(Map<String, String> map, String key) {
        String sign;
        String str = RequestUtil.createLinkString(RequestUtil.paraFilter(map));
        String stringSignTemp = str + "&key=" + key;
        try {
            sign = RequestUtil.SHA256_HAMC(stringSignTemp, key);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32\u8f6c\u6362\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"RequestUtil_0", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return sign;
    }

    public static String SHA256_HAMC(String data, String key) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        String encoding = RequestContextUtils.getCharset();
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(encoding), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes(encoding));
        return Hex.encodeHexString((byte[])array).toUpperCase();
    }

    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (sArray == null || sArray.size() <= 0) {
            return result;
        }
        for (Map.Entry<String, String> entry : sArray.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null || value.equalsIgnoreCase("") || key.equalsIgnoreCase("sign")) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                buffer.append(key);
                buffer.append('=');
                buffer.append(value);
                continue;
            }
            buffer.append(key);
            buffer.append('=');
            buffer.append(value);
            buffer.append('&');
        }
        prestr = buffer.toString();
        return prestr;
    }

    public static Map<String, Object> getCertInfo(String accNo) {
        CertInfo certInfo = userCertRepository.findAccCertByBankLoginIDAndBankConfigIDAndCustomID(cert_param_key, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId(), accNo);
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6API\u8bc1\u4e66\u5185\u5bb9\u5931\u8d25", (String)"RequestUtil_1", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = RequestUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("key", fileContent);
        result.put("pwd", StringUtils.isEmpty((String)certInfo.getCertPassword()) ? "" : certInfo.getCertPassword());
        return result;
    }

    public static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    public static String getKey(String id, String accNo) {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findAccCertByBankLoginIDAndBankConfigIDAndCustomID(id, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId(), accNo);
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6API KEY\u5931\u8d25\uff0c\u8bf7\u5148\u8fdb\u884c\u914d\u7f6e", (String)"RequestUtil_2", (String)"ebg-aqap-banks-wechat-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = RequestUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return StringUtils.byteToString((byte[])fileContent);
    }
}

