/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.formplugin.plugin.codeless;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.formplugin.plugin.BaseData.OtherBaseDataUtil;
import kd.ebg.egf.formplugin.plugin.util.EBGParamUtils;
import kd.ebg.egf.formplugin.service.biz.BizService;
import kd.ebg.egf.formplugin.service.model.EbgParam;
import kd.ebg.egf.formplugin.service.model.ParamResponseBody;

public class EbgFieldListPlugin
extends AbstractTreeListPlugin {
    private static final String selectColumn = "id, number, name, type_name";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        List qFilters = ((BillList)args.getSource()).getQueryFilterParameter().getQFilters();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        final DynamicObjectCollection dataCollection = this.getCollection(qFilters, (String)customParams.get("bankVersionID"), (String)customParams.get("bizType"));
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return dataCollection.size();
            }

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dObjectCollection = this.getStartToEnd(start, limit, dataCollection);
                int dataCount = dataCollection.size();
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(dataCount);
                return dObjectCollection;
            }

            private DynamicObjectCollection getStartToEnd(int start, int limit, DynamicObjectCollection dCollection) {
                DynamicObjectCollection data = QueryServiceHelper.query((String)"note_ebg_field", (String)EbgFieldListPlugin.selectColumn, null);
                int end = start + limit;
                int size = dCollection.size();
                if (size >= end) {
                    for (int i = start; i < end; ++i) {
                        data.add(dCollection.get(i));
                    }
                } else {
                    for (int i = start; i < size; ++i) {
                        data.add(dCollection.get(i));
                    }
                }
                return data;
            }
        });
    }

    private DynamicObjectCollection getCollection(List<QFilter> qFilters, String bankVersionID, String bizType) {
        Long groupId = null;
        String name = "";
        if (CollectionUtils.isNotEmpty(qFilters)) {
            for (QFilter qFilter : qFilters) {
                if ("group".equals(qFilter.getProperty())) {
                    String temp = qFilter.getValue().toString();
                    if (StringUtils.equals((String)temp, (String)"0")) continue;
                    groupId = (Long)qFilter.getValue();
                    continue;
                }
                if (!"1".equals(qFilter.getProperty())) continue;
                String filter = (String)qFilter.getValue();
                name = filter.substring(filter.indexOf("#") + 1);
            }
        }
        DynamicObjectCollection dCollection = QueryServiceHelper.query((String)"note_ebg_field", (String)selectColumn, null);
        if (groupId != null) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"note_ebg_field_type", (QFilter[])new QFilter("id", "=", groupId).toArray());
            List<EbgParam> ebgParams = this.getEbgParams(bankVersionID, dynamicObject.getString("number"), bizType);
            this.createData(dCollection, ebgParams, groupId, dynamicObject.getString("name"), "");
        } else {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"note_ebg_field_type", (QFilter[])QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"}).toArray());
            Map<String, List<EbgParam>> ebgParamMap = this.getEbgParams(bankVersionID, bizType);
            for (Map.Entry entry : dynamicObjectMap.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                this.createData(dCollection, ebgParamMap.get(dynamicObject.getString("number")), dynamicObject.getLong("id"), dynamicObject.getString("name"), name);
            }
        }
        return dCollection;
    }

    private void createData(DynamicObjectCollection dCollection, List<EbgParam> ebgParams, Long groupId, String typeName, String name) {
        String id = String.valueOf(groupId);
        if (CollectionUtils.isNotEmpty(ebgParams)) {
            for (EbgParam ebgParam : ebgParams) {
                if (!StringUtils.isEmpty((String)name) && ebgParam.getName().indexOf(name) == -1) continue;
                DynamicObject data = dCollection.addNew();
                data.set("id", (Object)id);
                data.set("number", (Object)ebgParam.getKey());
                data.set("name", (Object)ebgParam.getName());
                data.set("type_name", (Object)typeName);
            }
        }
    }

    public Map<String, List<EbgParam>> getEbgParams(String bankVersionID, String bizType) {
        ParamResponseBody body = BizService.getInstance().getEbgParam(RequestContext.get().getTenantId(), bankVersionID);
        HashMap<String, List<EbgParam>> result = new HashMap<String, List<EbgParam>>(16);
        result.put("BANK_LOGIN_CONFIG", body.getLoginConfigs());
        result.put("BANK_ACNT_CONFIG", body.getAcntConfigs());
        result.put("NOTE_METADATA", EBGParamUtils.getNoteReqMetaParamByBizType(bizType));
        result.put("EBG_UTIL", this.getEbgUtilParam());
        return result;
    }

    public List<EbgParam> getEbgParams(String bankVersionID, String type, String bizType) {
        ArrayList<EbgParam> result = new ArrayList<EbgParam>();
        if ("NOTE_METADATA".equals(type)) {
            result.addAll(EBGParamUtils.getNoteReqMetaParamByBizType(bizType));
        } else if ("EBG_UTIL".equals(type)) {
            result.addAll(this.getEbgUtilParam());
        } else {
            ParamResponseBody body = BizService.getInstance().getEbgParam(RequestContext.get().getTenantId(), bankVersionID);
            if ("BANK_LOGIN_CONFIG".equals(type)) {
                result.addAll(body.getLoginConfigs());
            } else if ("BANK_ACNT_CONFIG".equals(type)) {
                result.addAll(body.getAcntConfigs());
            }
        }
        return result;
    }

    List<EbgParam> getEbgUtilParam() {
        Map<String, String> map = OtherBaseDataUtil.getotherBaseDataRequest();
        ArrayList<EbgParam> result = new ArrayList<EbgParam>(16);
        if (map != null) {
            for (Map.Entry<String, String> entrie : map.entrySet()) {
                result.add(new EbgParam(entrie.getValue(), entrie.getKey()));
            }
        }
        return result;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }
}

