/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.formplugin.plugin.codeless;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.formplugin.plugin.common.NoteCodeLessCommonFormPlugin;
import kd.ebg.egf.formplugin.plugin.util.EBGParamUtils;
import kd.ebg.egf.formplugin.plugin.util.JudgingConditionUtil;
import kd.ebg.egf.formplugin.plugin.util.SourceValueEnum;
import kd.ebg.egf.formplugin.service.model.EbgParam;

public class JudgingConditionsFormPlugin
extends NoteCodeLessCommonFormPlugin
implements CellClickListener,
BeforeF7SelectListener {
    private static final String CONDITION_KEY = "condition";
    private static final String JUDGE_TYPE = "judge_type";
    private static String SAVE_YES_KEY = "save_yes";

    public void afterCopyData(EventObject e) {
        this.setNewNumber();
    }

    public void afterCreateNewData(EventObject e) {
        this.setBankVersion();
        this.setNewNumber();
        this.changeCodeField();
    }

    private void setNewNumber() {
        String bankVersionID = this.getBankVersionID();
        if (StringUtils.isEmpty((String)((String)this.getModel().getValue("number")))) {
            String number = "EBGGROUP-" + bankVersionID + "-" + ID.genStringId();
            this.getModel().setValue("number", (Object)number);
        }
    }

    private void setBankVersion() {
        String isFromOldPage = this.getView().getPageCache().get("isFromOldPage");
        if (StringUtils.isNotEmpty((String)isFromOldPage)) {
            String groupID = this.getView().getPageCache().get("groupID");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"note_bank_app_list", (QFilter[])new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{Long.valueOf(groupID)})});
            if (dynamicObject != null) {
                this.getModel().setValue("group", (Object)dynamicObject);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("judgings_entity");
        entryGrid.addCellClickListener((CellClickListener)this);
        EntryGrid entryGrid2 = (EntryGrid)this.getControl("judgings_n_entity");
        entryGrid2.addCellClickListener((CellClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(CONDITION_KEY);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit biztype = (BasedataEdit)this.getView().getControl("biz_type_new");
        biztype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((String)fieldKey, (String)CONDITION_KEY)) {
            String bizType = this.getBizType();
            if (StringUtils.isEmpty((String)bizType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"JudgingConditionsFormPlugin_0", (String)"ebg-note-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            QFilter qFilter = QFilter.of((String)"biz_type_new.number =? and group.id=? and type = ?", (Object[])new Object[]{bizType, this.getModel().getDataEntity().getLong("group.id"), "request"});
            String judgeType = (String)this.getModel().getValue(JUDGE_TYPE);
            if ("parse".equals(judgeType)) {
                qFilter = QFilter.of((String)"biz_type_new.number =? and group.id=? and type = ?", (Object[])new Object[]{bizType, this.getModel().getDataEntity().getLong("group.id"), "parse"});
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if (StringUtils.equals((String)fieldKey, (String)"biz_type_new")) {
            String longnumber = this.getModel().getDataEntity().getString("group.longnumber");
            String type = "";
            if (longnumber.endsWith("NOTE")) {
                type = "NOTE";
            } else if (longnumber.endsWith("CREDIT")) {
                type = "CREDIT";
            } else if (longnumber.endsWith("PAY")) {
                type = "PAY";
            } else if (longnumber.endsWith("DETAIL")) {
                type = "DETAIL";
            } else if (longnumber.endsWith("BALANCE")) {
                type = "BALANCE";
            } else if (longnumber.endsWith("QUERY")) {
                type = "QUERY";
            }
            if (StringUtils.isNotEmpty((String)type)) {
                QFilter qFilter = new QFilter("biz_type", "=", (Object)type);
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        }
    }

    public void cellClick(CellClickEvent evt) {
        String bankVersionID = this.getBankVersionID();
        String bizType = this.getBizType();
        if ("ebg_field".equals(evt.getFieldKey())) {
            if ("ebg_field".equals(this.getModel().getValue("ebgparam_source", evt.getRow()))) {
                this.clickReqEbgField("judgings_entity", evt.getRow(), bizType, bankVersionID);
            }
        } else if ("ebg_field2".equals(evt.getFieldKey()) && "ebg_field".equals(this.getModel().getValue("ebgparam_source2", evt.getRow()))) {
            this.clickReqEbgField("judgings_n_entity", evt.getRow(), bizType, bankVersionID);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null && closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectCollections = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            String rowStr = closedCallBackEvent.getActionId();
            int row = Integer.parseInt(rowStr);
            for (ListSelectedRow selectedRow : selectCollections) {
                this.closedCallBackByEbgField(selectedRow, row);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operateKey = operate.getOperateKey();
        String saveYes = this.getView().getPageCache().get(SAVE_YES_KEY);
        if (("save".equals(operateKey) || "submit".equals(operateKey)) && StringUtils.isEmpty((String)saveYes)) {
            this.newDataSetPageCache();
            String statusName = ((BaseShowParameter)this.getView().getFormShowParameter()).getStatus().name();
            if ("EDIT".equalsIgnoreCase(statusName)) {
                ArrayList<Long> listIds = new ArrayList<Long>();
                listIds.add((Long)this.getModel().getValue("id"));
                JudgingConditionUtil judgingConditionUtil = new JudgingConditionUtil();
                String numbers = judgingConditionUtil.getCodeLessQuoteJudgingConditionsNumbers(listIds);
                if (StringUtils.isNotEmpty((String)numbers)) {
                    String callBackId = "save".equals(operateKey) ? "judging_conditions_save_id" : "judging_conditions_submit_id";
                    callBackId = operate instanceof SaveAndNew ? "judging_conditions_saveAndNew_id" : callBackId;
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u94f6\u884c\u7535\u7968\u63a5\u53e3%s\u5f15\u7528\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"JudgingConditionsFormPlugin_3", (String)"ebg-note-formplugin", (Object[])new Object[0]), numbers), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                    evt.setCancel(true);
                    return;
                }
            }
        } else if ("new".equals(operateKey)) {
            this.newDataSetPageCache();
        } else if ("newentry_n".equals(operateKey)) {
            DynamicObjectCollection responses = this.getModel().getEntryEntity("judgings_n_entity");
            if (CollectionUtils.isNotEmpty((Collection)responses)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4ec5\u5141\u8bb8\u5b58\u5728\u4e00\u884c\u8bb0\u5f55\u3002", (String)"JudgingConditionsFormPlugin_4", (String)"ebg-note-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        } else if ("disable".equals(operateKey)) {
            ArrayList<Long> listIds = new ArrayList<Long>();
            listIds.add((Long)this.getModel().getValue("id"));
            JudgingConditionUtil judgingConditionUtil = new JudgingConditionUtil();
            String numbers = judgingConditionUtil.getCodeLessQuoteJudgingConditionsNumbers(listIds);
            if (StringUtils.isNotEmpty((String)numbers)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u94f6\u884c\u7535\u7968\u63a5\u53e3%s\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"JudgingConditionsFormPlugin_5", (String)"ebg-note-formplugin", (Object[])new Object[0]), numbers));
                evt.setCancel(true);
                return;
            }
        } else if ("unaudit".equals(operateKey) && StringUtils.isEmpty((String)saveYes)) {
            ArrayList<Long> listIds = new ArrayList<Long>();
            listIds.add((Long)this.getModel().getValue("id"));
            JudgingConditionUtil judgingConditionUtil = new JudgingConditionUtil();
            String numbers = judgingConditionUtil.getCodeLessQuoteJudgingConditionsNumbers(listIds);
            String callBackId = "judging_conditions_unaudit_id";
            if (StringUtils.isNotEmpty((String)numbers)) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u94f6\u884c\u7535\u7968\u63a5\u53e3%s\u5f15\u7528\uff0c\u4fee\u6539\u540e\u4f1a\u5f71\u54cd\u5230\u5df2\u5f15\u7528\u7684\u5bf9\u8c61\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"JudgingConditionsFormPlugin_6", (String)"ebg-note-formplugin", (Object[])new Object[0]), numbers), MessageBoxOptions.YesNo, ConfirmTypes.Wait, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                evt.setCancel(true);
                return;
            }
        }
    }

    private void newDataSetPageCache() {
        this.getView().getPageCache().put("isFromOldPage", "true");
        String groupID = this.getModel().getDataEntity().getString("group.id");
        this.getView().getPageCache().put("groupID", groupID);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if ("save".equals(key) || "submit".equals(key) || "unaudit".equals(key)) {
            this.getView().getPageCache().put(SAVE_YES_KEY, "");
        }
    }

    private void clearEbgFiled() {
        DynamicObjectCollection judgings_entity = this.getModel().getEntryEntity("judgings_entity");
        for (DynamicObject row : judgings_entity) {
            row.set("ebg_field", (Object)"");
            row.set("in_ebgfield", (Object)"");
            row.set(CONDITION_KEY, null);
        }
        DynamicObjectCollection judgings_n_entity = this.getModel().getEntryEntity("judgings_n_entity");
        for (DynamicObject row : judgings_n_entity) {
            row.set("ebg_field2", (Object)"");
            row.set("in_ebgfield2", (Object)"");
        }
        this.getView().updateView("judgings_n_entity");
        this.getView().updateView("judgings_entity");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.getView().getPageCache().put(SAVE_YES_KEY, "true");
            if ("judging_conditions_save_id".equals(messageBoxClosedEvent.getCallBackId())) {
                this.getView().invokeOperation("save");
            } else if ("judging_conditions_saveAndNew_id".equals(messageBoxClosedEvent.getCallBackId())) {
                this.getView().invokeOperation("saveAndNew");
            } else if ("judging_conditions_unaudit_id".equals(messageBoxClosedEvent.getCallBackId())) {
                this.getView().invokeOperation("unaudit");
            } else {
                this.getView().invokeOperation("submit");
            }
        } else {
            this.getView().getPageCache().put(SAVE_YES_KEY, "");
        }
    }

    public String getBankVersionID() {
        return this.getModel().getDataEntity().getString("group.longnumber").split("\\.")[0];
    }

    public String getBizType() {
        String bizType = this.getModel().getDataEntity().getString("biz_type_new.number");
        return bizType;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (JUDGE_TYPE.equals(fieldKey)) {
            this.changeCodeField();
        } else if (StringUtils.equals((String)"biz_type_new", (String)fieldKey)) {
            this.changeRspEbgParam(this.getBizType());
            this.clearEbgFiled();
        }
    }

    public void changeCodeField() {
        ComboEdit comboEdit = (ComboEdit)this.getControl("ebgparam_source");
        ComboEdit comboEdit2 = (ComboEdit)this.getControl("ebgparam_source2");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
        ArrayList<ComboItem> data2 = new ArrayList<ComboItem>(16);
        if (this.isParse()) {
            data.add(new ComboItem(new LocaleString(SourceValueEnum.origin.getName()), SourceValueEnum.origin.getKey()));
            data.add(new ComboItem(new LocaleString(SourceValueEnum.ebg_field.getName()), SourceValueEnum.ebg_field.getKey()));
            data.add(new ComboItem(new LocaleString(SourceValueEnum.abs.getName()), SourceValueEnum.abs.getKey()));
            data.add(new ComboItem(new LocaleString(SourceValueEnum.fix.getName()), SourceValueEnum.fix.getKey()));
            data.add(new ComboItem(new LocaleString(SourceValueEnum.pass.getName()), SourceValueEnum.pass.getKey()));
            data2.addAll(data);
            data2.add(new ComboItem(new LocaleString(SourceValueEnum.error.getName()), SourceValueEnum.error.getKey()));
            comboEdit2.setComboItems(data2);
            comboEdit.setComboItems(data);
        } else {
            data.add(new ComboItem(new LocaleString(SourceValueEnum.ebg_field.getName()), SourceValueEnum.ebg_field.getKey()));
            data.add(new ComboItem(new LocaleString(SourceValueEnum.fix.getName()), SourceValueEnum.fix.getKey()));
            data2.addAll(data);
            data2.add(new ComboItem(new LocaleString(SourceValueEnum.error.getName()), SourceValueEnum.error.getKey()));
            comboEdit2.setComboItems(data2);
            comboEdit.setComboItems(data);
        }
    }

    private boolean isParse() {
        String type = this.getConditionsType();
        return "parse".equals(type);
    }

    private String getConditionsType() {
        return (String)this.getModel().getValue(JUDGE_TYPE);
    }

    public void afterLoadData(EventObject e) {
        this.changeRspEbgParam(this.getBizType());
    }

    public void changeRspEbgParam(String bizType) {
        List<EbgParam> params = EBGParamUtils.getNoteRspMetaParamByBizType(bizType);
        ComboEdit comboEdit = (ComboEdit)this.getControl("in_ebgfield");
        ComboEdit comboEdit2 = (ComboEdit)this.getControl("in_ebgfield2");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
        if (params != null && params.size() > 0) {
            for (EbgParam param : params) {
                data.add(new ComboItem(new LocaleString(param.getName()), param.getKey()));
            }
        }
        comboEdit.setComboItems(data);
        comboEdit2.setComboItems(data);
    }
}

