/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.formplugin.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.utils.DataUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DataToXmlFormatUtils {
    public static final char GT = '>';
    public static final String CRLF = "\r\n";
    public static final String LT2 = "</";
    public static final char LT = '<';
    public static final String XML_ROOT = "root";
    public static final List<Character> XML_CHARS = Arrays.asList(Character.valueOf('&'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\"'), Character.valueOf('\''));

    public static String objectToXml(Object obj, String xmlType) {
        return DataToXmlFormatUtils.objectToXml(obj, true, false, true, "", 0, xmlType);
    }

    public static String objectToXml(Object obj, boolean isFormat, boolean showComment, boolean isIncludeRoot, String xmlRootName, int indent, String xmlType) {
        StringBuffer xml = new StringBuffer();
        if (isIncludeRoot) {
            DataToXmlFormatUtils.getXmlPrefix(xml, isFormat, xmlRootName);
        }
        if (!isFormat) {
            showComment = false;
        }
        Stack<Boolean> stack = new Stack<Boolean>();
        DataToXmlFormatUtils.objToXml(xml, obj, stack, isFormat, showComment, indent, xmlType);
        if (isIncludeRoot) {
            DataToXmlFormatUtils.appendXmlSuffix(xml, isFormat, xmlRootName);
        }
        return xml.toString();
    }

    private static void getXmlPrefix(StringBuffer xml, boolean isFormat, String xmlRootName) {
        if (StringUtils.isEmpty((String)xmlRootName)) {
            xmlRootName = XML_ROOT;
        }
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    private static void appendXmlSuffix(StringBuffer xml, boolean isFormat, String xmlRootName) {
    }

    private static void objToXml(StringBuffer xml, Object obj, Stack<Boolean> stack, boolean isFormat, boolean showComment, int indent, String xmlType) {
        if (obj != null) {
            if (DataUtil.isBaseType((Object)obj)) {
                DataToXmlFormatUtils.getIndent(xml, stack, isFormat, indent);
                xml.append(obj.toString());
            } else {
                Object json = JSON.toJSON((Object)obj);
                if (json instanceof Map) {
                    JSONObject jsonObject = (JSONObject)json;
                    DataToXmlFormatUtils.jsonToXml(jsonObject, xml, stack, isFormat, showComment, indent, xmlType);
                } else {
                    if (!(json instanceof List)) {
                        throw new OpenApiException(ApiErrorCode.Data_Invalid, "xml exception\uff1a" + json.getClass().getName(), new Object[0]);
                    }
                    List jsonArray = (List)json;
                    for (Object o : jsonArray) {
                        DataToXmlFormatUtils.objToXml(xml, o, stack, isFormat, showComment, indent, xmlType);
                    }
                }
            }
        }
    }

    private static StringBuffer jsonToXml(JSONObject jsonObject, StringBuffer xml, Stack<Boolean> stack, boolean isFormat, boolean showComment, int indent, String xmlType) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                DataToXmlFormatUtils.getLeft(xml, stack, true, isFormat, indent).append(key).append('>').append(DataToXmlFormatUtils.xmlNote(Object.class, showComment));
                DataToXmlFormatUtils.jsonToXml((JSONObject)value, xml, stack, isFormat, showComment, indent, xmlType);
                DataToXmlFormatUtils.getLeft2(xml, stack, isFormat, indent).append(key).append('>');
                continue;
            }
            if (value instanceof List) {
                JSONArray jArray = (JSONArray)value;
                for (Object o : jArray) {
                    DataToXmlFormatUtils.getLeft(xml, stack, true, isFormat, indent).append(key);
                    if (o instanceof Map) {
                        xml.append('>').append(DataToXmlFormatUtils.xmlNote(List.class, showComment));
                        DataToXmlFormatUtils.jsonToXml((JSONObject)o, xml, stack, isFormat, showComment, indent, xmlType);
                        DataToXmlFormatUtils.getLeft2(xml, stack, isFormat, indent).append(key).append('>');
                        continue;
                    }
                    if (o instanceof List) {
                        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u652f\u6301\u591a\u7ef4\u6570\u7ec4\u3002", (String)"DataToXmlFormatUtils_0", (String)"ebg-note-formplugin", (Object[])new Object[0]), key));
                    }
                    xml.append('>');
                    stack.pop();
                    xml.append(o).append(LT2).append(key).append('>').append(DataToXmlFormatUtils.xmlNote(Array.class, showComment));
                }
                continue;
            }
            if (value instanceof Long) {
                String parentNodeName;
                int i;
                String selectFields = "rspbody_entryentity.rsp_paramname";
                QFilter filter = QFilter.of((String)"rspbody_entryentity.id = ?", (Object[])new Object[]{value});
                DynamicObject fatherNode = QueryServiceHelper.queryOne((String)"ebg_code_less", (String)selectFields, (QFilter[])filter.toArray());
                if (fatherNode == null || (i = xml.lastIndexOf(parentNodeName = fatherNode.getString(selectFields))) < 0) continue;
                StringBuilder temp = new StringBuilder().append(" ").append(key).append("=\"\"");
                xml.insert(i + parentNodeName.length(), temp);
                continue;
            }
            String strValue = String.valueOf(value);
            if (strValue != null && "cdata_xml".equals(xmlType)) {
                strValue = "<![CDATA[" + strValue + "]]>";
            }
            DataToXmlFormatUtils.getLeft(xml, stack, false, isFormat, indent).append(key).append('>').append(strValue);
            DataToXmlFormatUtils.getLeft2(xml, stack, isFormat, indent).append(key).append('>').append(DataToXmlFormatUtils.xmlNote(value == null ? Object.class : value.getClass(), showComment));
        }
        return xml;
    }

    private static String xmlNote(Class<?> typeClass, boolean showComment) {
        return !showComment ? "" : "\t<!-- " + typeClass.getSimpleName() + " -->";
    }

    private static StringBuffer getLeft(StringBuffer xml, Stack<Boolean> stack, boolean isWrap, boolean isFormat, int indent) {
        DataToXmlFormatUtils.getIndent(xml, stack, isFormat, indent);
        xml.append('<');
        stack.push(isWrap);
        return xml;
    }

    private static StringBuffer getIndent(StringBuffer xml, Stack<Boolean> stack, boolean isFormat, int indent) {
        if (isFormat) {
            xml.append(CRLF);
            for (int i = 0; i < stack.size() + indent; ++i) {
                xml.append('\t');
            }
        }
        return xml;
    }

    private static StringBuffer getLeft2(StringBuffer xml, Stack<Boolean> stack, boolean isFormat, int indent) {
        if (stack.pop().booleanValue() && isFormat) {
            xml.append(CRLF);
            for (int i = 0; i < stack.size() + indent; ++i) {
                xml.append('\t');
            }
        }
        xml.append(LT2);
        return xml;
    }
}

