/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.cache;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;

public class CosmicCache {
    public static DistributeSessionlessCache cosmicCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");

    public static String getParentKey(String key) {
        StringBuilder sb = new StringBuilder();
        sb.append(CacheKeyUtil.getAcctId());
        sb.append('.');
        sb.append(key);
        return sb.toString();
    }

    public static Map<String, String> getAll(String key) {
        return cosmicCache.getAll(CosmicCache.getParentKey(key));
    }

    public static void put(String key, String value) {
        key = CosmicCache.getParentKey(key);
        cosmicCache.put(key, (Object)value);
    }

    public static String putIfAbsent(String key, String value) {
        if (cosmicCache.contains(key = CosmicCache.getParentKey(key))) {
            return (String)cosmicCache.get(key);
        }
        cosmicCache.put(key, (Object)value);
        return null;
    }

    public static String putIfAbsentWithExpire(String key, String value, int num, TimeUnit timeUnit) {
        if (cosmicCache.contains(key = CosmicCache.getParentKey(key))) {
            return (String)cosmicCache.get(key);
        }
        cosmicCache.put(key, (Object)value, num, timeUnit);
        return null;
    }

    public static String putWithExpire(String key, String value, int num, TimeUnit timeUnit) {
        key = CosmicCache.getParentKey(key);
        cosmicCache.put(key, (Object)value, num, timeUnit);
        return value;
    }

    public static void addList(String key, String[] object) {
        cosmicCache.addList(CosmicCache.getParentKey(key), object);
    }

    public static String[] getList(String key) {
        return cosmicCache.getList(CosmicCache.getParentKey(key));
    }

    public static boolean contains(String key) {
        return cosmicCache.contains(CosmicCache.getParentKey(key));
    }

    public static String get(String key) {
        return (String)cosmicCache.get(CosmicCache.getParentKey(key));
    }

    public static void delete(String key) {
        if (cosmicCache.contains(key = CosmicCache.getParentKey(key))) {
            cosmicCache.remove(key);
        }
    }
}

