/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;

public class ObjectToMapUtilT<T> {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(ObjectToMapUtilT.class);
    private static ObjectToMapUtilT instance = new ObjectToMapUtilT();

    public static ObjectToMapUtilT getInstance() {
        return instance;
    }

    public List<Map<String, String>> getMapListCommon(List<T> objects, String dateFormater) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(objects.size());
        Map<String, String> mapDate = ObjectToMapUtilT.getDateMap(dateFormater);
        for (T object : objects) {
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.putAll(mapDate);
            Field[] fields = object.getClass().getDeclaredFields();
            Map<String, String> result = ObjectToMapUtilT.getCommonMap(fields, dateFormater, object);
            map.putAll(result);
            list.add(map);
        }
        return list;
    }

    private static Map<String, String> getCommonMap(Field[] fields, String dateFormater, Object object) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        try {
            for (Field field : fields) {
                String timestr;
                ReflectionUtils.makeAccessible((Field)field);
                if (field.get(object) == null) continue;
                Object target = field.get(object);
                if (target instanceof String) {
                    map.put(field.getName(), (String)target);
                    continue;
                }
                if (target instanceof BigDecimal) {
                    map.put(field.getName(), ((BigDecimal)target).toPlainString());
                    continue;
                }
                if (target instanceof LocalDate) {
                    timestr = ((LocalDate)target).format(DateTimeFormatter.ofPattern(dateFormater));
                    map.put(field.getName(), timestr);
                    continue;
                }
                if (target instanceof LocalDateTime) {
                    timestr = ((LocalDateTime)target).format(DateTimeFormatter.ofPattern(dateFormater));
                    map.put(field.getName(), timestr);
                    continue;
                }
                if (!(target instanceof Integer)) continue;
                timestr = ((Integer)target).toString();
                map.put(field.getName(), timestr);
            }
        }
        catch (IllegalAccessException e) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u8f6c\u6362Map\u5f02\u5e38\uff1a{}", (String)"ObjectToMapUtil_0", (String)"ebg-note-business", (Object[])new Object[0]), e);
        }
        return map;
    }

    private static Map<String, String> getDateMap(String dateFormater) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        String date = DateTimeUtils.format(new Date(), "yyyyMMdd");
        String dateNow = DateTimeUtils.format(new Date(), dateFormater);
        map.put("date8", date);
        map.put("dateNow", dateNow);
        return map;
    }
}

