/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.exception;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBConnection;
import kd.ebg.egf.common.exception.EBDbSaveException;
import kd.ebg.egf.common.exception.EBDuplicateException;
import kd.ebg.egf.common.exception.EBLoginAccessException;
import kd.ebg.egf.common.exception.EBPayFailException;
import kd.ebg.egf.common.exception.EBPayUnknownException;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.exception.EBRePayException;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.lang.MultiLang;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class EBExceiptionUtil {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(EBExceiptionUtil.class);

    public static EBServiceException serviceException(String message) {
        return new EBServiceException(message);
    }

    public static EBServiceException serviceException(String message, String errorCode) {
        EBServiceException ebServiceException = new EBServiceException(message);
        ebServiceException.setErrorCode(errorCode);
        return ebServiceException;
    }

    public static EBServiceException serviceException(Throwable t) {
        String errorMsg = MultiLang.getExceptionTip(t.getMessage());
        if (StringUtils.isNotEmpty(t.getMessage())) {
            logger.error(errorMsg, t);
        }
        return new EBServiceException(errorMsg, t);
    }

    public static EBServiceException serviceException(String message, Throwable t) {
        logger.error(message, t);
        return new EBServiceException(message, t);
    }

    public static EBServiceException serviceException(String message, String errorCode, Throwable t) {
        logger.error(message, t);
        EBServiceException ebServiceException = new EBServiceException(message, t);
        if (StringUtils.isNotEmpty(errorCode)) {
            ebServiceException.setErrorCode(errorCode);
        }
        return ebServiceException;
    }

    public static EBPreCheckException preCheckException(String message) {
        return new EBPreCheckException(message);
    }

    public static EBPreCheckException preCheckException(String errorCode, String message) {
        return new EBPreCheckException(errorCode, message);
    }

    public static EBPreCheckException preCheckException(Throwable t) {
        logger.error("", t);
        return new EBPreCheckException("", t);
    }

    public static EBPreCheckException preCheckException(String message, Throwable t) {
        logger.error(message, t);
        return new EBPreCheckException(message, t);
    }

    public static EBPreCheckException preCheckException(String errorCode, String message, Throwable t) {
        logger.error(message, t);
        return new EBPreCheckException(errorCode, message, t);
    }

    public static EBConnection connectionException(String message) {
        return new EBConnection(message);
    }

    public static EBConnection connectionException(Throwable t) {
        logger.error("", t);
        return new EBConnection("", t);
    }

    public static EBConnection connectionException(String message, Throwable t) {
        logger.error(message, t);
        return new EBConnection(message, t);
    }

    public static EBLoginAccessException loginAccessException(String message, Throwable t) {
        logger.error(message, t);
        return new EBLoginAccessException(message, t);
    }

    public static EBDuplicateException duplicateException(String message) {
        return new EBDuplicateException(message);
    }

    public static EBDuplicateException duplicateException(String message, Throwable t) {
        logger.error(message, t);
        return new EBDuplicateException(message, t);
    }

    public static EBDbSaveException dbSaveException(String message) {
        return new EBDbSaveException(message);
    }

    public static EBDbSaveException dbSaveException(String message, Throwable t) {
        logger.error(message, t);
        return new EBDbSaveException(message, t);
    }

    public static EBRePayException rePayException(String message) {
        return new EBRePayException(message);
    }

    public static EBPayFailException payFailException(String message, Throwable t) {
        logger.error(message, t);
        return new EBPayFailException(message, t);
    }

    public static EBPayFailException payFailException(String message) {
        return new EBPayFailException(message);
    }

    public static EBPayUnknownException payUnknownException(String message, Throwable t) {
        logger.error(message, t);
        return new EBPayUnknownException(message, t);
    }

    public static EBPayUnknownException payUnknownException(String message) {
        return new EBPayUnknownException(message);
    }

    public static String[] stackTrace(StackTraceElement[] stackTraceElements) {
        int length = stackTraceElements.length > 15 ? 15 : stackTraceElements.length;
        String[] stackTrace = new String[length];
        for (int i = 0; i < length; ++i) {
            stackTrace[i] = stackTraceElements[i].toString();
        }
        return stackTrace;
    }

    public static String stackTraceString(StackTraceElement[] stackTraceElements) {
        int length = stackTraceElements.length > 15 ? 15 : stackTraceElements.length;
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u9519\u8bef\u5f02\u5e38\u5806\u6808\uff1a", (String)"EBExceiptionUtil_0", (String)"ebg-egf-common", (Object[])new Object[0])).append('\n');
        for (int i = 0; i < length; ++i) {
            sb.append(stackTraceElements[i].toString()).append("\n");
        }
        return sb.toString();
    }
}

