/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import kd.ebg.egf.common.log.BizLogType;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;

public class WriteFileUtil {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(WriteFileUtil.class);

    public static void writeLog(String fileName, String content) {
        try {
            File currentDir = FileCommonUtils.getFileByPath(System.getProperty("user.dir"));
            String logDirPath = currentDir.getParentFile().getAbsolutePath() + File.separator + "logs" + File.separator + "ebg";
            File logDir = FileCommonUtils.getFileByPath(logDirPath);
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            File file = FileCommonUtils.getFileByPath(logDir.getPath(), fileName);
            WriteFileUtil.write(file, content);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void write(File file, String content) throws IOException {
        if (!file.exists()) {
            if (file.createNewFile()) {
                logger.info("create new file success");
            } else {
                logger.info("create new file fail");
                return;
            }
        }
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true)));){
            out.write(content);
            out.write("\r\n");
        }
    }

    public static void clearAppStarterLog(BizLogType logType) {
        File file;
        File currentDir = FileCommonUtils.getFileByPath(System.getProperty("user.dir"));
        String logDirPath = currentDir.getParentFile().getAbsolutePath() + File.separator + "logs" + File.separator + "ebg";
        File logDir = FileCommonUtils.getFileByPath(logDirPath);
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        if ((file = FileCommonUtils.getFileByPath(logDir.getPath(), logType.getName())).exists() && file.delete()) {
            logger.info("delete new file success");
        }
    }
}

