/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication;

import java.io.IOException;
import java.io.InputStream;
import kd.ebg.egf.common.framework.communication.FilterConnection;

public class FilterInputStream
extends InputStream {
    private InputStream inputStream;
    private FilterConnection connection;

    public FilterInputStream(InputStream inputStream, FilterConnection connection) {
        this.inputStream = inputStream;
        this.connection = connection;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.connection.beforeRead(this.inputStream);
        int n = this.inputStream.read(b, off, len);
        byte[] bytes = null;
        if (n <= 0) {
            bytes = new byte[]{};
        } else {
            bytes = new byte[n];
            System.arraycopy(b, 0, bytes, 0, n);
        }
        this.connection.afterRead(this.inputStream, bytes);
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.connection.beforeRead(this.inputStream);
        int n = this.inputStream.read(b);
        byte[] bytes = null;
        if (n <= 0) {
            bytes = new byte[]{};
        } else {
            bytes = new byte[n];
            System.arraycopy(b, 0, bytes, 0, n);
        }
        this.connection.afterRead(this.inputStream, bytes);
        return n;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }
}

