/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.atomic;

import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import kd.ebg.egf.common.exception.EBSecurityException;
import kd.ebg.egf.common.framework.security.atomic.AbstractEBSecurityBase;
import kd.ebg.egf.common.framework.security.atomic.IEncrypt;
import org.bouncycastle.util.encoders.Base64;

public abstract class AbstractEBAsynEncrypt
extends AbstractEBSecurityBase
implements IEncrypt {
    protected Cipher encryptCipher;
    protected Cipher decryptCipher;
    private byte[] publicKey;
    private int mode;

    public AbstractEBAsynEncrypt(byte[] privateKey, byte[] publicKey, int mode) {
        super(privateKey);
        this.publicKey = publicKey;
        this.mode = mode;
        this.init();
    }

    @Override
    public void init() {
        super.init();
        try {
            if (1 == this.mode) {
                this.encryptCipher = Cipher.getInstance(this.getAlgorithm());
                this.encryptCipher.init(1, this.getPublicKey());
            } else if (2 == this.mode) {
                this.decryptCipher = Cipher.getInstance(this.getAlgorithm());
                this.decryptCipher.init(2, this.getPrivateKey());
            } else {
                this.encryptCipher = Cipher.getInstance(this.getAlgorithm());
                this.encryptCipher.init(1, this.getPublicKey());
                this.decryptCipher = Cipher.getInstance(this.getAlgorithm());
                this.decryptCipher.init(2, this.getPrivateKey());
            }
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
    }

    public Key getPublicKey() {
        X509EncodedKeySpec pkcs8KeySpec = new X509EncodedKeySpec(this.publicKey);
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.getKeyAlgorithm());
            publicKey = keyFactory.generatePublic(pkcs8KeySpec);
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
        return publicKey;
    }

    public Key getPrivateKey() {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(this.getKeyBytes());
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.getKeyAlgorithm());
            privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
        return privateKey;
    }

    @Override
    public String encrypt(byte[] source) {
        String encryptStr = null;
        byte[] result = new byte[]{};
        try {
            result = this.encryptCipher.doFinal(source);
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
        encryptStr = Base64.toBase64String((byte[])result);
        return encryptStr;
    }

    @Override
    public byte[] decrypt(String source) {
        byte[] decryptData = null;
        byte[] plain = Base64.decode((String)source);
        try {
            decryptData = this.decryptCipher.doFinal(plain);
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
        return decryptData;
    }
}

