/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.service.currency;

import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.currency.BankCurrency;
import kd.ebg.egf.common.model.currency.BankCurrencyKey;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.repository.currency.BankCurrencyRepository;

public class BankCurrencyService {
    private BankCurrencyRepository bankCurrencyRepository = BankCurrencyRepository.getInstance();
    private static BankCurrencyService instance = new BankCurrencyService();

    public static BankCurrencyService getInstance() {
        return instance;
    }

    public String getBankCurrency(String bankVersionID, String isoCode, String customID) {
        BankCurrencyKey key = new BankCurrencyKey();
        key.setBankVersionId(bankVersionID);
        key.setIsoCode(isoCode);
        key.setCustomID(customID);
        BankCurrency bankCurrency = this.bankCurrencyRepository.findOne(key);
        if (Objects.nonNull(bankCurrency)) {
            return bankCurrency.getBankCurrency();
        }
        String defaultCustomId = "admin";
        key.setCustomID(defaultCustomId);
        bankCurrency = this.bankCurrencyRepository.findOne(key);
        if (Objects.nonNull(bankCurrency)) {
            return bankCurrency.getBankCurrency();
        }
        String bankName = BankVersionRepository.getInstance().getBankLocaleName(bankVersionID);
        throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u7248\u672c\uff1a%1$s\uff0c\u5e01\u79cd%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u5185\u7ef4\u62a4\u5e01\u79cd\u4fe1\u606f\u3002", (String)"BankCurrencyService_3", (String)"ebg-egf-common", (Object[])new Object[0]), bankName, isoCode));
    }

    public String getIsoCurrency(String bankVersionID, String bankCurrency, String customID) {
        BankCurrency currency = this.bankCurrencyRepository.findByBankVersionIDAndBankCurrency(bankVersionID, bankCurrency, customID);
        if (Objects.nonNull(currency)) {
            return currency.getKey().getIsoCode();
        }
        return "";
    }
}

