/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.ebg.egf.common.framework.service.license.LicenseDetailService;
import kd.ebg.egf.common.license.LicenseTask;
import kd.ebg.egf.common.license.NoteLicenseTask;
import kd.ebg.egf.common.license.TenantInfo;
import kd.ebg.egf.common.model.license.LicenseDetail;

public class LicenseCache {
    public static TenantInfo getTenant() {
        return LicenseCache.createTenant();
    }

    public static TenantInfo getTenantForNote() {
        return LicenseCache.createTenantForNote();
    }

    private static TenantInfo createTenantForNote() {
        RequestContext current = RequestContext.get();
        List<LicenseDetail> lists = LicenseCache.loadNoteBankLoginInfo(current);
        TenantInfo tenant = new TenantInfo(NoteLicenseTask.getTask());
        lists.forEach(s -> {
            int used = tenant.deductLicense();
            tenant.setUsedLicenseCount(used);
        });
        tenant.setInfos(lists);
        return tenant;
    }

    private static TenantInfo createTenant() {
        RequestContext current = RequestContext.get();
        List<LicenseDetail> lists = LicenseCache.loadBankLoginInfoExcludeNote(current);
        TenantInfo tenant = new TenantInfo(LicenseTask.getTask());
        lists.forEach(s -> {
            int used = tenant.deductLicense();
            tenant.setUsedLicenseCount(used);
        });
        tenant.setInfos(lists);
        return tenant;
    }

    private static List<LicenseDetail> loadNoteBankLoginInfo(RequestContext current) {
        String tenantId = current.getTenantId();
        LicenseDetailService licenseDetailService = LicenseDetailService.getInstance();
        List<LicenseDetail> lists = licenseDetailService.findNoteLicenseDetailByCustomId(tenantId);
        return lists;
    }

    private static List<LicenseDetail> loadBankLoginInfoExcludeNote(RequestContext current) {
        String tenantId = current.getTenantId();
        LicenseDetailService licenseDetailService = LicenseDetailService.getInstance();
        List<LicenseDetail> lists = licenseDetailService.findLicenseDetailByCustomIdExcludeNote(tenantId);
        return lists;
    }
}

