/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.license.LicenseTask;
import kd.ebg.egf.common.license.NoteLicenseTask;
import kd.ebg.egf.common.model.license.LicenseDetail;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TenantInfo {
    private String id;
    private String groupNumber;
    private String groupName;
    private String calcType;
    private String fileType;
    private String region;
    private String expiredDate;
    private String licenseVersion;
    private int totalLicenseCount;
    private int usedLicenseCount;
    private int unusedLicenseCount;
    private LocalDateTime deadline;
    private List<LicenseDetail> infos;

    public TenantInfo() {
        this.groupNumber = "PRO_EBG";
        this.groupName = ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u5206\u7ec4", (String)"TenantInfo_0", (String)"ebg-egf-common", (Object[])new Object[0]);
        this.calcType = ResManager.loadKDString((String)"\u7279\u6027", (String)"TenantInfo_1", (String)"ebg-egf-common", (Object[])new Object[0]);
        this.region = ResManager.loadKDString((String)"\u94f6\u4f01\u4e91", (String)"TenantInfo_2", (String)"ebg-egf-common", (Object[])new Object[0]);
    }

    public TenantInfo(LicenseTask task) {
        this.id = task.getTenantId();
        this.groupNumber = "PRO_EBG";
        this.groupName = ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u5206\u7ec4", (String)"TenantInfo_0", (String)"ebg-egf-common", (Object[])new Object[0]);
        this.calcType = ResManager.loadKDString((String)"\u7279\u6027", (String)"TenantInfo_1", (String)"ebg-egf-common", (Object[])new Object[0]);
        this.expiredDate = task.getExpiredDate();
        String expiredDate = task.getExpiredDate();
        if (StringUtils.equals(PropertiesConstants.getValue("UNLIMITED"), expiredDate)) {
            expiredDate = "2099-12-31 23:59:59";
        }
        this.deadline = LocalDateTime.parse(expiredDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.fileType = task.getFileType();
        this.region = ResManager.loadKDString((String)"\u94f6\u4f01\u4e91", (String)"TenantInfo_2", (String)"ebg-egf-common", (Object[])new Object[0]);
        this.licenseVersion = task.getVersion();
        this.totalLicenseCount = this.unusedLicenseCount = task.getLicenseCount();
        this.usedLicenseCount = 0;
    }

    public TenantInfo(NoteLicenseTask task) {
        this.id = task.getTenantId();
        this.groupNumber = "PRO_EBG";
        this.groupName = ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u5206\u7ec4", (String)"TenantInfo_0", (String)"ebg-egf-common", (Object[])new Object[0]);
        this.calcType = ResManager.loadKDString((String)"\u7279\u6027", (String)"TenantInfo_1", (String)"ebg-egf-common", (Object[])new Object[0]);
        this.expiredDate = task.getExpiredDate();
        String expiredDate = task.getExpiredDate();
        if (StringUtils.equals(PropertiesConstants.getValue("UNLIMITED"), expiredDate)) {
            expiredDate = "2099-12-31 23:59:59";
        }
        this.deadline = LocalDateTime.parse(expiredDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.fileType = task.getFileType();
        this.region = ResManager.loadKDString((String)"\u94f6\u4f01\u4e91", (String)"TenantInfo_2", (String)"ebg-egf-common", (Object[])new Object[0]);
        this.licenseVersion = task.getVersion();
        this.totalLicenseCount = this.unusedLicenseCount = task.getLicenseCount();
        this.usedLicenseCount = 0;
    }

    public int deductLicense() {
        --this.unusedLicenseCount;
        return ++this.usedLicenseCount;
    }

    public String getId() {
        return this.id;
    }

    public String getGroupNumber() {
        return this.groupNumber;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getCalcType() {
        return this.calcType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getRegion() {
        return this.region;
    }

    public String getExpiredDate() {
        return this.expiredDate;
    }

    public String getLicenseVersion() {
        return this.licenseVersion;
    }

    public void setExpiredDate(String expiredDate) {
        if (StringUtils.equals(PropertiesConstants.getValue("UNLIMITED"), expiredDate)) {
            expiredDate = "2099-12-31 23:59:59";
        }
        this.expiredDate = expiredDate;
        this.deadline = LocalDateTime.parse(expiredDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public void setTotalLicenseCount(int totalLicenseCount) {
        this.totalLicenseCount = totalLicenseCount;
    }

    public int getTotalLicenseCount() {
        return this.totalLicenseCount;
    }

    public void setUsedLicenseCount(int usedLicenseCount) {
        this.usedLicenseCount = usedLicenseCount;
    }

    public void setUnusedLicenseCount(int unusedLicenseCount) {
        this.unusedLicenseCount = unusedLicenseCount;
    }

    public int getUsedLicenseCount() {
        return this.usedLicenseCount;
    }

    public int getUnusedLicenseCount() {
        return this.unusedLicenseCount;
    }

    public LocalDateTime getDeadline() {
        return this.deadline;
    }

    public List<LicenseDetail> getInfos() {
        return this.infos;
    }

    public void setInfos(List<LicenseDetail> infos) {
        this.infos = infos;
    }

    public void setGroupNumber(String groupNumber) {
        this.groupNumber = groupNumber;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setCalcType(String calcType) {
        this.calcType = calcType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setLicenseVersion(String licenseVersion) {
        this.licenseVersion = licenseVersion;
    }
}

