/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license.old;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.ebg.egf.common.license.old.Coder;
import kd.ebg.egf.common.license.old.ControlPolicy;
import kd.ebg.egf.common.license.old.IniFile;
import kd.ebg.egf.common.license.old.InvalidFormatException;
import kd.ebg.egf.common.license.old.License;
import kd.ebg.egf.common.license.old.LicenseFileConfig;
import kd.ebg.egf.common.license.old.LicenseFileConfigInfo;
import kd.ebg.egf.common.license.old.LicenseFileErrorException;
import kd.ebg.egf.common.license.old.LicenseKey;
import kd.ebg.egf.common.license.old.LicenseUtil;
import kd.ebg.egf.common.license.old.ModuleLicenseInfo;
import kd.ebg.egf.common.license.old.ModuleMapInfo;
import kd.ebg.egf.common.license.old.Utils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;

public class LicenseImpl
extends License {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(LicenseImpl.class);
    private static final String LABEL_LICENSE_SERVICE_DATE = "ServiceDate";
    private static final String LABEL_LICENSE_TO = "LicenseTo";
    private static final String LABEL_LICENSE_CHECKSUMPACKDATE = "ChecksumPackDate";
    private static final String LABEL_KEY = "LiberationKey";
    private static final String LABEL_CELLS = "Cells";
    private static final String LABEL_LASTDATE = "LastRunDate";
    private static final String LABEL_INITDATE = "InitialDate";
    private static final String LABEL_EXPIREDATE = "ExpireDate";
    private static final String LABEL_COUNTER = "Counter";
    private static final String LABEL_CHECKSUM = "Checksum";
    private static final String LABEL_CHECKSUMPACK = "ChecksumPack";
    private static final String LABEL_LICENSE_TYPE = "LicenseType";
    private static final String LABEL_LICENSE_VERSION = "LicenceVersion";
    private static final String LABEL_LICENSE_USER = "UserInfo";
    private static final String LABEL_LICENSE_CREATE_TIME = "LicenseCreateDate";
    private static final String LABEL_LICENSE_USERNAME = "UserName";
    private static final String LABEL_LICENSE_UUID = "LicenseID";
    private static final String LABEL_PACKAGE_MODULAR_TYPE = "PackageModuleType";
    private static final String LABEL_UNLIMITED_PACKAGE_TYPE = "UnPackageType";
    private static final String LABEL_LICENSE_IS_TRIAL = "Trial";
    private static final String LABEL_LICENSE_IS_OLD = "OldFormat";
    private static final String LABEL_SUBSYSTEM_MODULER_TYPE = "SubSystemType";
    private static final String LABEL_LICENSE_PRODUCT_VERSION = "ProductVersion";
    private static final String LABEL_LICENSE_PRODUCT_NAME = "ProductName";
    private static final String LABEL_LICENSE_CONTROL_POLICY = "ControlPolicy";
    private static final String LABEL_LICENSE_INDUSTRY = "Industry";
    private static final String LABEL_TEMP_LICENSE = "TempLicense";
    private static final String TEACH_EDITION = "TEACH";
    private Map<String, String> app;
    private static final String LABEL_LICENSE_SOFTWARECODE = "SoftwareCode";
    private static final String LABEL_LICENSE_PRODUCTCODE = "ProductCode";
    private static final String LABEL_LICENSE_PRODUCT_INSTANCEID = "ProductInstanceID";
    private static final String LABEL_LICENSE_REGUSERSSIGN = "RegUsersSign";
    private static final String LABEL_LICENSE_REGUSERS = "RegUsers";
    private boolean isValidate = false;
    private LicenseFileConfigInfo fileCfgInfo = null;

    public LicenseImpl(InputStream inputStream) throws LicenseFileErrorException {
        this.inputStream = inputStream;
        this.moduleDetails = new ArrayList();
        this.modulePackageMap = new ArrayList();
        this.validModuleLicenses = new ArrayList();
        this.subSystemModuleMap = new HashMap();
        this.validateStatus = 0;
        this.parseLicenseFile();
    }

    private void checkServiceDate(String pStr) throws LicenseFileErrorException {
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_SERVICE_DATE);
        }
        String date = LicenseUtil.decrypt(LABEL_LICENSE_SERVICE_DATE, pStr, this.isValidate);
        try {
            this.serviceDate = Utils.parseDate(date);
        }
        catch (ParseException e) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_SERVICE_DATE, e);
        }
    }

    private void checkLicenseTo(String pStr) throws LicenseFileErrorException {
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_TO);
        }
        String str = LicenseUtil.decrypt(LABEL_LICENSE_TO, pStr, this.isValidate);
        this.licenseTo = LicenseImpl.removeSpecilChar(str);
    }

    private void checkSumPackDate(String str, String pStr) throws LicenseFileErrorException {
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_CHECKSUMPACKDATE);
        }
        if (!(pStr = LicenseUtil.decrypt(LABEL_LICENSE_CHECKSUMPACKDATE, pStr, this.isValidate, false)).equals(str)) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_CHECKSUMPACKDATE);
        }
    }

    private void checkSoftWareCode(String pStr) throws LicenseFileErrorException {
        if (pStr == null) {
            return;
        }
        String value = "";
        try {
            value = LicenseUtil.decrypt(LABEL_LICENSE_SOFTWARECODE, pStr, this.isValidate);
        }
        catch (Exception ex) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_SOFTWARECODE, ex);
        }
        this.src_SoftwareCode = value;
    }

    private void checkLibKey(String pStr) throws LicenseFileErrorException {
        logger.info("softwareCode===" + this.softwareCode + "===softwareName===" + this.softwareName + "===cipher==" + this.cipher + "===pStr===" + pStr);
        if (pStr == null) {
            return;
        }
        this.libKey = pStr;
        try {
            String libKey = LicenseUtil.hash(this.softwareCode + this.softwareName + this.cipher);
            logger.info("checkLibKey ==libKey===" + libKey);
            libKey = libKey.substring(0, 16);
            String value = LicenseUtil.decrypt(LABEL_KEY, pStr, this.isValidate);
            logger.info("checkLibKey ==value===" + value);
            if (libKey.equals(value)) {
                this.registed = true;
            }
        }
        catch (Exception ex) {
            throw new LicenseFileErrorException(1000, LABEL_KEY, ex);
        }
    }

    private void checkCells(String pStr) throws LicenseFileErrorException {
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_CELLS);
        }
        this.cellString = pStr;
        String str = LicenseUtil.decrypt(LABEL_CELLS, pStr, this.isValidate);
        byte[] bytes = str.getBytes();
        this.cells = new int[bytes.length / 4];
        for (int i = 0; i < this.cells.length; ++i) {
            byte[] temp = new byte[]{bytes[i * 4], bytes[i * 4 + 1], bytes[i * 4 + 2], bytes[i * 4 + 3]};
            this.cells[i] = Utils.hexToInt(temp);
        }
    }

    private void checkLastRunDate(String pStr) throws LicenseFileErrorException {
        String date = "";
        if (this.fileCfgInfo == null) {
            if (!StrUtil.isEmpty(pStr)) {
                date = LicenseUtil.decrypt(LABEL_LASTDATE, pStr, this.isValidate);
            }
        } else {
            date = this.fileCfgInfo.getLastRunDate();
        }
        if (StrUtil.isEmpty(date)) {
            this.lastDate = new Date(System.currentTimeMillis());
            return;
        }
        try {
            this.lastDate = Utils.parseDate(date);
        }
        catch (ParseException e) {
            throw new LicenseFileErrorException(1000, LABEL_LASTDATE, e);
        }
        long current = System.currentTimeMillis();
        long last = this.lastDate.getTime();
        if (last > current) {
            throw new LicenseFileErrorException(1002);
        }
        this.lastDate.setTime(current);
    }

    private void checkInitialDate(String pStr) throws LicenseFileErrorException {
        String date = "";
        if (this.fileCfgInfo == null) {
            if (!StrUtil.isEmpty(pStr)) {
                date = LicenseUtil.decrypt(LABEL_INITDATE, pStr, this.isValidate);
            }
        } else {
            date = this.fileCfgInfo.getInitDate();
        }
        if (StrUtil.isEmpty(date)) {
            this.initDate = new Date(System.currentTimeMillis());
            return;
        }
        try {
            this.initDate = Utils.parseDate(date);
        }
        catch (ParseException e) {
            throw new LicenseFileErrorException(1000, LABEL_INITDATE, e);
        }
    }

    private void checkLicenseType(String pStr) throws LicenseFileErrorException {
        String str;
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_TYPE);
        }
        this.licenseType = str = LicenseUtil.decrypt(LABEL_LICENSE_TYPE, pStr, this.isValidate);
    }

    private void checkLicenseUuid(String pStr) throws LicenseFileErrorException {
        String str;
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_UUID);
        }
        this.id = str = LicenseUtil.decrypt(LABEL_LICENSE_UUID, pStr, this.isValidate);
    }

    private void checkTrial(String pStr) throws LicenseFileErrorException {
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_IS_TRIAL);
        }
        String str = LicenseUtil.decrypt(LABEL_LICENSE_IS_TRIAL, pStr, this.isValidate);
        this.trial = Boolean.parseBoolean(str.trim());
    }

    private void checkOldFormat(String pStr) throws LicenseFileErrorException {
        if (pStr != null && !pStr.trim().equals("")) {
            String str = LicenseUtil.decrypt(LABEL_LICENSE_IS_OLD, pStr, this.isValidate);
            this.oldFormat = Boolean.parseBoolean(str.trim());
        }
    }

    private void checkSubSystem(String pStr) throws LicenseFileErrorException {
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_SUBSYSTEM_MODULER_TYPE);
        }
        if (pStr != null && !pStr.trim().equals("")) {
            String str;
            this.subSystemType = str = LicenseUtil.decrypt(LABEL_SUBSYSTEM_MODULER_TYPE, pStr, this.isValidate);
        }
    }

    private void checkEasVersion(String pStr) throws LicenseFileErrorException {
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_PRODUCT_VERSION);
        }
        if (pStr != null && !pStr.trim().equals("")) {
            String str;
            this.productVersion = str = LicenseUtil.decrypt(LABEL_LICENSE_PRODUCT_VERSION, pStr, this.isValidate);
        }
    }

    private void checkProductName(String pStr) throws LicenseFileErrorException {
        if (pStr != null && !pStr.trim().equals("")) {
            String str;
            this.productName = str = LicenseUtil.decrypt(LABEL_LICENSE_PRODUCT_NAME, pStr, this.isValidate);
        }
    }

    private void checkControlPolicy(String pStr) throws LicenseFileErrorException {
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_CONTROL_POLICY);
        }
        if (pStr != null && !pStr.trim().equals("")) {
            String str;
            this.controlPolicy = str = LicenseUtil.decrypt(LABEL_LICENSE_CONTROL_POLICY, pStr, this.isValidate);
        }
    }

    private void checkIndustry(String pStr) throws LicenseFileErrorException {
        if (pStr != null && !pStr.trim().equals("")) {
            String str = LicenseUtil.decrypt(LABEL_LICENSE_INDUSTRY, pStr, this.isValidate);
            this.industry = str.trim();
        }
    }

    private void checkPackageModuleType(String pStr) throws LicenseFileErrorException {
        String str;
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_PACKAGE_MODULAR_TYPE);
        }
        this.packageModularType = str = LicenseUtil.decrypt(LABEL_PACKAGE_MODULAR_TYPE, pStr, this.isValidate);
    }

    private void checkUnlimitePackageType(String pStr) throws LicenseFileErrorException {
        String str;
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_UNLIMITED_PACKAGE_TYPE);
        }
        this.unLimitedPackageType = str = LicenseUtil.decrypt(LABEL_UNLIMITED_PACKAGE_TYPE, pStr, this.isValidate);
    }

    private void checkExpireDate(String pStr) throws LicenseFileErrorException {
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_EXPIREDATE);
        }
        String date = LicenseUtil.decrypt(LABEL_EXPIREDATE, pStr, this.isValidate);
        try {
            this.expireDate = Utils.parseDate(date);
        }
        catch (ParseException e) {
            throw new LicenseFileErrorException(1000, LABEL_EXPIREDATE, e);
        }
    }

    private void checkCounter(String pStr) throws LicenseFileErrorException {
        String tv = "0";
        if (this.fileCfgInfo == null) {
            if (!StrUtil.isEmpty(pStr)) {
                tv = LicenseUtil.decrypt(LABEL_COUNTER, pStr, this.isValidate);
            }
        } else {
            tv = this.fileCfgInfo.getCounter();
        }
        if (StrUtil.isEmpty(tv)) {
            tv = "0";
        }
        this.counter = Integer.parseInt(tv) + 1;
    }

    private void checkRegUsers(String regUsers) throws LicenseFileErrorException {
        try {
            byte[] base64key = Coder.decryptBASE64(regUsers);
            this.regUsers = new String(base64key, "GBK");
        }
        catch (Exception e) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_REGUSERS, e);
        }
    }

    private void checkRegUsersSign(String regUsersSign, String regUsers) throws LicenseFileErrorException {
        try {
            String md5 = Coder.bufferToHex(Coder.encryptMD5(regUsers.getBytes()));
            String sign = LicenseUtil.decrypt(LABEL_LICENSE_REGUSERSSIGN, regUsersSign, this.isValidate);
            if (StrUtil.isEmpty(regUsersSign) || !md5.equals(sign)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_REGUSERSSIGN, e);
        }
    }

    private void checkProductInstanceID(String productInstanceID) throws LicenseFileErrorException {
        if (StrUtil.isEmpty(productInstanceID)) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_PRODUCT_INSTANCEID);
        }
        this.productInstanceID = LicenseUtil.decrypt(LABEL_EXPIREDATE, productInstanceID, this.isValidate);
    }

    private void checkSum(String str, String pSum) throws LicenseFileErrorException {
        if (pSum == null) {
            throw new LicenseFileErrorException(1000, LABEL_CHECKSUM);
        }
        if (!(pSum = LicenseUtil.decrypt(LABEL_CHECKSUM, pSum, this.isValidate, false)).equals(str)) {
            throw new LicenseFileErrorException(1000, LABEL_CHECKSUM);
        }
    }

    private void checkSumPack(String str, String pSumPack) throws LicenseFileErrorException {
        if (pSumPack == null) {
            throw new LicenseFileErrorException(1000, LABEL_CHECKSUMPACK);
        }
        if (!(pSumPack = LicenseUtil.decrypt(LABEL_CHECKSUMPACK, pSumPack, this.isValidate, false)).equals(str)) {
            throw new LicenseFileErrorException(1000, LABEL_CHECKSUMPACK);
        }
    }

    private void checkVariant() {
        this.softwareName = this.softwareName == null ? "YourAppName" : this.softwareName;
    }

    @Override
    protected String getLicenseLabelValue(String labelKey) throws LicenseFileErrorException {
        String entryStr = this.app.get(labelKey);
        String str = "";
        logger.info("***** wrs labelKey1:" + labelKey);
        if (LABEL_CHECKSUM.equals(labelKey) || LABEL_CHECKSUMPACK.equals(labelKey) || LABEL_LICENSE_CHECKSUMPACKDATE.equals(labelKey)) {
            logger.info("***** wrs labelKey2:" + labelKey);
            logger.info("***** wrs entryStr2:" + labelKey);
            logger.info("***** wrs isValidate2:" + labelKey);
            str = LicenseUtil.decrypt(labelKey, entryStr, this.isValidate, false);
        } else {
            logger.info("***** wrs labelKey3:" + labelKey);
            logger.info("***** wrs entryStr4:" + labelKey);
            logger.info("***** wrs isValidate5:" + labelKey);
            str = LicenseUtil.decrypt(labelKey, entryStr, this.isValidate);
        }
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseLicenseFile() throws LicenseFileErrorException {
        try {
            String section;
            if (this.app != null) return;
            IniFile iniFile = new IniFile(this.inputStream);
            this.softwareName = section = iniFile.getSections().iterator().next().toString();
            LicenseKey.getInstance().init(this.softwareName);
            this.app = iniFile.getSection(this.softwareName);
            if (this.app != null) return;
        }
        catch (IOException ioe) {
            throw new LicenseFileErrorException(1001, (Throwable)ioe);
        }
        catch (InvalidFormatException ife) {
            throw new LicenseFileErrorException(1000, ife.getMessage(), ife);
        }
    }

    @Override
    public void readLicense() throws LicenseFileErrorException {
        try {
            this.checkVariant();
            String _industry = this.app.get(LABEL_LICENSE_INDUSTRY);
            this.checkIndustry(_industry);
            String _easVersion = this.app.get(LABEL_LICENSE_PRODUCT_VERSION);
            this.checkEasVersion(_easVersion);
            String _libkey = this.app.get(LABEL_KEY);
            String _cells = this.app.get(LABEL_CELLS);
            String _lastRunDate = this.app.get(LABEL_LASTDATE);
            String _initialDate = this.app.get(LABEL_INITDATE);
            String _expireDate = this.app.get(LABEL_EXPIREDATE);
            String _counter = this.app.get(LABEL_COUNTER);
            String _checkSum = this.app.get(LABEL_CHECKSUM);
            String _licenseType = this.app.get(LABEL_LICENSE_TYPE);
            String _version = this.app.get(LABEL_LICENSE_VERSION);
            String _userInfo = this.app.get(LABEL_LICENSE_USER);
            String _createDate = this.app.get(LABEL_LICENSE_CREATE_TIME);
            String _userName = this.app.get(LABEL_LICENSE_USERNAME);
            String _subSystemType = this.app.get(LABEL_SUBSYSTEM_MODULER_TYPE);
            String _productName = this.app.get(LABEL_LICENSE_PRODUCT_NAME);
            String _controlPolicy = this.app.get(LABEL_LICENSE_CONTROL_POLICY);
            String _productCode = this.app.get(LABEL_LICENSE_PRODUCTCODE);
            String _softwareCode = this.app.get(LABEL_LICENSE_SOFTWARECODE);
            String _uuid = this.app.get(LABEL_LICENSE_UUID);
            String _isTrial = this.app.get(LABEL_LICENSE_IS_TRIAL);
            String _tempLicense = this.app.get(LABEL_TEMP_LICENSE);
            String _packageModuleType = this.app.get(LABEL_PACKAGE_MODULAR_TYPE);
            String _unLimitePackageType = this.app.get(LABEL_UNLIMITED_PACKAGE_TYPE);
            String _oldFormat = this.app.get(LABEL_LICENSE_IS_OLD);
            String _checkSumPack = this.app.get(LABEL_CHECKSUMPACK);
            String _serviceDate = this.app.get(LABEL_LICENSE_SERVICE_DATE);
            String _licenseTo = this.app.get(LABEL_LICENSE_TO);
            String _checksumPackDate = this.app.get(LABEL_LICENSE_CHECKSUMPACKDATE);
            String _regUsers = this.app.get(LABEL_LICENSE_REGUSERS);
            String _regUsersSign = this.app.get(LABEL_LICENSE_REGUSERSSIGN);
            String _productInstanceID = this.app.get(LABEL_LICENSE_PRODUCT_INSTANCEID);
            this.checkLicenseUuid(_uuid);
            this.fileCfgInfo = this.getLicenseFileCfgInfo();
            this.checkSoftWareCode(_softwareCode);
            this.checkTrial(_isTrial);
            this.checkControlPolicy(_controlPolicy);
            boolean isRegist = ControlPolicy.isByRegistUsers(this.controlPolicy);
            logger.info("isRegist===" + isRegist);
            if (this.trial && !isRegist) {
                this.registed = true;
            }
            this.checkCells(_cells);
            this.checkLicenseType(_licenseType);
            this.checkLastRunDate(_lastRunDate);
            this.checkInitialDate(_initialDate);
            this.checkVersion(_version);
            this.checkUserInfo(_userInfo);
            this.cehckCreateDate(_createDate);
            this.checkExpireDate(_expireDate);
            this.checkCounter(_counter);
            this.checkUserName(_userName);
            this.checkSubSystem(_subSystemType);
            this.checkProductName(_productName);
            if (isRegist) {
                this.checkRegUsers(_regUsers);
                this.checkProductInstanceID(_productInstanceID);
            }
            this.hasHighAvailModule();
            CheckSumBuilder checkSumBuilder = new CheckSumBuilder();
            checkSumBuilder.liberationKey(_libkey).softwareName("").productCode(_productCode).softwareCode(_softwareCode).cells(_cells).userName(_userName).userInfo(_userInfo).licenseTo(_licenseTo).licenseType(_licenseType).licenseVersion("").subSystemType(_subSystemType).controlPolicy(_controlPolicy).serviceDate(_serviceDate).lastRunDate(_lastRunDate).initialDate(_initialDate).expireDate(_expireDate).counter(_counter).regUsersSign(_regUsersSign).productInstanceID(_productInstanceID);
            this.checksum = checkSumBuilder.getHash();
            this.checkSum(this.checksum, _checkSum);
            CheckSumPackBuilder checkSumPackBuilder = new CheckSumPackBuilder();
            checkSumPackBuilder.licenseType(_licenseType).unLimitePackageType(_unLimitePackageType).packageModuleType(_packageModuleType).licenseID(_uuid).isTrial(_isTrial).oldFormat(_oldFormat).subSystemType(_subSystemType).easVersion(_easVersion).tempLicense(_tempLicense);
            this.checkSumPack(checkSumPackBuilder.getHash(), _checkSumPack);
            this.checkTempLicense(_tempLicense);
            this.checkPackageModuleType(_packageModuleType);
            this.checkUnlimitePackageType(_unLimitePackageType);
            this.checkOldFormat(_oldFormat);
            if (_serviceDate != null) {
                this.checkServiceDate(_serviceDate);
            }
            if (_licenseTo != null) {
                this.checkLicenseTo(_licenseTo);
            }
            if (_serviceDate != null && _licenseTo != null && _checksumPackDate != null) {
                CheckSumPackDate checkSumPackDateBuilder = new CheckSumPackDate();
                checkSumPackDateBuilder.controlPolicy(_controlPolicy).industry(_industry).licenseTo(_licenseTo).serviceDate(_serviceDate);
                this.checkSumPackDate(checkSumPackDateBuilder.getHash(), _checksumPackDate);
            }
            this.parseSubSystemType(this.subSystemType);
            this.parseModuleDetails(this.licenseType);
            this.parseUnLimitedPackages(this.unLimitedPackageType);
            this.parseModulePackageMap(this.packageModularType);
            this.validateStatus = this.getValidate();
        }
        catch (Exception e) {
            throw new LicenseFileErrorException(1000, (Throwable)e);
        }
    }

    private void checkTempLicense(String _tempLicense) throws LicenseFileErrorException {
        if (_tempLicense == null) {
            return;
        }
        String str = LicenseUtil.decrypt(LABEL_TEMP_LICENSE, _tempLicense, this.isValidate);
        this.isLimitEdition = Boolean.parseBoolean(str.trim());
    }

    private void parseModuleDetails(String licenseType) throws LicenseFileErrorException {
        String[] strs = licenseType.split(";");
        if (strs == null || strs.length == 0) {
            throw new LicenseFileErrorException(1000, "ModuleLicence");
        }
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i] == null || strs[i].trim().equals("")) continue;
            String[] temps = strs[i].split(",");
            if (temps == null || temps.length != 5 || temps[0] == null || temps[0].length() == 0 || temps[2] == null || temps[2].length() == 0) {
                throw new LicenseFileErrorException(1000, "ModuleLicence");
            }
            if (temps[0].equals(TEACH_EDITION) && Integer.parseInt(temps[2]) == 1) {
                this.isTeachEdition = true;
                continue;
            }
            Date exprieDate = null;
            int duration = 0;
            try {
                Integer.parseInt(temps[2]);
                if (!this.trial) {
                    exprieDate = Utils.parseDate(temps[3]);
                } else {
                    duration = Integer.parseInt(temps[4]);
                    if (ControlPolicy.isByRegistUsers(this.getControlPolicy())) {
                        exprieDate = this.expireDate;
                    }
                }
            }
            catch (NumberFormatException ex) {
                throw new LicenseFileErrorException(1000, "ModuleLicence", ex);
            }
            catch (ParseException e) {
                throw new LicenseFileErrorException(1000, "ModuleLicence", e);
            }
            String[] subModules = null;
            String modules = (String)this.subSystemModuleMap.get(temps[0]);
            if (modules != null && !modules.trim().equals("")) {
                subModules = modules.split(",");
            }
            ModuleLicenseInfo obj = new ModuleLicenseInfo();
            obj.setModuleName(temps[0]);
            obj.setModuleAlias(temps[1]);
            obj.setLicenseNum(Integer.parseInt(temps[2]));
            obj.setExpireDate(exprieDate);
            obj.setDuration(duration);
            obj.setTrial(this.trial);
            obj.setLimitEdition(this.isLimitEdition);
            obj.setInitDate(this.initDate);
            obj.setLicenseFileID(this.id);
            obj.setSubModules(subModules);
            obj.setControlPolicy(this.controlPolicy);
            this.moduleDetails.add(obj);
        }
    }

    private void parseModulePackageMap(String modulePackageType) throws LicenseFileErrorException {
        String[] strs = modulePackageType.split(";");
        if (strs == null || strs.length == 0) {
            throw new LicenseFileErrorException(1000, "ModuleLicence");
        }
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i] == null || strs[i].trim().equals("")) continue;
            String[] temps = strs[i].split(",");
            if (temps == null || temps.length != 2 || temps[0] == null || temps[0].length() == 0 || temps[1] == null || temps[1].length() == 0) {
                throw new LicenseFileErrorException(1000, "ModuleLicence");
            }
            String packageName = temps[0];
            ModuleMapInfo obj = new ModuleMapInfo();
            if (packageName.endsWith("*")) {
                packageName = packageName.substring(0, temps[0].length() - 1);
            }
            obj.setUIName(packageName);
            obj.setModuleName(temps[1]);
            this.modulePackageMap.add(obj);
        }
    }

    private void parseUnLimitedPackages(String pStr) {
        String[] strs = pStr.split(",");
        this.unLimitedPackages = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            this.unLimitedPackages[i] = strs[i].endsWith("*") ? strs[i].substring(0, strs[i].length() - 1) : strs[i];
        }
    }

    private void cehckCreateDate(String pStr) throws LicenseFileErrorException {
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_CREATE_TIME);
        }
        String date = LicenseUtil.decrypt(LABEL_LICENSE_CREATE_TIME, pStr, this.isValidate);
        try {
            this.createDate = Utils.parseDate(date);
        }
        catch (ParseException e) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_CREATE_TIME, e);
        }
    }

    private void checkUserInfo(String pStr) throws LicenseFileErrorException {
        String str;
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_USER);
        }
        this.userInfo = str = LicenseUtil.decrypt(LABEL_LICENSE_USER, pStr, this.isValidate);
    }

    private void checkUserName(String pStr) throws LicenseFileErrorException {
        String str;
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_USERNAME);
        }
        this.userName = str = LicenseUtil.decrypt(LABEL_LICENSE_USERNAME, pStr, this.isValidate);
    }

    private void checkVersion(String pStr) throws LicenseFileErrorException {
        String str;
        if (pStr == null) {
            throw new LicenseFileErrorException(1000, LABEL_LICENSE_VERSION);
        }
        this.version = str = LicenseUtil.decrypt(LABEL_LICENSE_VERSION, pStr, this.isValidate);
    }

    private int getValidate() {
        int validate = 0;
        if (this.isRegistered() && !this.trial) {
            if (this.checkLicenseFile(this.trial)) {
                validate = 1;
            }
        } else if (this.trial) {
            if (this.checkLicenseFile(this.trial)) {
                validate = 1;
            }
        } else if (this.isRegistered() && (this.moduleDetails == null || this.moduleDetails.size() == 0) && this.unLimitedPackages.length > 0) {
            validate = 1;
        }
        return validate;
    }

    private boolean checkLicenseFile(boolean trial) {
        Date now = new Date();
        if (!trial) {
            for (int i = 0; i < this.moduleDetails.size(); ++i) {
                ModuleLicenseInfo info = (ModuleLicenseInfo)this.moduleDetails.get(i);
                if (!info.getExpireDate().after(now)) continue;
                this.validModuleLicenses.add(info);
            }
        } else {
            for (int i = 0; i < this.moduleDetails.size(); ++i) {
                ModuleLicenseInfo info = (ModuleLicenseInfo)this.moduleDetails.get(i);
                Date expireDate = Utils.addDate(this.initDate, info.getDuration());
                if (ControlPolicy.isByRegistUsers(this.getControlPolicy())) {
                    expireDate = info.getExpireDate();
                }
                info.setExpireDate(expireDate);
                if (!expireDate.after(now)) continue;
                this.validModuleLicenses.add(info);
            }
        }
        return this.validModuleLicenses.size() > 0;
    }

    private String[] convertToNewFormat(String oldLicenseType) throws LicenseFileErrorException {
        String[] strs = oldLicenseType.split(":");
        if (strs == null || strs.length == 0 || strs.length != 3) {
            throw new LicenseFileErrorException(1000, "convertToNewFormat,old license file format error");
        }
        return strs;
    }

    private void parseSubSystemType(String subsystemType) throws LicenseFileErrorException {
        if (subsystemType == null || subsystemType.trim().equals("")) {
            return;
        }
        String[] strs = subsystemType.trim().split(";");
        if (strs == null || strs.length == 0) {
            throw new LicenseFileErrorException(1000, LABEL_SUBSYSTEM_MODULER_TYPE);
        }
        for (int i = 0; i < strs.length; ++i) {
            String temp = strs[i];
            if (temp.trim().equals("")) continue;
            String[] systemModules = temp.split(":");
            this.subSystemModuleMap.put(systemModules[0], systemModules[1]);
        }
    }

    public static String removeSpecilChar(String str) {
        String result = "";
        if (null != str) {
            Pattern pat = Pattern.compile("//s*|\n|\r|\t");
            Matcher mat = pat.matcher(str);
            result = mat.replaceAll("");
        }
        return result;
    }

    boolean isSingleSoftwareCode() {
        return this.src_SoftwareCode.length() == 16;
    }

    boolean hasHighAvailModule() throws LicenseFileErrorException {
        String subSystemType = this.getLicenseLabelValue(LABEL_SUBSYSTEM_MODULER_TYPE);
        if (subSystemType.indexOf("BOSCLUCOM") > -1) {
            this.isHighAvail = true;
            return true;
        }
        return false;
    }

    static String getLabelLicenseSoftwarecode() {
        return LABEL_LICENSE_SOFTWARECODE;
    }

    static String getLabelLicenseTrial() {
        return LABEL_LICENSE_IS_TRIAL;
    }

    static String getLabelLicenseTemp() {
        return LABEL_TEMP_LICENSE;
    }

    static String getLabelLicenseCreateDate() {
        return LABEL_LICENSE_CREATE_TIME;
    }

    private LicenseFileConfigInfo getLicenseFileCfgInfo() {
        return new LicenseFileConfig().getLicenseFileCfgInfo(this.getId());
    }

    public Map<String, String> getApp() {
        return this.app;
    }

    class CheckSumPackDate {
        private String controlPolicy;
        private String industry;
        private String licenseTo;
        private String serviceDate;

        CheckSumPackDate() {
        }

        CheckSumPackDate controlPolicy(String controlPolicy) {
            this.controlPolicy = controlPolicy;
            return this;
        }

        CheckSumPackDate industry(String industry) {
            this.industry = industry;
            return this;
        }

        CheckSumPackDate licenseTo(String licenseTo) {
            this.licenseTo = licenseTo;
            return this;
        }

        CheckSumPackDate serviceDate(String serviceDate) {
            this.serviceDate = serviceDate;
            return this;
        }

        String getHash() {
            StringBuilder hash = new StringBuilder();
            hash.append(this.controlPolicy == null ? "" : this.controlPolicy).append(this.industry == null ? "" : this.industry).append(this.licenseTo == null ? "" : this.licenseTo).append(this.serviceDate == null ? "" : this.serviceDate);
            return LicenseUtil.hash(hash.toString(), LicenseImpl.this.isValidate).substring(0, 16);
        }
    }

    class CheckSumPackBuilder {
        private String licenseType;
        private String unLimitePackageType;
        private String packageModuleType;
        private String licenseID;
        private String isTrial;
        private String oldFormat;
        private String subSystemType;
        private String easVersion;
        private String tempLicense;

        CheckSumPackBuilder() {
        }

        CheckSumPackBuilder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        CheckSumPackBuilder unLimitePackageType(String unLimitePackageType) {
            this.unLimitePackageType = unLimitePackageType;
            return this;
        }

        CheckSumPackBuilder packageModuleType(String packageModuleType) {
            this.packageModuleType = packageModuleType;
            return this;
        }

        CheckSumPackBuilder licenseID(String licenseID) {
            this.licenseID = licenseID;
            return this;
        }

        CheckSumPackBuilder isTrial(String isTrial) {
            this.isTrial = isTrial;
            return this;
        }

        CheckSumPackBuilder oldFormat(String oldFormat) {
            this.oldFormat = oldFormat;
            return this;
        }

        CheckSumPackBuilder subSystemType(String subSystemType) {
            this.subSystemType = subSystemType;
            return this;
        }

        CheckSumPackBuilder easVersion(String easVersion) {
            this.easVersion = easVersion;
            return this;
        }

        CheckSumPackBuilder tempLicense(String tempLicense) {
            this.tempLicense = tempLicense;
            return this;
        }

        String getHash() {
            StringBuilder hash = new StringBuilder();
            hash.append(this.licenseType == null ? "" : this.licenseType).append(this.unLimitePackageType == null ? "" : this.unLimitePackageType).append(this.packageModuleType == null ? "" : this.packageModuleType).append(this.licenseID == null ? "" : this.licenseID).append(this.isTrial == null ? "" : this.isTrial).append(this.oldFormat == null ? "" : this.oldFormat).append(this.subSystemType == null ? "" : this.subSystemType).append(this.easVersion == null ? "" : this.easVersion).append(this.tempLicense == null ? "" : this.tempLicense);
            return LicenseUtil.hash(hash.toString(), LicenseImpl.this.isValidate).substring(0, 16);
        }
    }

    class CheckSumBuilder {
        private String liberationKey;
        private String softwareName;
        private String productCode;
        private String softwareCode;
        private String cells;
        private String userName;
        private String userInfo;
        private String licenseTo;
        private String licenseType;
        private String licenseVersion;
        private String subSystemType;
        private String controlPolicy;
        private String serviceDate;
        private String lastRunDate;
        private String initialDate;
        private String expireDate;
        private String counter;
        private String regUsersSign;
        private String productInstanceID;

        CheckSumBuilder() {
        }

        CheckSumBuilder liberationKey(String liberationKey) {
            this.liberationKey = liberationKey;
            return this;
        }

        CheckSumBuilder softwareName(String softwareName) {
            this.softwareName = softwareName;
            return this;
        }

        CheckSumBuilder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        CheckSumBuilder softwareCode(String softwareCode) {
            this.softwareCode = softwareCode;
            return this;
        }

        CheckSumBuilder cells(String cells) {
            this.cells = cells;
            return this;
        }

        CheckSumBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        CheckSumBuilder userInfo(String userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        CheckSumBuilder licenseTo(String licenseTo) {
            this.licenseTo = licenseTo;
            return this;
        }

        CheckSumBuilder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        CheckSumBuilder licenseVersion(String licenseVersion) {
            this.licenseVersion = licenseVersion;
            return this;
        }

        CheckSumBuilder subSystemType(String subSystemType) {
            this.subSystemType = subSystemType;
            return this;
        }

        CheckSumBuilder controlPolicy(String controlPolicy) {
            this.controlPolicy = controlPolicy;
            return this;
        }

        CheckSumBuilder serviceDate(String serviceDate) {
            this.serviceDate = serviceDate;
            return this;
        }

        CheckSumBuilder lastRunDate(String lastRunDate) {
            this.lastRunDate = lastRunDate;
            return this;
        }

        CheckSumBuilder initialDate(String initialDate) {
            this.initialDate = initialDate;
            return this;
        }

        CheckSumBuilder expireDate(String expireDate) {
            this.expireDate = expireDate;
            return this;
        }

        CheckSumBuilder counter(String counter) {
            this.counter = counter;
            return this;
        }

        CheckSumBuilder regUsersSign(String regUsersSign) {
            this.regUsersSign = regUsersSign;
            return this;
        }

        CheckSumBuilder productInstanceID(String productInstanceID) {
            this.productInstanceID = productInstanceID;
            return this;
        }

        String getHash() {
            StringBuilder hash = new StringBuilder();
            hash.append(this.liberationKey == null ? "" : this.liberationKey).append(this.softwareName == null ? "" : this.softwareName).append(this.productCode == null ? "" : this.productCode).append(this.softwareCode == null ? "" : this.softwareCode).append(this.cells == null ? "" : this.cells).append(this.userName == null ? "" : this.userName).append(this.userInfo == null ? "" : this.userInfo).append(this.licenseTo == null ? "" : this.licenseTo).append(this.licenseType == null ? "" : this.licenseType).append(this.licenseVersion == null ? "" : this.licenseVersion).append(this.subSystemType == null ? "" : this.subSystemType).append(this.controlPolicy == null ? "" : this.controlPolicy).append(this.serviceDate == null ? "" : this.serviceDate).append(this.lastRunDate == null ? "" : this.lastRunDate).append(this.initialDate == null ? "" : this.initialDate).append(this.expireDate == null ? "" : this.expireDate).append(this.counter == null ? "" : this.counter).append(this.regUsersSign == null ? "" : this.regUsersSign).append(this.productInstanceID == null ? "" : this.productInstanceID);
            return LicenseUtil.hash(hash.toString(), LicenseImpl.this.isValidate).substring(0, 16);
        }
    }
}

