/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.codeless;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ebg.egf.common.codeless.PackerUtil.CodeLessUtil;
import kd.ebg.egf.common.codeless.services.FuncNameRelection;
import kd.ebg.egf.common.codeless.services.Function;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.codeless.CodeLess;
import kd.ebg.egf.common.model.codeless.CodeLessRequestBody;
import kd.ebg.egf.common.model.codeless.CodeLessRequestFileCont;
import kd.ebg.egf.common.model.codeless.CodeLessRequestFileName;
import kd.ebg.egf.common.model.codeless.CodeLessRequestHeader;
import kd.ebg.egf.common.model.codeless.CodeLessRespResultParam;
import kd.ebg.egf.common.model.codeless.CodeLessResponseBody;
import kd.ebg.egf.common.model.codeless.CodelessLastPageBody;
import kd.ebg.egf.common.model.codeless.CodelessNextPageBody;
import kd.ebg.egf.common.model.codeless.CodelessPageParam;
import kd.ebg.egf.common.repository.codeless.JudgingConditionsRepository;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public class CodeLessRepository {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(CodeLessRepository.class);
    private static CodeLessRepository instance = new CodeLessRepository();
    private static final String ENTITY_NAME = "ebg_code_less";
    private static final String SPLIT = " ";

    public static CodeLessRepository getInstance() {
        return instance;
    }

    public String findNumberByID(Long id) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"number", (QFilter[])new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{id})});
        if (dynamicObject != null) {
            return dynamicObject.getString("number");
        }
        return "";
    }

    public String findBankVersionNumberByID(Long id) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"group.longnumber", (QFilter[])new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{id})});
        if (dynamicObject != null) {
            return dynamicObject.getString("group.longnumber").split("\\.")[0];
        }
        return "";
    }

    public List<Long> findJudgingConditionsIdsByIds(List<Long> ids) {
        List<Long> result = new ArrayList<Long>(16);
        if (CollectionUtils.isNotEmpty(ids)) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            result = this.transJudgingConditionsIds(dynamicObjectMap);
        }
        return result;
    }

    public List<Long> findPageSchemeIdsByIds(List<Long> ids) {
        List<Long> result = new ArrayList<Long>(16);
        if (CollectionUtils.isNotEmpty(ids)) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            result = this.transPageSchemeIds(dynamicObjectMap);
        }
        return result;
    }

    public int countDistinctBankVersionIDByIds(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"count(distinct group) as count", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            return dynamicObject.getInt("count");
        }
        return 0;
    }

    public List<Long> findJudgingConditionIdsByIds(List<Long> ids) {
        List<Long> result = new ArrayList<Long>(16);
        if (CollectionUtils.isNotEmpty(ids)) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            result = this.transJudgingConditionIds(dynamicObjectMap);
        }
        return result;
    }

    public List<String> findNumbersByJudgingConditionIds(List<Long> judgingConditionIds) {
        QFilter qFilter = new QFilter("rspcode_outentity.rsp_out_judgings.id", "in", judgingConditionIds).or(new QFilter("rspcode_innerentity.rsp_inner_judgings.id", "in", judgingConditionIds));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)"number, name", (QFilter[])new QFilter[]{qFilter});
        ArrayList<String> result = new ArrayList<String>(16);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            HashSet<String> numbers = new HashSet<String>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                numbers.add(dynamicObject.getString("number"));
            }
            result.addAll(numbers);
        }
        return result;
    }

    public List<String> findNumbersByJudgingConditionsIds(List<Long> judgingConditionsIds) {
        QFilter qFilter = new QFilter("bodyentryentity.judging_conditions.id", "in", judgingConditionsIds).or(new QFilter("bodyfilenameentity.judging_conditions3.id", "in", judgingConditionsIds)).or(new QFilter("bodyfilecontentity.judging_conditions2.id", "in", judgingConditionsIds));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)"number, name", (QFilter[])new QFilter[]{qFilter});
        ArrayList<String> result = new ArrayList<String>(16);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            HashSet<String> numbers = new HashSet<String>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                numbers.add(dynamicObject.getString("number"));
            }
            result.addAll(numbers);
        }
        return result;
    }

    public CodeLess findByBankVersionIDAndInterfaceCode(String bankVersionID, String bizType, String interfaceCode) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)(bankVersionID + "_NOTE")), new QFilter("biz_type_new.number", "=", (Object)bizType), new QFilter("trans_code", "=", (Object)interfaceCode)});
        return this.transCodeLess(bankVersionID, dynamicObject);
    }

    public CodeLess findByBankVersionIDAndInterfaceCode(String bankVersionID, String interfaceCode) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)(bankVersionID + "_NOTE")), new QFilter("trans_code", "=", (Object)interfaceCode)});
        return this.transCodeLess(bankVersionID, dynamicObject);
    }

    public CodeLess findByBankVersionIDAndInterfaceCodeAndApp(String bankVersionID, String bizType, String interfaceCode, String app) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)(bankVersionID + "_" + app)), new QFilter("biz_type_new.number", "=", (Object)bizType), new QFilter("trans_code", "=", (Object)interfaceCode)});
        return this.transCodeLess(bankVersionID, dynamicObject);
    }

    public CodeLess findByBankVersionIDAndInterfaceCodeAndApp(String bankVersionID, String interfaceCode, String app) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)(bankVersionID + "_" + app)), new QFilter("trans_code", "=", (Object)interfaceCode)});
        return this.transCodeLess(bankVersionID, dynamicObject);
    }

    public String findLogicByBankVersionIDAndInterfaceCode(CodeLessRespResultParam param, String app) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)(param.getBankVersionID() + "_" + app)), new QFilter("trans_code", "=", (Object)param.getInterfaceCode())});
        return this.parseLogicElement(param, dynamicObject);
    }

    private String parseOut(CodeLessRespResultParam param, DynamicObjectCollection outEntity) {
        if (outEntity == null) {
            return null;
        }
        ArrayList<DynamicObject> outer = new ArrayList<DynamicObject>(outEntity.size());
        outer.addAll((Collection<DynamicObject>)outEntity);
        outer.sort(Comparator.comparing(p -> p.getInt("seq")));
        String out_value = param.getOutCodeValue();
        Function s = null;
        Class<?> aClass = null;
        try {
            aClass = Class.forName("kd.ebg.egf.common.codeless.services.Function");
            s = (Function)aClass.newInstance();
        }
        catch (Exception e) {
            this.logger.error("error:", e);
        }
        for (DynamicObject body : outer) {
            String out_judging = body.getDynamicObject("rsp_out_judgings").getString("number");
            DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ebg_judging_condition", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)out_judging)});
            DynamicObjectCollection rsp_body = dynamicObject1.getDynamicObjectCollection("note_judging_body");
            ArrayList<DynamicObject> logic = new ArrayList<DynamicObject>(rsp_body.size());
            logic.addAll((Collection<DynamicObject>)rsp_body);
            logic.sort(Comparator.comparing(p -> p.getInt("seq")));
            StringBuilder expression = new StringBuilder();
            for (DynamicObject obj : logic) {
                String filter_compare = obj.getString("filter_compare");
                String value = obj.getString("value");
                String filter_link = obj.getString("filter_link");
                if (logic.indexOf(obj) == logic.size() - 1) {
                    filter_link = "";
                }
                Method declaredMethod = null;
                try {
                    declaredMethod = aClass.getDeclaredMethod(FuncNameRelection.getValue(filter_compare), new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    this.logger.error("error:", e);
                }
                try {
                    Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();
                    Throwable throwable = null;
                    try {
                        if (declaredMethod != null) {
                            String funcExpression = String.format("services.callBack('%1$s', '%2$s');", out_value, value);
                            context.getBindings("js").putMember("services", (Object)s);
                            context.eval("js", (CharSequence)funcExpression);
                            Boolean tempResult = (Boolean)declaredMethod.invoke((Object)s, new Object[0]);
                            expression.append(tempResult.toString()).append(SPLIT).append(filter_link);
                            continue;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (context == null) continue;
                        if (throwable != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        context.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    this.logger.error("error:", e);
                }
                expression = expression.append(out_value).append(SPLIT).append(filter_compare).append(SPLIT).append(value).append(SPLIT).append(filter_link);
            }
            Boolean evaluation = null;
            try (Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();){
                Value js = context.eval("js", (CharSequence)expression.toString());
                evaluation = js.asBoolean();
            }
            catch (Exception e) {
                this.logger.error(EBExceiptionUtil.stackTraceString(e.getStackTrace()));
            }
            if (evaluation == null) {
                return null;
            }
            if (!evaluation.equals(Boolean.TRUE)) continue;
            String out_result = body.getString("rsp_out_result");
            return out_result;
        }
        return null;
    }

    private String parseInner(CodeLessRespResultParam param, DynamicObjectCollection innerEntity) {
        if (innerEntity == null) {
            return null;
        }
        ArrayList<DynamicObject> inner = new ArrayList<DynamicObject>(innerEntity.size());
        inner.addAll((Collection<DynamicObject>)innerEntity);
        inner.sort(Comparator.comparing(p -> p.getInt("seq")));
        String inner_value = param.getInnerCodeValue();
        String inner_value2 = param.getInnerCodeValue2();
        String inner_value3 = param.getInnerCodeValue3();
        Function s = null;
        Class<?> aClass = null;
        try {
            aClass = Class.forName("kd.ebg.egf.common.codeless.services.Function");
            s = (Function)aClass.newInstance();
        }
        catch (Exception e) {
            this.logger.error("error ", e);
        }
        for (DynamicObject body : innerEntity) {
            String inner_judging = body.getDynamicObject("rsp_inner_judgings").getString("number");
            DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ebg_judging_condition", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)inner_judging)});
            DynamicObjectCollection rsp_body = dynamicObject1.getDynamicObjectCollection("note_judging_body");
            ArrayList<DynamicObject> logic = new ArrayList<DynamicObject>(rsp_body.size());
            logic.addAll((Collection<DynamicObject>)rsp_body);
            logic.sort(Comparator.comparing(p -> p.getInt("seq")));
            StringBuilder expression = new StringBuilder();
            for (DynamicObject obj : logic) {
                String field = obj.getString("code_field");
                String filter_compare = obj.getString("filter_compare");
                String value = obj.getString("value");
                String filter_link = obj.getString("filter_link");
                String compare_value = "";
                Method declaredMethod = null;
                compare_value = field.equals("inner_code") ? inner_value : ("inner_code2".equals(field) ? inner_value2 : inner_value3);
                if (logic.indexOf(obj) == logic.size() - 1) {
                    filter_link = "";
                }
                try {
                    declaredMethod = aClass.getDeclaredMethod(FuncNameRelection.getValue(filter_compare), new Class[0]);
                }
                catch (Exception e) {
                    this.logger.error("error ", e);
                }
                try {
                    Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();
                    Throwable throwable = null;
                    try {
                        if (declaredMethod != null) {
                            String funcExpression = String.format("services.callBack('%1$s', '%2$s');", compare_value, value);
                            context.getBindings("js").putMember("services", (Object)s);
                            context.eval("js", (CharSequence)funcExpression);
                            Boolean tempResult = (Boolean)declaredMethod.invoke((Object)s, new Object[0]);
                            expression.append(tempResult.toString()).append(SPLIT).append(filter_link);
                            continue;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (context == null) continue;
                        if (throwable != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        context.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    this.logger.error("error ", e);
                }
                expression = expression.append(SPLIT).append(filter_compare).append(SPLIT).append(value).append(SPLIT).append(filter_link).append(SPLIT);
            }
            Boolean evaluation = null;
            try (Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();){
                Value js = context.eval("js", (CharSequence)expression.toString());
                evaluation = js.asBoolean();
            }
            catch (Exception e) {
                this.logger.error(EBExceiptionUtil.stackTraceString(e.getStackTrace()));
            }
            if (evaluation == null) {
                return null;
            }
            if (!evaluation.equals(Boolean.TRUE)) continue;
            return body.getString("rsp_inner_result");
        }
        return null;
    }

    private String parseLogicElement(CodeLessRespResultParam param, DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        DynamicObjectCollection outentity = dynamicObject.getDynamicObjectCollection("rspcode_outentity");
        DynamicObjectCollection innerentity = dynamicObject.getDynamicObjectCollection("rspcode_innerentity");
        if (!StringUtils.isEmpty(param.getOutCodeValue())) {
            return this.parseOut(param, outentity);
        }
        return this.parseInner(param, innerentity);
    }

    private List<Long> transJudgingConditionsIds(Map<Object, DynamicObject> dynamicObjectMap) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        if (!dynamicObjectMap.isEmpty()) {
            HashSet<Long> sets = new HashSet<Long>(16);
            for (Map.Entry<Object, DynamicObject> entry : dynamicObjectMap.entrySet()) {
                DynamicObject dynamicObject = entry.getValue();
                DynamicObjectCollection bodys = dynamicObject.getDynamicObjectCollection("bodyentryentity");
                this.getJudgingConditionIds(sets, bodys, "judging_conditions");
                DynamicObjectCollection bodys2 = dynamicObject.getDynamicObjectCollection("bodyfilenameentity");
                this.getJudgingConditionIds(sets, bodys2, "judging_conditions3");
                DynamicObjectCollection bodys3 = dynamicObject.getDynamicObjectCollection("bodyfilecontentity");
                this.getJudgingConditionIds(sets, bodys3, "judging_conditions2");
                DynamicObjectCollection rspbody_entryentity = dynamicObject.getDynamicObjectCollection("rspbody_entryentity");
                this.getJudgingConditionIds(sets, rspbody_entryentity, "parse_judging_conditions");
            }
            result.addAll(sets);
        }
        return result;
    }

    private List<Long> transPageSchemeIds(Map<Object, DynamicObject> dynamicObjectMap) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        if (!dynamicObjectMap.isEmpty()) {
            HashSet<Long> sets = new HashSet<Long>(16);
            for (Map.Entry<Object, DynamicObject> entry : dynamicObjectMap.entrySet()) {
                DynamicObject dynamicObject = entry.getValue();
                DynamicObjectCollection bodys = dynamicObject.getDynamicObjectCollection("lastpage_entity");
                this.getJudgingConditionIds(sets, bodys, "lastpage_scheme");
                DynamicObjectCollection bodys2 = dynamicObject.getDynamicObjectCollection("nextpage_entity");
                this.getJudgingConditionIds(sets, bodys2, "nextpage_scheme");
            }
            result.addAll(sets);
        }
        return result;
    }

    private List<Long> transJudgingConditionIds(Map<Object, DynamicObject> dynamicObjectMap) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        if (!dynamicObjectMap.isEmpty()) {
            HashSet<Long> sets = new HashSet<Long>(16);
            for (Map.Entry<Object, DynamicObject> entry : dynamicObjectMap.entrySet()) {
                DynamicObject dynamicObject = entry.getValue();
                DynamicObjectCollection bodys = dynamicObject.getDynamicObjectCollection("rspcode_outentity");
                this.getJudgingConditionIds(sets, bodys, "rsp_out_judgings");
                DynamicObjectCollection bodys2 = dynamicObject.getDynamicObjectCollection("rspcode_innerentity");
                this.getJudgingConditionIds(sets, bodys2, "rsp_inner_judgings");
            }
            result.addAll(sets);
        }
        return result;
    }

    private void getJudgingConditionIds(Set<Long> ids, DynamicObjectCollection bodys, String judgingConditionsKey) {
        if (!bodys.isEmpty()) {
            for (DynamicObject body : bodys) {
                DynamicObject judgingConditions = body.getDynamicObject(judgingConditionsKey);
                if (judgingConditions == null) continue;
                ids.add(judgingConditions.getLong("id"));
            }
        }
    }

    private void getPageSchemeIds(Set<Long> ids, DynamicObjectCollection bodys, String judgingConditionsKey) {
        if (!bodys.isEmpty()) {
            for (DynamicObject body : bodys) {
                DynamicObject judgingConditions = body.getDynamicObject(judgingConditionsKey);
                if (judgingConditions == null) continue;
                ids.add(judgingConditions.getLong("id"));
            }
        }
    }

    private CodeLess transCodeLess(String bankVersionID, DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        CodeLess result = new CodeLess();
        result.setBankVersionID(bankVersionID);
        result.setAppCode("note");
        result.setNumber(dynamicObject.getString("number"));
        result.setName(dynamicObject.getString("name"));
        result.setEnable(dynamicObject.getString("enable"));
        result.setStatus(dynamicObject.getString("status"));
        DynamicObject biz_type_new = dynamicObject.getDynamicObject("biz_type_new");
        result.setBizType(biz_type_new.getString("number"));
        result.setInterfaceCode(dynamicObject.getString("trans_code"));
        result.setContentType(dynamicObject.getString("contenttype"));
        result.setFileUpload(dynamicObject.getBoolean("is_fileupload"));
        result.setFilecontSplit(dynamicObject.getString("file_split"));
        result.setFilenameSplit(dynamicObject.getString("filename_split"));
        result.setFilenameSuffix(dynamicObject.getString("filename_suffix"));
        result.setFileBizType(dynamicObject.getString("file_biztype"));
        result.setFileHead(dynamicObject.getString("file_head"));
        result.setNeedPage(dynamicObject.getBoolean("is_need_page"));
        result.setFirstPage(dynamicObject.getString("first_tag"));
        result.setCdSetter(dynamicObject.getString("cd_setter"));
        result.setCurSetter(dynamicObject.getString("cur_setter"));
        result.setCreditType(dynamicObject.getString("credit_type"));
        result.setDebitType(dynamicObject.getString("debit_type"));
        HashMap<String, Long> pageParam = new HashMap<String, Long>(6);
        HashMap<String, String> orgPageParam = new HashMap<String, String>(6);
        DynamicObjectCollection headers = dynamicObject.getDynamicObjectCollection("headerentryentity");
        ArrayList<CodeLessRequestHeader> requestHeaders = new ArrayList<CodeLessRequestHeader>(16);
        if (!headers.isEmpty()) {
            for (DynamicObject header : headers) {
                CodeLessRequestHeader requestHeader = new CodeLessRequestHeader();
                requestHeader.setHeaderName(header.getString("headername"));
                requestHeader.setHeaderValue(header.getString("headervalue"));
                requestHeader.setHeaderDes(header.getString("headerdes"));
                requestHeaders.add(requestHeader);
            }
        }
        result.setRequestHeaders(requestHeaders);
        JudgingConditionsRepository judgingConditionsRepository = JudgingConditionsRepository.getInstance();
        ArrayList<CodeLessRequestBody> requestBodys = new ArrayList<CodeLessRequestBody>(16);
        DynamicObjectCollection bodys = dynamicObject.getDynamicObjectCollection("bodyentryentity");
        if (!bodys.isEmpty()) {
            for (DynamicObject body : bodys) {
                CodeLessRequestBody requestBody = new CodeLessRequestBody();
                requestBody.setParamName(body.getString("paramname"));
                requestBody.setParamDes(body.getString("paramdes"));
                requestBody.setParamType(body.getString("paramtype"));
                requestBody.setEbgParamSource(body.getString("ebgparam_source"));
                requestBody.setEbgFieldType(body.getString("ebg_field_type"));
                requestBody.setEbgParam(body.getString("ebgparam"));
                requestBody.setExample(body.getString("example"));
                requestBody.setMust(body.getInt("must"));
                requestBody.setParamNode(body.getString("paramnode"));
                requestBody.setBodyParamDes(body.getString("bodyparamdes"));
                requestBody.setEntryID(body.getLong("id"));
                requestBody.setParentEntryID(body.getLong("pid"));
                requestBody.setSeq(body.getInt("seq"));
                Iterator judgingConditions = body.getDynamicObject("judging_conditions");
                if (judgingConditions != null) {
                    requestBody.setJudgingCondition(judgingConditionsRepository.findByNumber(judgingConditions.getString("number")));
                }
                requestBodys.add(requestBody);
            }
        }
        result.setRequestBodys(requestBodys);
        ArrayList<CodeLessRequestBody> fileEntryRequestBodys = new ArrayList<CodeLessRequestBody>(16);
        DynamicObjectCollection fileEntryBodys = dynamicObject.getDynamicObjectCollection("bodyfileentryentity");
        if (!fileEntryBodys.isEmpty()) {
            for (DynamicObject body : fileEntryBodys) {
                CodeLessRequestBody requestBody = new CodeLessRequestBody();
                requestBody.setParamName(body.getString("paramname1"));
                requestBody.setParamDes(body.getString("paramdes1"));
                requestBody.setParamType(body.getString("paramtype1"));
                requestBody.setEbgParamSource(body.getString("ebgparam_source1"));
                requestBody.setEbgFieldType(body.getString("ebg_field_type1"));
                requestBody.setEbgParam(body.getString("ebgparam1"));
                requestBody.setExample(body.getString("example1"));
                requestBody.setMust(body.getInt("must1"));
                requestBody.setParamNode(body.getString("paramnode1"));
                requestBody.setBodyParamDes(body.getString("bodyparamdes1"));
                requestBody.setEntryID(body.getLong("id"));
                requestBody.setParentEntryID(body.getLong("pid"));
                requestBody.setSeq(body.getInt("seq"));
                Iterator judgingConditions = body.getDynamicObject("judging_condition1");
                if (judgingConditions != null) {
                    requestBody.setJudgingCondition(judgingConditionsRepository.findByNumber(judgingConditions.getString("number")));
                }
                fileEntryRequestBodys.add(requestBody);
            }
        }
        result.setFileEntryRequestBodys(fileEntryRequestBodys);
        ArrayList<CodeLessRequestFileName> fileNameRequestBodys = new ArrayList<CodeLessRequestFileName>(16);
        DynamicObjectCollection fileNameBodys = dynamicObject.getDynamicObjectCollection("bodyfilenameentity");
        if (!fileNameBodys.isEmpty()) {
            for (DynamicObject body : fileNameBodys) {
                CodeLessRequestFileName requestBody = new CodeLessRequestFileName();
                requestBody.setEbgParamSource(body.getString("ebgparam_source3"));
                requestBody.setEbgParam(body.getString("ebgparam3"));
                requestBody.setEbgFieldType(body.getString("ebg_field_type3"));
                requestBody.setExample(body.getString("example3"));
                requestBody.setBodyParamDes(body.getString("bodyparamdes3"));
                requestBody.setSeq(body.getInt("seq"));
                Iterator judgingConditions = body.getDynamicObject("judging_conditions3");
                if (judgingConditions != null) {
                    requestBody.setJudgingCondition(judgingConditionsRepository.findByNumber(judgingConditions.getString("number")));
                }
                fileNameRequestBodys.add(requestBody);
            }
        }
        result.setFileNameBodys(fileNameRequestBodys);
        ArrayList<CodeLessRequestFileCont> fileContRequestBodys = new ArrayList<CodeLessRequestFileCont>(16);
        DynamicObjectCollection fileContBodys = dynamicObject.getDynamicObjectCollection("bodyfilecontentity");
        if (!fileContBodys.isEmpty()) {
            for (DynamicObject body : fileContBodys) {
                CodeLessRequestFileCont requestBody = new CodeLessRequestFileCont();
                requestBody.setEbgParamSource(body.getString("ebgparam_source2"));
                requestBody.setEbgFieldType(body.getString("ebg_field_type2"));
                requestBody.setEbgParam(body.getString("ebgparam2"));
                requestBody.setExample(body.getString("example2"));
                requestBody.setMust(body.getInt("must2"));
                requestBody.setBodyParamDes(body.getString("bodyparamdes2"));
                requestBody.setSeq(body.getInt("seq"));
                Iterator judgingConditions = body.getDynamicObject("judging_conditions2");
                if (judgingConditions != null) {
                    requestBody.setJudgingCondition(judgingConditionsRepository.findByNumber(judgingConditions.getString("number")));
                }
                fileContRequestBodys.add(requestBody);
            }
        }
        result.setFileContBodys(fileContRequestBodys);
        ArrayList<CodeLessResponseBody> responseBodys = new ArrayList<CodeLessResponseBody>(16);
        DynamicObjectCollection rspBodys = dynamicObject.getDynamicObjectCollection("rspbody_entryentity");
        if (!rspBodys.isEmpty()) {
            for (DynamicObject body : rspBodys) {
                String page_param_type;
                CodeLessResponseBody responseBody = new CodeLessResponseBody();
                responseBody.setParamName(body.getString("rsp_paramname"));
                responseBody.setParamDes(body.getString("rsp_paramdes"));
                responseBody.setParamNode(body.getString("rsp_paramnode"));
                responseBody.setEbgParam(body.getString("rsp_ebgparam"));
                responseBody.setBodyParamDes(body.getString("rsp_bodyparamdes"));
                responseBody.setCodeField(body.getString("rsp_code_field"));
                responseBody.setRspMatch(body.getString("rsp_match"));
                responseBody.setSeq(body.getInt("seq"));
                responseBody.setParentEntryID(body.getLong("pid"));
                responseBody.setEntryID(body.getLong("id"));
                Iterator judgingConditions = body.getDynamicObject("parse_judging_conditions");
                if (judgingConditions != null) {
                    responseBody.setJudgingCondition(judgingConditionsRepository.findByNumber(judgingConditions.getString("number")));
                }
                if (StringUtils.isNotEmpty(page_param_type = body.getString("page_param_type"))) {
                    pageParam.put(page_param_type, body.getLong("id"));
                }
                responseBodys.add(responseBody);
            }
        }
        result.setResponseBodys(responseBodys);
        for (Map.Entry entry : pageParam.entrySet()) {
            orgPageParam.put((String)entry.getKey(), CodeLessUtil.getRootPath((Long)entry.getValue(), null, responseBodys));
        }
        ArrayList<CodelessLastPageBody> lastpageEntity = new ArrayList<CodelessLastPageBody>(16);
        DynamicObjectCollection lastPageBodys = dynamicObject.getDynamicObjectCollection("lastpage_entity");
        if (!lastPageBodys.isEmpty()) {
            for (Object body : lastPageBodys) {
                CodelessLastPageBody lastPageBody = new CodelessLastPageBody();
                lastPageBody.setResult(body.getString("result"));
                lastPageBody.setSeq(body.getInt("seq"));
                DynamicObject lastpage_scheme = body.getDynamicObject("lastpage_scheme");
                DynamicObjectCollection ebg_page_entity = lastpage_scheme.getDynamicObjectCollection("ebg_page_entity");
                ArrayList<CodelessPageParam> pageParams = new ArrayList<CodelessPageParam>(3);
                lastPageBody.setLastPageSchemes(pageParams);
                for (DynamicObject info : ebg_page_entity) {
                    CodelessPageParam paramValue = new CodelessPageParam();
                    DynamicObject param_select = info.getDynamicObject("param_select");
                    String number = param_select.getString("number");
                    if (orgPageParam.containsKey(number)) {
                        paramValue.setParamValue((String)orgPageParam.get(number));
                        paramValue.setParamType("0");
                    } else {
                        paramValue.setParamValue(number);
                        paramValue.setParamType("1");
                    }
                    String operator = info.getString("operator");
                    paramValue.setOperator(operator);
                    String bracket = info.getString("bracket");
                    paramValue.setBracket(bracket);
                    pageParams.add(paramValue);
                }
                lastpageEntity.add(lastPageBody);
            }
        }
        result.setLastPageBodys(lastpageEntity);
        ArrayList<CodelessNextPageBody> nextPageBodyList = new ArrayList<CodelessNextPageBody>(1);
        DynamicObjectCollection nextpage_entity = dynamicObject.getDynamicObjectCollection("nextpage_entity");
        if (!nextpage_entity.isEmpty()) {
            for (DynamicObject nexpage : nextpage_entity) {
                Object body;
                body = new CodelessNextPageBody();
                DynamicObject nextpage_scheme = nexpage.getDynamicObject("nextpage_scheme");
                DynamicObjectCollection ebg_page_entity = nextpage_scheme.getDynamicObjectCollection("ebg_page_entity");
                ArrayList<CodelessPageParam> pageParams = new ArrayList<CodelessPageParam>(3);
                ((CodelessNextPageBody)body).setPageParams(pageParams);
                for (DynamicObject info : ebg_page_entity) {
                    CodelessPageParam paramValue = new CodelessPageParam();
                    DynamicObject param_select = info.getDynamicObject("param_select");
                    String number = param_select.getString("number");
                    if (orgPageParam.containsKey(number)) {
                        paramValue.setParamValue((String)orgPageParam.get(number));
                        paramValue.setParamType("0");
                    } else {
                        paramValue.setParamValue(number);
                        paramValue.setParamType("1");
                    }
                    String operator = info.getString("operator");
                    paramValue.setOperator(operator);
                    String bracket = info.getString("bracket");
                    paramValue.setBracket(bracket);
                    pageParams.add(paramValue);
                }
                nextPageBodyList.add((CodelessNextPageBody)body);
            }
        }
        result.setNextPageBodys(nextPageBodyList);
        return result;
    }
}

