/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.codeless;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ebg.egf.common.model.codeless.JudgingCondition1;
import kd.ebg.egf.common.model.codeless.JudgingConditionValue;
import kd.ebg.egf.common.model.codeless.JudgingConditions;
import kd.ebg.egf.common.repository.codeless.JudgingConditionRepository;

public class JudgingConditionsRepository {
    private static JudgingConditionsRepository instance = new JudgingConditionsRepository();
    private static final String ENTITY_NAME = "ebg_judging_conditions";

    public static JudgingConditionsRepository getInstance() {
        return instance;
    }

    public JudgingConditions findByNumber(String number) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        return this.transJudgingConditions(dynamicObject);
    }

    public List<Long> findJudgingConditionIdsByIds(List<Long> ids) {
        List<Long> result = new ArrayList<Long>(16);
        if (CollectionUtils.isNotEmpty(ids)) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            result = this.transJudgingConditionIds(dynamicObjectMap);
        }
        return result;
    }

    public List<String> findNumbersByJudgingConditionIds(List<Long> judgingConditionIds) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)"number, name", (QFilter[])new QFilter[]{new QFilter("judgings_entity.condition.id", "in", judgingConditionIds)});
        ArrayList<String> result = new ArrayList<String>(16);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            HashSet<String> numbers = new HashSet<String>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                numbers.add(dynamicObject.getString("number"));
            }
            result.addAll(numbers);
        }
        return result;
    }

    private JudgingConditions transJudgingConditions(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        JudgingConditions result = new JudgingConditions();
        result.setNumber(dynamicObject.getString("number"));
        result.setName(dynamicObject.getString("name"));
        result.setType(dynamicObject.getString("judge_type"));
        DynamicObjectCollection validCollection = dynamicObject.getDynamicObjectCollection("judgings_n_entity");
        if (!validCollection.isEmpty()) {
            JudgingConditionValue validValue = new JudgingConditionValue();
            DynamicObject validValueObject = (DynamicObject)validCollection.get(0);
            validValue.setEntryID(validValueObject.getLong("id"));
            validValue.setSeq(validValueObject.getInt("seq"));
            validValue.setEbgParamSource(validValueObject.getString("ebgparam_source2"));
            validValue.setEbgParam(validValueObject.getString("ebgparam2"));
            validValue.setEbgFieldType(validValueObject.getString("ebg_field_type2"));
            validValue.setValue(validValueObject.getString("value2"));
            validValue.setInjectField(validValueObject.getString("in_ebgfield2"));
            result.setNotValidValue(validValue);
        }
        JudgingConditionRepository judgingConditionRepository = JudgingConditionRepository.getInstance();
        DynamicObjectCollection bodyCollection = dynamicObject.getDynamicObjectCollection("judgings_entity");
        if (!bodyCollection.isEmpty()) {
            ArrayList<JudgingCondition1> judgingConditionList = new ArrayList<JudgingCondition1>(16);
            for (DynamicObject bodyObject : bodyCollection) {
                JudgingCondition1 judgingCondition = new JudgingCondition1();
                judgingCondition.setEntryID(bodyObject.getLong("id"));
                judgingCondition.setSeq(bodyObject.getInt("seq"));
                judgingCondition.setEbgParam(bodyObject.getString("ebgparam"));
                judgingCondition.setEbgParamSource(bodyObject.getString("ebgparam_source"));
                judgingCondition.setEbgFieldType(bodyObject.getString("ebg_field_type"));
                judgingCondition.setValue(bodyObject.getString("value"));
                judgingCondition.setInjectField(bodyObject.getString("in_ebgfield"));
                DynamicObject conditions = bodyObject.getDynamicObject("condition");
                if (conditions != null) {
                    judgingCondition.setJudgingConditionBodys(judgingConditionRepository.findByNumber(conditions.getString("number")));
                }
                judgingConditionList.add(judgingCondition);
            }
            result.setJudgingConditionList(judgingConditionList);
        }
        return result;
    }

    private List<Long> transJudgingConditionIds(Map<Object, DynamicObject> dynamicObjectMap) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        if (!dynamicObjectMap.isEmpty()) {
            HashSet<Long> sets = new HashSet<Long>(16);
            for (Map.Entry<Object, DynamicObject> entry : dynamicObjectMap.entrySet()) {
                DynamicObject dynamicObject = entry.getValue();
                DynamicObjectCollection bodys = dynamicObject.getDynamicObjectCollection("judgings_entity");
                if (bodys.isEmpty()) continue;
                for (DynamicObject body : bodys) {
                    DynamicObject judgingConditions = body.getDynamicObject("condition");
                    if (judgingConditions == null) continue;
                    sets.add(judgingConditions.getLong("id"));
                }
            }
            result.addAll(sets);
        }
        return result;
    }
}

