/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.currency;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.model.currency.BankCurrency;
import kd.ebg.egf.common.model.currency.BankCurrencyKey;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;

public class BankCurrencyRepository {
    private String BANK_CURRENCY_ENTITY = "aqap_bank_currency";
    private String selectProperties = "number,bank_currency,bank_version.number";
    private static BankCurrencyRepository instance = new BankCurrencyRepository();

    public static BankCurrencyRepository getInstance() {
        return instance;
    }

    public BankCurrency findByBankVersionIDAndBankCurrency(String bankVersionID, String bankCurrency, String customID) {
        BankCurrency bc = new BankCurrency();
        String selectProperties = "number,bank_currency,bank_version.number";
        QFilter filter = QFilter.of((String)"bank_version.number = ? and bank_currency = ?", (Object[])new Object[]{bankVersionID, bankCurrency});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)this.BANK_CURRENCY_ENTITY, (String)selectProperties, (QFilter[])filter.toArray());
        BankCurrencyKey key = new BankCurrencyKey();
        if (dynamicObject != null) {
            String isoCode = dynamicObject.getString("number");
            String bankCurr = dynamicObject.getString("bank_currency");
            String bankVersionId = dynamicObject.getString("bank_version.number");
            bc.setBankCurrency(bankCurr);
            key.setIsoCode(isoCode);
            key.setBankVersionId(bankVersionId);
        } else {
            key.setIsoCode(bankCurrency);
            key.setBankVersionId(bankVersionID);
        }
        bc.setKey(key);
        return bc;
    }

    public List<BankCurrency> findByBankVersionId(String bankVersionId, String customID) {
        return null;
    }

    public List<BankCurrency> findAllByCutomID(String customID) {
        return this.findAll();
    }

    public List<BankCurrency> findAllByCutomIDAndBankVersionIn(String customID, List<String> bankVersions) {
        return null;
    }

    public List<BankCurrency> findAll() {
        ArrayList<BankCurrency> bankCurrencyList = new ArrayList<BankCurrency>(1);
        Map map = BusinessDataServiceHelper.loadFromCache((String)this.BANK_CURRENCY_ENTITY, (String)this.selectProperties, null);
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                BankCurrency bankCurrency = new BankCurrency();
                String isoCode = dynamicObject.getString("number");
                String bankCurr = dynamicObject.getString("bank_currency");
                String bankVersionId = dynamicObject.getString("bank_version.number");
                bankCurrency.setBankCurrency(bankCurr);
                BankCurrencyKey key = new BankCurrencyKey();
                key.setIsoCode(isoCode);
                key.setBankVersionId(bankVersionId);
                bankCurrency.setKey(key);
                bankCurrencyList.add(bankCurrency);
            }
        }
        return bankCurrencyList;
    }

    public BankCurrency findOne(BankCurrencyKey key) {
        BankCurrency bankCurrency = null;
        String selectFields = "bank_currency";
        QFilter filter = QFilter.of((String)"number=? and bank_version.number=?", (Object[])new Object[]{key.getIsoCode(), key.getBankVersionId()});
        List<DynamicObject> dynamicObjectList = QueryCacheUtil.getDynamicObjectList(this.BANK_CURRENCY_ENTITY, selectFields, filter.toArray());
        if (dynamicObjectList != null && dynamicObjectList.size() > 0) {
            DynamicObject dynamicObject = dynamicObjectList.get(0);
            bankCurrency = new BankCurrency();
            bankCurrency.setBankCurrency(dynamicObject.getString("bank_currency"));
        }
        return bankCurrency;
    }

    public DynamicObject findByID(Long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        return QueryServiceHelper.queryOne((String)this.BANK_CURRENCY_ENTITY, (String)this.selectProperties, (QFilter[])filter.toArray());
    }

    public boolean existsById(BankCurrencyKey key) {
        QFilter filter = QFilter.of((String)"number=? and bank_version.number=?", (Object[])new Object[]{key.getIsoCode(), key.getBankVersionId()});
        boolean result = QueryServiceHelper.exists((String)this.BANK_CURRENCY_ENTITY, (QFilter[])filter.toArray());
        return result;
    }
}

