/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.properties;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;

public class ObjectPropertiesRepository {
    private String ENTITY_NAME = "aqap_object_properties";
    private static ObjectPropertiesRepository instance = new ObjectPropertiesRepository();

    public static ObjectPropertiesRepository getInstance() {
        return instance;
    }

    public List<ObjectProperties> findByCustomID(String customID) {
        return new ArrayList<ObjectProperties>(1);
    }

    public List<ObjectProperties> findByCustomIDAndObjectNameAndObjectID(String customID, String objectName, String objectID) {
        return new ArrayList<ObjectProperties>(1);
    }

    public ObjectProperties findByAttrKeyAndObjectNameAndObjectID(String attrKey, String objectName, String objectID) {
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setAttrKey(attrKey);
        key.setObjectID(objectID);
        key.setObjectName(objectName);
        return this.findById(key);
    }

    public ObjectProperties findById(ObjectPropertiesKey key) {
        ObjectProperties objectProp = null;
        String selectFields = "attr_value";
        QFilter filter = QFilter.of((String)"object_id=? and object_name=? and attr_key=?", (Object[])new Object[]{key.getObjectID(), key.getObjectName(), key.getAttrKey()});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)this.ENTITY_NAME, (String)selectFields, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            objectProp = new ObjectProperties();
            objectProp.setKey(key);
            objectProp.setAttrDesc(dynamicObject.getString("attr_value"));
            objectProp.setAttrValue(dynamicObject.getString("attr_value"));
        }
        return objectProp;
    }

    public ObjectProperties save(ObjectProperties objectProperties) {
        return objectProperties;
    }

    public DynamicObject loadDynamicObject(String key, String objectId, String objectName) {
        QFilter filter = QFilter.of((String)"object_id=? and object_name=? and attr_key=?", (Object[])new Object[]{objectId, objectName, key});
        return BusinessDataServiceHelper.loadSingle((String)this.ENTITY_NAME, (String)"attr_key, attr_value, object_id, object_name", (QFilter[])filter.toArray());
    }

    public void save(String key, String val, String objectId, String objectName) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_NAME);
        dataEntity.set("attr_key", (Object)key);
        dataEntity.set("attr_value", (Object)val);
        dataEntity.set("object_id", (Object)objectId);
        dataEntity.set("object_name", (Object)objectName);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    public void update(String accountID, String newAccountID) {
        DynamicObject[] dynamicObject;
        for (DynamicObject dynamicObject1 : dynamicObject = this.findOneById(accountID)) {
            dynamicObject1.set("custom_id", (Object)newAccountID);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObject);
    }

    public DynamicObject[] findOneById(String customID) {
        String selectProperties = "id, custom_id";
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)selectProperties, (QFilter[])filter.toArray());
        return dynamicObject;
    }
}

