/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DTFactoryUtil {
    static final String MODE = "yyyy-MM-dd HH:mm:ss";
    static final String MODE1 = "yyyy-MM-dd HH:mm:ss.S";
    static final String MODE2 = "yyyy-MM-dd HH:mm:ss.SS";
    static final String MODE3 = "yyyy-MM-dd HH:mm:ss.SSS";

    public static DateTimeFormatter getDateTimeFormatter(String timeString) {
        DateTimeFormatter dtf = null;
        String[] splits = timeString.split("\\.");
        if (splits.length == 2) {
            int len = splits[1].length();
            if (len == 1) {
                dtf = DateTimeFormatter.ofPattern(MODE1);
            } else if (len == 2) {
                dtf = DateTimeFormatter.ofPattern(MODE2);
            } else if (len == 3) {
                dtf = DateTimeFormatter.ofPattern(MODE3);
            }
        } else {
            dtf = DateTimeFormatter.ofPattern(MODE);
        }
        return dtf;
    }

    public static LocalDateTime parseDateTime(String time) {
        return LocalDateTime.parse(time, DTFactoryUtil.getDateTimeFormatter(time));
    }

    public static LocalDate parseDate(String time) {
        return LocalDate.parse(time, DTFactoryUtil.getDateTimeFormatter(time));
    }

    public static LocalDateTime parseDateTime(Date date) {
        Timestamp timestamp = new Timestamp(date.getTime());
        return timestamp.toLocalDateTime();
    }
}

