/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.file;

import com.google.common.io.Resources;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.file.CleanPathUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;

public class PropertiesUtils {
    private static final PropertiesUtils instance = new PropertiesUtils();
    private Properties props;

    public static PropertiesUtils getInstance() {
        return instance;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public static String getValue(String key) {
        String value;
        PropertiesUtils propertiesUtils = PropertiesUtils.getInstance();
        if (propertiesUtils.getProps() == null) {
            propertiesUtils.setProps(new Properties());
            String fileNamePath = System.getProperty("user.dir") + "/config/aqapcloud.properties";
            try {
                if (FileCommonUtils.getFileByPath(fileNamePath).exists()) {
                    fileNamePath = CleanPathUtil.cleanString(fileNamePath);
                    try (FileInputStream in = new FileInputStream(fileNamePath);){
                        propertiesUtils.getProps().load(new InputStreamReader((InputStream)in, "utf-8"));
                    }
                }
                URL url = Resources.getResource((String)"aqapcloud.properties");
                try (InputStream in = url.openStream();){
                    propertiesUtils.getProps().load(new InputStreamReader(in, "utf-8"));
                }
                if (key == null || "".equalsIgnoreCase(key)) {
                    throw new NullPointerException(ResManager.loadKDString((String)"key\u503c\u4e3a\u7a7a", (String)"PropertiesUtils_0", (String)"ebg-egf-common", (Object[])new Object[0]));
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        if (key.startsWith("${") && key.endsWith("}")) {
            key = key.substring(2, key.length() - 1);
        }
        if (PropertiesUtils.isEmpty(value = propertiesUtils.getProps().getProperty(key)) || value.equalsIgnoreCase("null")) {
            value = "";
        }
        return PropertiesUtils.match(value);
    }

    public static <T> T getValue(String key, Class<T> requiredType) {
        String value = PropertiesUtils.getValue(key);
        Object obj = "";
        if (requiredType.isAssignableFrom(List.class)) {
            String[] temp = value.split(",");
            ArrayList<String> list = new ArrayList<String>(1);
            for (String str : temp) {
                list.add(str);
            }
            obj = list;
        } else if (requiredType.isAssignableFrom(Integer.class)) {
            if (PropertiesUtils.isEmpty(value)) {
                value = "0";
            }
            obj = Integer.parseInt(value);
        } else if (requiredType.isAssignableFrom(Long.class)) {
            if (PropertiesUtils.isEmpty(value)) {
                value = "0";
            }
            obj = Long.valueOf(value);
        } else if (requiredType.isAssignableFrom(Boolean.class)) {
            if (PropertiesUtils.isEmpty(value)) {
                value = "false";
            }
            obj = Boolean.parseBoolean(value);
        } else if (requiredType.isAssignableFrom(String.class)) {
            obj = PropertiesUtils.isEmpty(value) ? "" : value;
        }
        return (T)obj;
    }

    public static String parse(String value) {
        int index = value.indexOf(":");
        String prop = value.substring(0, index);
        String defaultVal = System.getenv(prop);
        if (PropertiesUtils.isEmpty(defaultVal) && index != 0 && index < value.length() - 1) {
            defaultVal = value.substring(index + 1);
        }
        value = defaultVal;
        return value;
    }

    public static String match(String value) {
        Stack<Integer> matchStack = new Stack<Integer>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> tempList = new ArrayList<String>(16);
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '$' && value.charAt(i + 1) == '{') {
                matchStack.push(i);
                continue;
            }
            if (i > 1 && value.charAt(i) == '{' && value.charAt(i - 1) != '$') {
                matchStack.push(i);
                continue;
            }
            if (i > 1 && value.charAt(i) == '}') {
                int index = Integer.parseInt(String.valueOf(matchStack.pop()));
                if (i <= index || value.charAt(index) != '$') continue;
                if (!PropertiesUtils.isEmpty(sb.toString())) {
                    tempList.add(sb.toString());
                    sb = new StringBuilder();
                }
                tempList.add(PropertiesUtils.parse(value.substring(index + 2, i)));
                continue;
            }
            if (!matchStack.isEmpty()) continue;
            sb.append(value.charAt(i));
        }
        String tempStr = sb.toString();
        StringBuilder rsb = new StringBuilder();
        if (tempList.size() > 0) {
            for (int i = 0; i < tempList.size(); ++i) {
                if (PropertiesUtils.isEmpty((String)tempList.get(i))) continue;
                rsb.append((String)tempList.get(i));
            }
            tempStr = rsb.toString();
        }
        return tempStr;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

