/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import kd.bos.krpc.common.utils.NetUtils;

public class NetUtil {
    public static final String LOCAL_IP = "127.0.0.1";

    public static String longToIpv4(long longIP) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(longIP >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIP & 0xFFL));
        return sb.toString();
    }

    public static boolean isUsableLocalPort(int port) {
        if (!NetUtil.isValidPort(port)) {
            return false;
        }
        try {
            new Socket(LOCAL_IP, port).close();
            return false;
        }
        catch (Exception var2) {
            return true;
        }
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static String hideIpPart(String ip) {
        return new StringBuilder(ip.length()).append(ip.substring(0, ip.lastIndexOf(".") + 1)).append("*").toString();
    }

    public static String hideIpPart(long ip) {
        return NetUtil.hideIpPart(NetUtil.longToIpv4(ip));
    }

    public static String getLocalhostStr() {
        return NetUtils.getLocalHost();
    }

    public static InetAddress getLocalhost() {
        return NetUtils.getLocalAddress();
    }

    public static String getMacAddress() {
        return NetUtil.getMacAddress(NetUtils.getLocalAddress());
    }

    public static String getMacAddress(InetAddress inetAddress) {
        return NetUtil.getMacAddress(inetAddress, "-");
    }

    public static String getMacAddress(InetAddress inetAddress, String separator) {
        if (null == inetAddress) {
            return null;
        }
        byte[] mac = null;
        try {
            mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (null != mac) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append(separator);
                }
                sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
            }
            return sb.toString();
        }
        return null;
    }

    public static InetSocketAddress createAddress(String host, int port) {
        return new InetSocketAddress(host, port);
    }
}

