/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.zookeeper.client;

import java.util.List;
import kd.bos.zk.ZKFactory;
import kd.ebg.egf.common.zookeeper.client.AbstractZookeeperClient;
import kd.ebg.egf.common.zookeeper.cluster.URL;
import kd.ebg.egf.common.zookeeper.listener.ChildListener;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.Stat;

public class CuratorZookeeperClient
extends AbstractZookeeperClient<CuratorWatcher> {
    private final CuratorFramework client;

    public CuratorZookeeperClient(URL url) {
        super(url);
        this.client = ZKFactory.getZKClient((String)url.getConnectString());
    }

    @Override
    public void delete(String path) {
        try {
            this.client.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getChildren(String path) {
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.client.getZookeeperClient().isConnected();
    }

    @Override
    protected void doClose() {
        this.client.close();
    }

    @Override
    protected void createPersistent(String path, String data) {
        try {
            String returnPath = (String)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.PERSISTENT)).forPath(path, data.getBytes("UTF-8"));
            this.logger.info("\u521b\u5efa\u6301\u4e45\u8282\u70b9\u6210\u529f : {}", (Object)returnPath);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void createEphemeral(String path, String data) {
        try {
            String returnPath = (String)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(path, data.getBytes("UTF-8"));
            this.logger.info("\u521b\u5efa\u4e34\u65f6\u8282\u70b9\u6210\u529f : {}", (Object)returnPath);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected CuratorWatcher createTargetChildListener(String path, ChildListener listener) {
        return new CuratorWatcherImpl(listener);
    }

    @Override
    protected List<String> addTargetChildListener(String path, CuratorWatcher listener) {
        try {
            return (List)((BackgroundPathable)this.client.getChildren().usingWatcher(listener)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void removeTargetChildListener(String path, CuratorWatcher listener) {
        ((CuratorWatcherImpl)listener).unwatch();
    }

    public CuratorFramework getCuratorFramework() {
        return this.client;
    }

    @Override
    public boolean checkNodeExist(String path) {
        try {
            Stat star = (Stat)this.client.checkExists().forPath(path);
            if (star != null) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("checkNodeExist-\u68c0\u67e5\u8282\u70b9\u662f\u5426\u5b58\u5728\u5f02\u5e38{}", (Object)e.getMessage());
            return false;
        }
        return false;
    }

    private class CuratorWatcherImpl
    implements CuratorWatcher {
        private volatile ChildListener listener;

        public CuratorWatcherImpl(ChildListener listener) {
            this.listener = listener;
        }

        public void unwatch() {
            this.listener = null;
        }

        public void process(WatchedEvent event) throws Exception {
            CuratorZookeeperClient.this.logger.info("\u4e8b\u4ef6\u89e6\u53d1 : {}", (Object)event);
            if (this.listener != null) {
                this.listener.childChanged(event.getPath(), (List)((BackgroundPathable)CuratorZookeeperClient.this.client.getChildren().usingWatcher((CuratorWatcher)this)).forPath(event.getPath()));
            }
        }
    }
}

