/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.zsb.opa.services.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.FetchTokenUtils;
import kd.ebg.note.banks.zsb.opa.services.utils.SdkInit;

public class CancelImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CancelImpl.class);

    public boolean parseNoteSides(String rspStr) {
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        if (!"000000".equalsIgnoreCase(statusCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u64a4\u9500\u7968\u636e\u67e5\u8be2\u5f02\u5e38\u3002", (String)"CancelImpl_0", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
        }
        JSONObject jsonBody = root.getJSONObject("body");
        JSONObject PageResponse = jsonBody.getJSONObject("pageResponse");
        int totalRows = PageResponse.getInteger("totalRows");
        int totalPages = PageResponse.getInteger("totalPages");
        if (totalRows == 0 || totalPages == 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8be5\u7968\u636e\u65e0\u6cd5\u53d1\u8d77\u64a4\u9500\uff0c\u8bf7\u5728\u7f51\u94f6\u786e\u8ba4\u7968\u636e\u72b6\u6001\u3002", (String)"CancelImpl_1", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]));
        }
        return true;
    }

    public boolean getMessage(String accno, String billNo, String startNo, String endNo, String busiType) {
        String rspStr = "";
        boolean details = false;
        try {
            int pageTag = 1;
            SdkInit.init();
            ApiHeader header = new ApiHeader();
            header.setMsgtype("nbts_searchCanRepealBillInfoYqt");
            header.setTraceno(Sequence.genSequence());
            String token = FetchTokenUtils.getToken();
            header.setToken(token);
            HashMap<String, Object> body = new HashMap<String, Object>(1);
            body.put("certifyAcctNo", accno);
            body.put("billNo", billNo);
            body.put("rangeStart", startNo);
            body.put("rangeEnd", endNo);
            body.put("busiType", busiType);
            body.put("custAcctNo", accno);
            body.put("eleSign", Sequence.gen16Sequence());
            HashMap<String, Integer> PageRequest = new HashMap<String, Integer>(1);
            PageRequest.put("pageSize", 100);
            PageRequest.put("currentPage", pageTag);
            body.put("PageRequest", PageRequest);
            logger.info("\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString(body));
            ApiRspData data = ServiceBean.getService((String)SdkInit.getTenantKey()).invoke(header, body);
            rspStr = JSON.toJSONString((Object)data);
            logger.info("\u6d59\u5546\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
            if (!"000000".equalsIgnoreCase(data.getResultcode())) {
                SdkInit.checkToken(token);
            }
            details = this.parseNoteSides(rspStr);
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6d59\u5546\u67e5\u8be2\u5f02\u5e38\uff1a%1$s\u3002", (String)"CancelImpl_2", (String)"ebg-note-banks-zsb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return details;
    }
}

