/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.bocom.dc.service.note.receivable.pledge;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.bocom.dc.service.note.receivable.pledge.QueryPledgeNoteReceivableImpl;
import kd.ebg.note.banks.bocom.dc.service.note.util.BOCOM_DC_NotePacker;
import kd.ebg.note.banks.bocom.dc.service.note.util.BOCOM_DC_Parser;
import kd.ebg.note.banks.bocom.dc.service.note.util.CommonUtils;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PledgeNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(PledgeNoteReceivableImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPledgeNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo receivableInfo = (NoteReceivableInfo)receivableInfos.get(0);
        Element root = BOCOM_DC_NotePacker.packRootForNote("420305", "");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"QryAcct", (String)receivableInfo.getDrawerAccNo());
        JDomUtils.addChild((Element)body, (String)"IdNb", (String)receivableInfo.getBillNo());
        JDomUtils.addChild((Element)body, (String)"OperateFlag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"ApplDt", (String)DateUtil.formatDate((Date)new Date()));
        JDomUtils.addChild((Element)body, (String)"BtchNb", (String)receivableInfo.getDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"RmrkByPropsr", (String)receivableInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"Biztyp", (String)"0");
        JDomUtils.addChild((Element)body, (String)"CollztnAcctId", (String)"");
        JDomUtils.addChild((Element)body, (String)"PawneeName", (String)"");
        JDomUtils.addChild((Element)body, (String)"PawneeAcctSvcr", (String)"");
        JDomUtils.addChild((Element)body, (String)"QryDt", (String)CommonUtils.createClientTime());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if ("0000".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u72b6\u6001\u7801\uff0c\u9700\u8981\u4eba\u5de5\u786e\u8ba4\u4ea4\u6613\u72b6\u6001", (String)"PledgeNoteReceivableImpl_0", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return noteReceivableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "420305";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d28\u62bc", (String)"PledgeNoteReceivableImpl_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

