/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.noteReceivable;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.note.business.noteReceivable.util.NoteReceivableConvert;
import kd.ebg.note.business.noteReceivable.util.NoteReceivableUtil;
import kd.ebg.note.business.util.AccessUtils;
import kd.ebg.note.common.entity.biz.notereceivable.NoteReceivableRequest;
import kd.ebg.note.common.entity.biz.notereceivable.NoteReceivableResponse;
import kd.ebg.note.common.framework.services.NoteReceivableInfoService;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.slf4j.MDC;

public class NoteReceivableMethod
implements EBServiceMethod<NoteReceivableRequest, NoteReceivableResponse> {
    EBGLogger logger = EBGLogger.getInstance().getLogger(NoteReceivableMethod.class);

    public NoteReceivableResponse executeClientRequest(NoteReceivableRequest request, EBContext context) throws MalformedURLException {
        AccessUtils.checkQueryAllowed(context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        try {
            this.checkStructure(request);
            String batchSeqID = request.getBody().getBatchSeqId();
            this.checkBatchSeqIDUnique(batchSeqID);
        }
        catch (IllegalArgumentException e) {
            this.logger.info("error\uff1a " + e.getMessage());
            throw EBExceiptionUtil.preCheckException((Throwable)e);
        }
        catch (Exception e) {
            this.logger.info("error2\uff1a " + e.getMessage());
            this.logger.info("error3\uff1a " + e.getLocalizedMessage());
            throw EBExceiptionUtil.preCheckException((Throwable)e);
        }
        List<NoteReceivableInfo> noteReceivableInfos = NoteReceivableConvert.convertPay(request);
        NoteReceivableUtil.preTreatment(noteReceivableInfos);
        Set<List<NoteReceivableInfo>> set = NoteReceivableConvert.packagePay(noteReceivableInfos);
        set = NoteReceivableUtil.reloadData(set);
        NoteReceivableUtil.insertPay(noteReceivableInfos);
        NoteReceivableUtil.async(set, request, context.getAcnt());
        return NoteReceivableConvert.convertToResponse(noteReceivableInfos, request);
    }

    private void checkStructure(NoteReceivableRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoteReceivableMethod_0", (String)"ebg-note-business", (Object[])new Object[0]));
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoteReceivableMethod_1", (String)"ebg-note-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42 body \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoteReceivableMethod_2", (String)"ebg-note-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoteReceivableMethod_3", (String)"ebg-note-business", (Object[])new Object[0]));
        }
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "noteReceivable";
    }

    private void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"NoteReceivableMethod_4", (String)"ebg-note-business", (Object[])new Object[0]));
        Preconditions.checkState((!NoteReceivableInfoService.getInstance().batchSeqIDExist(batchSeqID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"batchSeqID \u5df2\u7ecf\u5b58\u5728\u3002", (String)"NoteReceivableMethod_5", (String)"ebg-note-business", (Object[])new Object[0]));
    }
}

