/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.noteReceivable.util;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;
import kd.ebg.note.business.noteReceivable.atomic.INoteReceivable;
import kd.ebg.note.business.noteReceivable.atomic.INoteReceivablePretreat;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.BankNoteReceivableTask;
import kd.ebg.note.business.util.EBThreadPools;
import kd.ebg.note.common.entity.biz.notereceivable.NoteReceivableRequest;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.frame.BankBundleManager;
import kd.ebg.note.common.framework.services.NoteReceivableInfoService;
import kd.ebg.note.common.framework.utils.CurrencyUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;
import kd.ebg.note.common.utils.SpringContextUtil;
import net.sf.json.JSONObject;

public class NoteReceivableUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(NoteReceivableUtil.class);

    public static void preTreatment(List<NoteReceivableInfo> noteReceivableInfos) {
        for (NoteReceivableInfo info : noteReceivableInfos) {
            NoteReceivableUtil.preTreatmentEach(info);
            logger.info("\u5f53\u524d\u8bb0\u5f55\u7684\u8def\u7531\u4fe1\u606f\u4e3a:" + info.getPackageKey());
        }
    }

    private static void preTreatmentEach(NoteReceivableInfo info) {
        StringBuilder packageKey = new StringBuilder();
        packageKey.append("acceptorAccNo=").append(info.getAcceptorAccNo()).append(";").append("detail_seq_id=").append(info.getDetailSeqId()).append(";").append("bizType=").append(info.getBizType()).append(";").append("subBizType=").append(info.getSubBizType()).append(";");
        info.setPackageKey(packageKey.toString());
        String bankVersionID = info.getBankVersionID();
        INoteReceivablePretreat pretreat = (INoteReceivablePretreat)BankBundleManager.getInstance().getImpl(bankVersionID, INoteReceivablePretreat.class, (Object)info);
        if (pretreat == null) {
            INoteReceivable pay = (INoteReceivable)BankBundleManager.getInstance().getImpl(bankVersionID, INoteReceivable.class, (Object)info);
            IQueryNoteReceivable queryPayImpl = null;
            Class<? extends IQueryNoteReceivable> queryPayImplClass = pay.defaultQueryClass();
            if (Objects.nonNull(queryPayImplClass)) {
                queryPayImpl = (IQueryNoteReceivable)BankBundleManager.getInstance().getImplByClassName(info.getBankVersionID(), IQueryNoteReceivable.class, queryPayImplClass.getName());
            }
            if (Objects.isNull(queryPayImpl)) {
                queryPayImpl = (IQueryNoteReceivable)BankBundleManager.getInstance().getImpl(bankVersionID, IQueryNoteReceivable.class, (Object)info);
                info.setQueryImplClassName(queryPayImpl.getClass().getName());
            }
            info.setImplClassName(pay.getClass().getName());
        } else {
            pretreat.appendData(info);
        }
        info.setStatus(Integer.valueOf(PaymentState.INITIAL.getId()));
        info.setStatusName(PaymentState.INITIAL.getEnName());
        info.setStatusMsg(PaymentState.INITIAL.getCnName());
    }

    public static void insertPay(List<NoteReceivableInfo> notePayableInfos) {
        LocalDateTime insertTime = LocalDateTime.now();
        notePayableInfos.forEach(info -> {
            info.setInsertTime(insertTime);
            info.setEbgID(((SingleNodeIDGetter)SpringContextUtil.getBean(SingleNodeIDGetter.class)).nodeID());
        });
        NoteReceivableInfoService.getInstance().save(notePayableInfos);
    }

    public static void async(Set<List<NoteReceivableInfo>> set, NoteReceivableRequest request, BankAcnt bankAcnt) {
        String extDate = request.getHeader().getExtData();
        String loggerBankNo = "";
        try {
            if (extDate != null) {
                JSONObject object = JSONObject.fromObject((Object)extDate);
                loggerBankNo = (String)object.get("loggerBankNo");
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u65e5\u5fd7\u8ddf\u8e2a\u53f7\u5f02\u5e38\uff1a", (Object)e);
        }
        for (List<NoteReceivableInfo> infos : set) {
            BankNoteReceivableRequest notePayableRequest = NoteReceivableUtil.prepareBankPayRequest(infos, bankAcnt);
            NoteReceivableInfo receivableInfo = infos.get(0);
            for (int i = 0; i < infos.size(); ++i) {
                NoteReceivableInfo info = infos.get(i);
                info.setBankSerialNo(i + 1 + "");
            }
            String bankVersion = receivableInfo.getBankVersionID();
            String bizType = "noteReceivable";
            String customerId = receivableInfo.getCustomID();
            String batchSeqId = receivableInfo.getBatchSeqId();
            String requestSeqId = String.valueOf(request.getHeader().getRequestSeqID());
            String logRequestSeqId = String.valueOf(request.getHeader().getLogRequestSeqID());
            String logBizSeqId = String.valueOf(request.getHeader().getLogBizSeqID());
            if (StringUtils.isEmpty((String)loggerBankNo)) {
                loggerBankNo = receivableInfo.getBankBatchSeqId();
            }
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID(requestSeqId).bizName(bizType).subBizName(bizType).bankVersionID(bankVersion).bizSeqID(batchSeqId).bankLoginID(EBContext.getContext().getBankLoginID()).logRequestSeqID(logRequestSeqId).logBizSeqID(logBizSeqId).loggerBatchNo(batchSeqId).loggerDetailNo(receivableInfo.getBankBatchSeqId()).loggerBankNo(loggerBankNo).build();
            context.setBankAcnt(bankAcnt);
            String bankLoginId = notePayableRequest.getHeader().getAcnt().getBankLoginId();
            String bankBatchSeqID = infos.get(0).getBankBatchSeqId();
            BigDecimal totalAmount = infos.get(0).getTotalAmount();
            notePayableRequest.setBankBatchSeqID(bankBatchSeqID);
            notePayableRequest.setNoteReceivableInfos(infos);
            notePayableRequest.setTotalAmount(totalAmount);
            notePayableRequest.setTotalCount(infos.size());
            EBThreadPools.getNoteReceivable(customerId, bankLoginId).submit((Callable)((Object)new BankNoteReceivableTask(notePayableRequest, context)));
        }
    }

    private static BankNoteReceivableRequest prepareBankPayRequest(List<NoteReceivableInfo> noteReceivableInfos, BankAcnt acnt) {
        BankNoteReceivableRequest payableRequest = new BankNoteReceivableRequest();
        if (noteReceivableInfos.size() > 0) {
            NoteReceivableInfo info = noteReceivableInfos.get(0);
            payableRequest.setNoteReceivableInfos(noteReceivableInfos);
            payableRequest.setTotalCount(noteReceivableInfos.size());
            payableRequest.setTotalAmount(NoteReceivableUtil.getTotalAmount(noteReceivableInfos));
            payableRequest.setBankBatchSeqID(info.getBankBatchSeqId());
            payableRequest.setHeader(NoteReceivableUtil.getHeader(info, acnt));
        }
        return payableRequest;
    }

    public static BigDecimal getTotalAmount(List<NoteReceivableInfo> infos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        if (!Objects.isNull(infos)) {
            for (NoteReceivableInfo info : infos) {
                bigDecimal = bigDecimal.add(info.getAmount());
            }
        }
        return bigDecimal;
    }

    private static BankHeader getHeader(NoteReceivableInfo info, BankAcnt bankAcnt) {
        BankHeader header = new BankHeader();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(bankAcnt.getAccNo(), info.getCustomID());
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        header.setCustomerID(info.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqId());
        header.setLogBizSeqID(info.getBatchSeqId());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(acnt);
        header.setClientName("ebc_bankNoteReceivableTask");
        header.setClientVersion("1.0");
        return header;
    }

    public static Set<List<NoteReceivableInfo>> reloadData(Set<List<NoteReceivableInfo>> set) {
        for (List<NoteReceivableInfo> infos : set) {
            BigDecimal amountCount = new BigDecimal(0);
            for (NoteReceivableInfo notePayableInfo : infos) {
                amountCount = amountCount.add(notePayableInfo.getAmount());
            }
            for (int i = 0; i < infos.size(); ++i) {
                NoteReceivableInfo info = infos.get(i);
                info.setBankSerialNo(i + 1 + "");
                info.setTotalSize(Integer.valueOf(infos.size()));
                info.setBatchTotalAmount(amountCount);
            }
        }
        return set;
    }
}

