/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.payable.accept;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.Packer;
import kd.ebg.note.banks.ceb.dc.service.Parser;
import kd.ebg.note.banks.ceb.dc.service.payable.accept.QueryAcceptNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class AcceptNotePayableImpl
extends AbstractNotePayableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryAcceptNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e003039";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151 (b2e003039)", (String)"AcceptNotePayableImpl_0", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        CEBHelper.configFactory(factory, "b2e003039");
        super.configFactory(factory);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        NotePayableInfo info = request.getNotePayableInfosAsArray()[0];
        Element root = Packer.createNoteHead("b2e003039");
        Element reqData = root.getChild("TransContent").getChild("ReqData");
        JDomUtils.addChild((Element)reqData, (String)"BillId", (String)info.getObssid());
        JDomUtils.addChild((Element)reqData, (String)"OperStatus", (String)"1");
        JDomUtils.addChild((Element)reqData, (String)"IsSafety", (String)"0");
        JDomUtils.addChild((Element)reqData, (String)"AcNo", (String)info.getAcceptorAccNo());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseNoteHeader(root);
        if ("system.args".equals(response.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else if (!"0000".equals(response.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return notePayableInfos;
    }
}

