/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.payable.register;

import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.Packer;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class NotePacker {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NotePacker.class);

    public String packPay(NotePayableInfo[] notePayableInfos) throws EBServiceException {
        BankAcnt acnt;
        this.logger.info("*****\u51fa\u7968*****");
        NotePayableInfo info = notePayableInfos[0];
        Element root = Packer.createNoteHead("b2e003003");
        Element reqData = root.getChild("TransContent").getChild("ReqData");
        JDomUtils.addChild((Element)reqData, (String)"AcNo", (String)info.getDrawerAccNo());
        boolean isSameBank = false;
        if (SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)info.getPayeeBankName()).equals("1")) {
            isSameBank = true;
        }
        if ("AC02".equals(info.getDraftType()) && !isSameBank) {
            JDomUtils.addChild((Element)reqData, (String)"AcName2", (String)info.getAcceptorAccName());
        }
        if ("AC01".equals(info.getDraftType())) {
            JDomUtils.addChild((Element)reqData, (String)"AcptBranch", (String)info.getReserved4());
        }
        if ("AC02".equals(info.getDraftType())) {
            JDomUtils.addChild((Element)reqData, (String)"BankType", (String)(isSameBank ? "0" : "1"));
        }
        if ("AC01".equals(info.getDraftType()) && (acnt = RequestContextUtils.getRequestContext().getAcnt()) != null && info.getDrawerAccNo().equals(acnt.getAccNo())) {
            JDomUtils.addChild((Element)reqData, (String)"AcptBranch", (String)acnt.getAccDept());
        }
        if (!isSameBank) {
            JDomUtils.addChild((Element)reqData, (String)"AcptBankNo", (String)info.getAcceptorBankCnaps());
            JDomUtils.addChild((Element)reqData, (String)"AcptBankName", (String)info.getAcceptorBankName());
        }
        if ("AC02".equals(info.getDraftType())) {
            JDomUtils.addChild((Element)reqData, (String)"AcNo2", (String)info.getAcceptorAccNo());
        }
        JDomUtils.addChild((Element)reqData, (String)"BillType", (String)info.getDraftType());
        JDomUtils.addChild((Element)reqData, (String)"Isendo", (String)info.getTransferFlag());
        this.logger.info("*****1\u3001\u6dfb\u52a0\u7b7e\u53d1\u6279\u6b21\u4fe1\u606f***");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }
}

