/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.news.receivable.payment;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.LoginUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.receivable.payment.QueryPaymentImpl;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Content;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        LoginUtils.login();
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CPEN011", Sequence.genSequence());
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomExtUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        JDomExtUtils.addChildCDData(common, "Txn_Tdnum", "1");
        JDomExtUtils.addChildCDData(common, "Bl_Tamt", receivableInfos[0].getAmount().toPlainString());
        Element Bktsfk_GRP = JDomExtUtils.addChild((Element)common, (String)"G_GROUP");
        JDomExtUtils.addChildCDData(Bktsfk_GRP, "Txn_SN", "1");
        JDomExtUtils.addChildCDData(Bktsfk_GRP, "Bill_No", receivableInfos[0].getBillNo());
        String grdBag = receivableInfos[0].getGrdBag();
        if (StringUtils.isEmpty((String)grdBag)) {
            JDomExtUtils.addChildCDData(Bktsfk_GRP, "SbBll_Rng_Strt_SN", "0");
            JDomExtUtils.addChildCDData(Bktsfk_GRP, "SbBll_Rng_End_SN", "0");
        } else {
            JDomExtUtils.addChildCDData(Bktsfk_GRP, "SbBll_Rng_Strt_SN", receivableInfos[0].getStartNo());
            JDomExtUtils.addChildCDData(Bktsfk_GRP, "SbBll_Rng_End_SN", receivableInfos[0].getEndNo());
        }
        JDomExtUtils.addChildCDData(Bktsfk_GRP, "Bl_Aply_Amt", receivableInfos[0].getAmount().toString());
        JDomExtUtils.addChildCDData(Bktsfk_GRP, "Aply_Psn_AccNo", receivableInfos[0].getDrawerAccNo());
        JDomExtUtils.addChildCDData(Bktsfk_GRP, "Bl_Aply_Psn_AccNm", receivableInfos[0].getDrawerAccName());
        JDomExtUtils.addChildCDData(Bktsfk_GRP, "Aply_Psn_DepBnk_BrNo", receivableInfos[0].getDrawerBankCnaps());
        JDomExtUtils.addChildCDData(Bktsfk_GRP, "Bl_Aply_Psn_Rmrk", receivableInfos[0].getExplanation());
        JDomExtUtils.addChildCDData(Bktsfk_GRP, "Bl_Prtc_SgnSl_MtdCd", "PS01");
        JDomExtUtils.addChildCDData(Bktsfk_GRP, "Bl_Prtc_Elc_Sgn", "");
        JDomExtUtils.addChildCDData(Bktsfk_GRP, "ExgBill_Plc_StlMd", StringUtils.isEmpty((String)receivableInfos[0].getSettleWay()) ? "ST01" : receivableInfos[0].getSettleWay());
        JDomExtUtils.addChildCDData(Bktsfk_GRP, "ExgBill_Plc_Clrg_Tp", StringUtils.isEmpty((String)receivableInfos[0].getClearType()) ? "CT01" : receivableInfos[0].getClearType());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        CCBHCBankResponse rsp1 = CommonParser.getFrontResponse(rsp);
        if (!rsp1.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%1$s %2$s\u3002", (String)"PaymentImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp1.getResponseCode(), rsp1.getResponseMessage()));
        }
        rsp = rsp1.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rsp);
        if (!bankResp.isSuccess()) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            List list = response.getChildren("G_GROUP");
            for (Element element : list) {
                String BkListNo1 = element.getChildText("TxnSrlNo");
                EBGNoteReceivableUtils.setNoteBatchNo((List)receivableInfos, (String)BkListNo1);
                EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)bankResp.getResponseCode(), (String)String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u6210\u529f%s\u3002", (String)"PaymentImpl_1", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseMessage()));
            }
        }
        return receivableInfos;
    }
}

