/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.note.payable.register;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.FileInfoNode;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.NoteFileUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.utils.PropertiesConstantsUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class RegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);
    private static final String SEPERATOR = "|";

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1ECDS221";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u7533\u8bf7", (String)"RegisterNotePayableImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        NotePayableInfo info;
        int i;
        List infos = request.getNotePayableInfoList();
        NotePayableInfo paymentInfo = (NotePayableInfo)infos.get(0);
        String datestr = DateUtil.formatDate((Date)new Date());
        String custid = RequestContextUtils.getBankParameterValue((String)"custid");
        String fileName = "05" + datestr + "4" + custid + ".txt";
        StringBuilder sBuffer = new StringBuilder();
        if ("AC02".equals(paymentInfo.getDraftType())) {
            fileName = "05" + datestr + "1" + custid + ".txt";
            sBuffer.append(PropertiesConstantsUtils.getValue((String)"ccbccipRegister"));
            sBuffer.append("\r\n");
            for (i = 0; i < infos.size(); ++i) {
                info = (NotePayableInfo)infos.get(i);
                sBuffer.append("AC02").append(SEPERATOR);
                sBuffer.append(info.getAmount()).append(SEPERATOR);
                sBuffer.append(info.getIssueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append(SEPERATOR);
                sBuffer.append(info.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append(SEPERATOR);
                sBuffer.append("EM00").append(SEPERATOR);
                sBuffer.append(info.getDrawerAccName()).append(SEPERATOR);
                sBuffer.append(info.getDrawerAccNo()).append(SEPERATOR);
                sBuffer.append(info.getDrawerBankCnaps()).append(SEPERATOR);
                sBuffer.append(info.getDrawerBankName()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append(info.getExplanation()).append(SEPERATOR);
                sBuffer.append(info.getAcceptorAccName()).append(SEPERATOR);
                sBuffer.append(info.getAcceptorAccNo()).append(SEPERATOR);
                sBuffer.append(info.getAcceptorBankCnaps()).append(SEPERATOR);
                sBuffer.append(info.getAcceptorBankName()).append(SEPERATOR);
                sBuffer.append(info.getPayeeAccName()).append(SEPERATOR);
                sBuffer.append(info.getPayeeAccNo()).append(SEPERATOR);
                sBuffer.append(info.getPayeeBankCnaps()).append(SEPERATOR);
                sBuffer.append(info.getPayeeBankName()).append(SEPERATOR);
                sBuffer.append("0001").append(SEPERATOR);
                sBuffer.append("\r\n");
            }
        } else {
            sBuffer.append(ResManager.loadKDString((String)"#\u7535\u5b50\u7968\u636e\u53f7\u7801|\u56de\u590d\u4eba\u540d\u79f0|\u56de\u590d\u4eba\u8d26\u53f7|\u56de\u590d\u4eba\u5f00\u6237\u884c\u884c\u53f7|\u56de\u590d\u6807\u8bb0|\u539fECDS\u5e73\u53f0\u65e5\u671f|\u539fECDS\u5e73\u53f0\u6d41\u6c34|\u56de\u590d\u4eba\u5907\u6ce8|", (String)"RegisterNotePayableImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
            sBuffer.append("\r\n");
            for (i = 0; i < infos.size(); ++i) {
                info = (NotePayableInfo)infos.get(i);
                sBuffer.append(info.getBillNo()).append(SEPERATOR);
                sBuffer.append(info.getContractNo()).append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append("").append(SEPERATOR);
                sBuffer.append(info.getIssueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append(SEPERATOR);
                sBuffer.append(info.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append(SEPERATOR);
                sBuffer.append(info.getExplanation()).append(SEPERATOR);
                sBuffer.append(info.getTransferFlag()).append(SEPERATOR);
                sBuffer.append("\r\n");
            }
        }
        String fileContent = sBuffer.toString();
        NoteFileUtils fileUtils = new NoteFileUtils();
        FileInfoNode fileInfoNode = fileUtils.getFileInfoNodes(fileContent, fileName);
        try {
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb:\u6587\u4ef6\u540d=" + fileInfoNode.getFileName());
            String message = fileUtils.uploadFile(fileInfoNode);
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6210\u529f.\u6587\u4ef6\u5185\u5bb9\uff1a");
            this.logger.info(fileInfoNode.getFileContent());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002", (String)"RegisterNotePayableImpl_3", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), (Throwable)e);
        }
        Element root = new Element("Transaction");
        Element body = JDomUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1ECDS221", Sequence.genSequence());
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        Element file = JDomUtils.addChild((Element)common, (String)"FILE_LIST_PACK");
        JDomUtils.addChild((Element)file, (String)"FILE_NUM", (String)"1");
        Element fileInfo = JDomUtils.addChild((Element)file, (String)"FILE_INFO");
        JDomUtils.addChild((Element)fileInfo, (String)"FILE_NAME", (String)fileName);
        JDomUtils.addChild((Element)fileInfo, (String)"Msg_Smy", (String)fileInfoNode.getMd5());
        JDomUtils.addChild((Element)common, (String)"BkInstNo", (String)"");
        JDomUtils.addChild((Element)common, (String)"BkElctSgn", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)common, (String)"BkNum1", (String)"1");
        JDomUtils.addChild((Element)common, (String)"BkType", (String)"0001");
        JDomUtils.addChild((Element)common, (String)"BkType2", (String)paymentInfo.getDraftType());
        JDomUtils.addChild((Element)common, (String)"BkDetail1", (String)fileInfoNode.getMd5());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        CCBHCBankResponse rsp = CommonParser.getFrontResponse(responseStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%1$s %2$s\u3002", (String)"RegisterNotePayableImpl_6", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        responseStr = rsp.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            String BkListNo1 = response.getChildText("BkListNo1");
            EBGNotePayableUtils.setBatchNo((List)notePayableInfos, (String)BkListNo1);
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)bankResp.getResponseCode(), (String)String.format(ResManager.loadKDString((String)"%s\u63d0\u4ea4\u94f6\u884c\u6210\u529f\u3002", (String)"RegisterNotePayableImpl_7", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseMessage()));
        }
        return notePayableInfos;
    }
}

