/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.payable.confirm;

import java.io.File;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.banks.cib.dc.services.util.Util;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class ConfirmNoteImpl
extends AbstractNotePayableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ConfirmNoteImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "NEWEBCONFIRMDRAWFINTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u786e\u8ba4\u5408\u540c", (String)"ConfirmNoteImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String fileName = Util.getFileName(info.getReserved4(), "fileName");
        String path = RequestContextUtils.getBankParameterValue((String)"contractPath");
        String filepath = "";
        filepath = path.endsWith(File.separator) ? path + fileName : path + File.separator + fileName;
        this.logger.info(filepath);
        String md5 = Util.getMD5(new File(filepath));
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element REBUILDCONTRACTTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBCONFIRMDRAWFINTRNRQ");
        JDomUtils.addChild((Element)REBUILDCONTRACTTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element body = JDomUtils.addChild((Element)REBUILDCONTRACTTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)body, (String)"SIGNATURE", (String)"01");
        JDomUtils.addChild((Element)body, (String)"MDKEY", (String)md5);
        JDomUtils.addChild((Element)body, (String)"CLIENTREF", (String)Util.getFileName(info.getReserved4(), "clientref").split("_")[0]);
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBRECEDETRNRS = eb1.getChild("NEWEBCONFIRMDRAWFINTRNRS");
        Element STATUS = EBRECEDETRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            Element rsbody = EBRECEDETRNRS.getChild("RSBODY");
            String result = JDomUtils.getChildText((Element)rsbody, (String)"RESULT");
            String APPLYCODE = JDomUtils.getChildText((Element)rsbody, (String)"APPLYCODE");
            ((NotePayableInfo)notePayableInfos.get(0)).setRqstserialno(APPLYCODE);
            String message = rsbody.getChild("XFERPRCSTS").getChildText("MESSAGE");
            this.logger.info("result:" + result + ",message:" + message);
            if ("CG".equals(result)) {
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)message);
            } else {
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)result, (String)message);
            }
        }
        return notePayableInfos;
    }
}

