/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.payable.confirm;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.note.payable.confirm.QueryConfirmNotePayableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class ConfirmNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(ConfirmNotePayableImpl.class);

    public int getBatchSize() {
        return 10;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryConfirmNotePayableImpl.class;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String md5 = info.getReserved4();
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element REBUILDCONTRACTTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"CONFIRMDRAWFINTRNRQ");
        JDomUtils.addChild((Element)REBUILDCONTRACTTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element body = JDomUtils.addChild((Element)REBUILDCONTRACTTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)body, (String)"SIGNATURE", (String)"01");
        JDomUtils.addChild((Element)body, (String)"MDKEY", (String)md5);
        JDomUtils.addChild((Element)body, (String)"CLIENTREF", (String)info.getReserved2());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBRECEDETRNRS = eb1.getChild("CONFIRMDRAWFINTRNRS");
        Element STATUS = EBRECEDETRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            Element rsbody = EBRECEDETRNRS.getChild("RSBODY");
            String result = JDomUtils.getChildText((Element)rsbody, (String)"RESULT");
            String message = rsbody.getChild("XFERPRCSTS").getChildText("MESSAGE");
            this.logger.info("result:" + result + ",message:" + message);
            if ("CG".equals(result)) {
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)result, (String)message);
            } else {
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)result, (String)message);
            }
        }
        return notePayableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u786e\u8ba4\u5408\u540c", (String)"ConfirmNotePayableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

