/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.codeless.receivable.endorse;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.codeless.receivable.QueryReceivableImpl;
import kd.ebg.note.banks.spdb.dc.services.codeless.receivable.QueryResultUtil;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CodelessEndorseImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryReceivableImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PJ12";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u65b0\u7968\u80cc\u4e66\u63a5\u53e3", (String)"CodelessEndorseImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest request, String s) {
        NoteReceivableInfo[] infos = request.getNotePayableInfosAsArray();
        BankAcnt acnt = request.getAcnt();
        Element root = new Element("body");
        JDomUtils.addChild((Element)root, (String)"totalNumber", (String)(infos.length + ""));
        JDomUtils.addChild((Element)root, (String)"totalAmount", (String)infos[0].getAmount().toPlainString());
        JDomUtils.addChild((Element)root, (String)"transMasterID", (String)BankBusinessConfig.getPayMasterID(acnt.getAccNo()));
        JDomUtils.addChild((Element)root, (String)"remark", (String)infos[0].getExplanation());
        Element lists = new Element("lists");
        lists.setAttribute("name", "edraftList");
        JDomUtils.addChild((Element)root, (Element)lists);
        for (int i = 0; i < infos.length; ++i) {
            Element list = new Element("list");
            JDomUtils.addChild((Element)lists, (Element)list);
            JDomUtils.addChild((Element)list, (String)"sequenceNo", (String)"0001");
            JDomUtils.addChild((Element)list, (String)"billPackageNo", (String)infos[i].getBillNo());
            String startNo = infos[i].getStartNo();
            String endNo = infos[i].getEndNo();
            JDomUtils.addChild((Element)list, (String)"sonBillRngLow", (String)startNo);
            JDomUtils.addChild((Element)list, (String)"sonBillRngHight", (String)endNo);
            JDomUtils.addChild((Element)list, (String)"eBillAmount", (String)infos[i].getDraftAmount().toString());
            JDomUtils.addChild((Element)list, (String)"applyAmount", (String)infos[i].getAmount().toString());
            JDomUtils.addChild((Element)list, (String)"endorsederAcctName", (String)acnt.getAccName());
            JDomUtils.addChild((Element)list, (String)"endorsederAcctNo", (String)acnt.getAccNo());
            JDomUtils.addChild((Element)list, (String)"endorsederBankNo", (String)infos[i].getDrawerBankCnaps());
            JDomUtils.addChild((Element)list, (String)"canTransferFlag", (String)infos[0].getTransferFlag());
            JDomUtils.addChild((Element)list, (String)"endorsedApplyDate", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
            JDomUtils.addChild((Element)list, (String)"endorsedeeAcctName", (String)infos[i].getPayeeAccName());
            JDomUtils.addChild((Element)list, (String)"endorsedeeAcctNo", (String)infos[i].getPayeeAccNo());
            JDomUtils.addChild((Element)list, (String)"endorsedeeBankNo", (String)infos[i].getPayeeBankCnaps());
            JDomUtils.addChild((Element)list, (String)"endorsedeeBankName", (String)infos[i].getPayeeBankName());
            JDomUtils.addChild((Element)list, (String)"endorsedeeUnfSocCrdtNo");
        }
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("PJ12", signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String rspStr) {
        List infos = request.getNoteReceivableInfos();
        QueryResultUtil.parserCommon(infos, rspStr);
        return infos;
    }
}

